/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import java.io.IOException;

public class ThresholdBufferAllocator
implements BufferAllocator {
    private BufferAllocator smallBufferAllocator;
    private BufferAllocator largeBufferAllocator;
    private int threshold;

    public ThresholdBufferAllocator(BufferAllocator bufferAllocator, BufferAllocator bufferAllocator2, int n) {
        this.smallBufferAllocator = bufferAllocator;
        this.largeBufferAllocator = bufferAllocator2;
        this.threshold = n;
    }

    @Override
    public Buffer allocate(int n) {
        if (n <= this.threshold) {
            return this.smallBufferAllocator.allocate(n);
        }
        return this.largeBufferAllocator.allocate(n);
    }

    @Override
    public void close() throws IOException {
        try {
            this.smallBufferAllocator.close();
        }
        finally {
            this.largeBufferAllocator.close();
        }
    }
}

