/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.buffer;

import com.treasuredata.partition.mpc.buffer.Buffer;
import com.treasuredata.partition.mpc.buffer.BufferAllocator;
import com.treasuredata.partition.mpc.buffer.IoBufferAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class AdaptiveIoBufferAllocator
implements IoBufferAllocator {
    private BufferAllocator parentAllocator;
    private long totalCapacity;
    private int preferedSize;
    private int minSize;
    private AtomicLong allocatedSize;

    public AdaptiveIoBufferAllocator(BufferAllocator bufferAllocator, long l, int n, int n2) {
        this.parentAllocator = bufferAllocator;
        this.totalCapacity = l;
        this.preferedSize = n;
        this.minSize = n2;
        this.allocatedSize = new AtomicLong(0L);
    }

    @Override
    public Buffer allocate(int n) {
        AdaptiveIoBuffer adaptiveIoBuffer = new AdaptiveIoBuffer(this.parentAllocator.allocate(n));
        n = adaptiveIoBuffer.size();
        this.allocatedSize.addAndGet(n);
        return adaptiveIoBuffer;
    }

    @Override
    public Buffer allocateIoBuffer() {
        int n = AdaptiveIoBufferAllocator.calculateIoBufferSize(this.allocatedSize.get(), this.totalCapacity, this.preferedSize, this.minSize);
        return this.allocate(n);
    }

    private void release(AdaptiveIoBuffer adaptiveIoBuffer) {
        int n = adaptiveIoBuffer.size();
        adaptiveIoBuffer.buffer.release();
        this.allocatedSize.addAndGet(-n);
    }

    private static int calculateIoBufferSize(long l, long l2, int n, int n2) {
        do {
            if (l >= (l2 /= 2L)) continue;
            return n;
        } while ((n /= 2) > n2);
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.parentAllocator.close();
    }

    private class AdaptiveIoBuffer
    implements Buffer {
        private Buffer buffer;

        public AdaptiveIoBuffer(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.buffer.getByteBuffer();
        }

        @Override
        public void release() {
            AdaptiveIoBufferAllocator.this.release(this);
        }

        public int size() {
            return this.buffer.getByteBuffer().capacity();
        }
    }
}

