/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc;

import com.treasuredata.partition.mpc.CompressionType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.Preconditions;

public class MessagePackerFactory {
    private final CompressionType compressionType;

    public MessagePackerFactory(CompressionType compressionType) throws IOException {
        this.compressionType = Preconditions.checkNotNull(compressionType, "compression type is null");
    }

    public MessagePacker openFile(File file) throws IOException {
        OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        OutputStream outputStream2 = null;
        switch (this.compressionType) {
            case GZIP: {
                outputStream2 = new GZIPOutputStream(outputStream);
                break;
            }
            default: {
                outputStream2 = outputStream;
            }
        }
        return MessagePack.newDefaultPacker(outputStream2);
    }
}

