/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc;

import com.treasuredata.partition.mpc.Packable;
import com.treasuredata.partition.mpc.SimpleBlockData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableArrayValue;
import org.msgpack.value.Value;

public class MPCFile {
    public static final byte[] CONTAINER_MAGIC = new byte[]{-58, 77, 80, 10};
    public static final byte[] BLOCK_MAGIC = new byte[]{77, 80, 67, 49};
    private static final int MAGIC_HEADER_SIZE = 8;

    protected MPCFile() {
    }

    public static Header readHeader(ReadableByteChannel readableByteChannel, long l) throws IOException {
        return MPCFile.readHeaderAndColumnInfo(readableByteChannel, l, false).getHeader();
    }

    public static HeaderAndColumnInfo readHeaderAndColumnInfo(ReadableByteChannel readableByteChannel, long l) throws IOException {
        return MPCFile.readHeaderAndColumnInfo(readableByteChannel, l, true);
    }

    private static HeaderAndColumnInfo readHeaderAndColumnInfo(ReadableByteChannel readableByteChannel, long l, boolean bl) throws IOException {
        boolean bl2 = false;
        int n = (int)Math.min(l, 1024L);
        Object object = new byte[n];
        int n2 = 0;
        while (true) {
            Object object2;
            try {
                MPCFile.readFully(readableByteChannel, object, n2, ((byte[])object).length - n2);
                n2 = ((byte[])object).length;
                object2 = Header.parseHeader(object, l);
                ArrayList<ColumnInfo> arrayList = null;
                if (bl) {
                    arrayList = ((Header)object2).readColumnInfo((byte[])object);
                }
                return new HeaderAndColumnInfo((Header)object2, arrayList);
            }
            catch (InsufficientHeaderLengthException insufficientHeaderLengthException) {
                if (l - 8L < (long)n) {
                    throw new EOFException(String.format("insufficient header size: expected %,d, but the input file has %,d bytes", n + 8, l));
                }
                if (bl2) {
                    throw new IOException(String.format("Failed to read header: header size: %,d (current read size:%,d)", insufficientHeaderLengthException.getExpectedHeaderSize(), n));
                }
                n = insufficientHeaderLengthException.getExpectedHeaderSize();
                bl2 = insufficientHeaderLengthException.isExactSize();
                object2 = new byte[n];
                System.arraycopy(object, 0, object2, 0, ((byte[])object).length);
                object = object2;
                continue;
            }
            break;
        }
    }

    public static byte[] writeHeader(byte[] byArray, SimpleBlockData simpleBlockData, Packable packable, int n, long[] lArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Header.encodeHeader(byteArrayOutputStream, byArray, simpleBlockData, packable, n, lArray);
        return byteArrayOutputStream.toByteArray();
    }

    private static int readFully(ReadableByteChannel readableByteChannel, byte[] byArray) throws IOException {
        return MPCFile.readFully(readableByteChannel, byArray, 0, byArray.length);
    }

    private static int readFully(ReadableByteChannel readableByteChannel, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        int n3 = 0;
        while (byteBuffer.hasRemaining()) {
            int n4 = readableByteChannel.read(byteBuffer);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
        return n3;
    }

    private static boolean bytesEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public static class ColumnInfo {
        private final byte[] name;
        private final long offset;
        private final long size;
        private boolean opened;

        public ColumnInfo(byte[] byArray, long l, long l2) {
            this.name = byArray;
            this.offset = l;
            this.size = l2;
            this.opened = false;
        }

        public byte[] getName() {
            return this.name;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getSize() {
            return this.size;
        }

        public void setOpened() {
            this.opened = true;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public static ArrayList<byte[]> parseColumnNamesBlock(byte[] byArray, int n, int n2) throws IOException {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            if (n2 != 0) {
                MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(new GZIPInputStream(new ByteArrayInputStream(byArray, n, n2)));
                while (messageUnpacker.hasNext()) {
                    int n3 = messageUnpacker.unpackRawStringHeader();
                    byte[] byArray2 = new byte[n3];
                    messageUnpacker.readPayload(byArray2);
                    arrayList.add(byArray2);
                }
                messageUnpacker.close();
            }
            return arrayList;
        }

        public String toString() {
            return String.format("cinfo={name=%s, offset=%d, size=%d, opened=%b}", new String(this.name), this.offset, this.size, this.opened);
        }
    }

    public static class Header {
        public static final int INDEX = 0;
        public static final int EXPECTED_MAX_HEADER_SIZE = 1024;
        private final byte[] blockType;
        private final Value blockData;
        private final Value metadata;
        private final int indexType;
        private final long[] headerIndex;
        private final int dataOffset;

        public Header(byte[] byArray, Value value, Value value2, int n, long[] lArray, int n2) {
            this.blockType = byArray;
            this.blockData = value;
            this.metadata = value2;
            this.indexType = n;
            this.headerIndex = lArray;
            this.dataOffset = n2;
        }

        public byte[] getBlockType() {
            return this.blockType;
        }

        public Value getBlockData() {
            return this.blockData;
        }

        public SimpleBlockData getSimpleBlockData() throws IOException {
            return SimpleBlockData.readFrom(this.blockData);
        }

        public int getIndexType() {
            return this.indexType;
        }

        public long[] getHeaderIndex() {
            return this.headerIndex;
        }

        public Value getMetadata() {
            return this.metadata;
        }

        public int getDataOffset() {
            return this.dataOffset;
        }

        public static Header parseHeader(byte[] byArray, long l) throws IOException {
            if (byArray.length < 8) {
                throw new InsufficientHeaderLengthException(8, false);
            }
            if (!MPCFile.bytesEquals(byArray, 0, CONTAINER_MAGIC, 0, 4)) {
                throw new InvalidMPCFormatException(String.format("Unknown container type: '%s'", new String(byArray, 0, 4, MessagePack.UTF8)));
            }
            int n = ByteBuffer.wrap(byArray, 4, 4).getInt();
            if (n > byArray.length - 8) {
                throw new InsufficientHeaderLengthException(n + 8, false);
            }
            MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(byArray, 8, n);
            ImmutableArrayValue immutableArrayValue = messageUnpacker.unpackValue().asArrayValue();
            if (immutableArrayValue.size() < 4) {
                throw new InvalidMPCFormatException("invalid header format: array size = " + immutableArrayValue.size());
            }
            byte[] byArray2 = immutableArrayValue.get(0).asRawValue().asByteArray();
            Value value = immutableArrayValue.get(1);
            Value value2 = immutableArrayValue.get(2);
            int n2 = immutableArrayValue.get(3).asIntegerValue().asInt();
            if (!Arrays.equals(byArray2, BLOCK_MAGIC)) {
                throw new InvalidMPCFormatException(String.format("Unknown block type '%s'", new String(byArray2)));
            }
            int n3 = 8 + n;
            int n4 = n - (int)messageUnpacker.getTotalReadBytes();
            long[] lArray = Header.parseIndexBlock(byArray, n3 - n4, n4);
            switch (n2) {
                case 0: {
                    if (lArray.length != 0) break;
                    lArray = new long[]{l - (long)n3};
                    break;
                }
                default: {
                    throw new InvalidMPCFormatException("Unknown index type " + n2);
                }
            }
            return new Header(byArray2, value, value2, n2, lArray, n3);
        }

        public static void encodeIndexBlock(OutputStream outputStream, long[] lArray) throws IOException {
            byte[] byArray = new byte[9];
            for (long l : lArray) {
                int n = byArray.length - 1;
                int n2 = 0;
                do {
                    byArray[n - n2] = (byte)(l & 0x7FL);
                    ++n2;
                } while ((l >>= 7) > 0L);
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x80);
                n = n + 1 - n2;
                outputStream.write(byArray, n, n2);
            }
        }

        public static long[] parseIndexBlock(byte[] byArray) throws IOException {
            return Header.parseIndexBlock(byArray, 0, byArray.length);
        }

        public static long[] parseIndexBlock(byte[] byArray, int n, int n2) throws IOException {
            long[] lArray = new long[n2];
            int n3 = 0;
            long l = 0L;
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                byte by = byArray[i];
                if (by < 0) {
                    l <<= 7;
                    if ((l |= (long)(by & 0x7F)) == 0L) break;
                    if (l < 0L) {
                        throw new InvalidMPCFormatException("Invalid index format");
                    }
                    lArray[n3++] = l;
                    l = 0L;
                    continue;
                }
                l <<= 7;
                l |= (long)by;
            }
            long[] lArray2 = new long[n3];
            System.arraycopy(lArray, 0, lArray2, 0, n3);
            return lArray2;
        }

        public static int encodeHeader(OutputStream outputStream, byte[] byArray, SimpleBlockData simpleBlockData, Packable packable, int n, long[] lArray) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MessagePacker messagePacker = MessagePack.newDefaultPacker(byteArrayOutputStream);
            messagePacker.packArrayHeader(4);
            messagePacker.packRawStringHeader(byArray.length);
            messagePacker.writePayload(byArray);
            simpleBlockData.packTo(messagePacker);
            if (packable == null) {
                messagePacker.packArrayHeader(0);
            } else {
                packable.packTo(messagePacker);
            }
            messagePacker.packInt(n);
            if (lArray.length > 1) {
                messagePacker.flush();
                Header.encodeIndexBlock(byteArrayOutputStream, lArray);
            }
            messagePacker.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4]).putInt(byArray2.length);
            outputStream.write(CONTAINER_MAGIC);
            outputStream.write(byteBuffer.array());
            outputStream.write(byArray2);
            return byArray2.length;
        }

        private int getColumnNameBlockSize() throws InvalidMPCFormatException {
            long[] lArray = this.headerIndex;
            long l = lArray[0];
            if (l > Integer.MAX_VALUE) {
                throw new InvalidMPCFormatException("The header size should be less than 2GB (2^31-1)");
            }
            return (int)l;
        }

        public ArrayList<ColumnInfo> readColumnInfo(byte[] byArray) throws IOException {
            int n = this.getColumnNameBlockSize();
            if (byArray.length < this.dataOffset + n) {
                throw new InsufficientHeaderLengthException(this.dataOffset + n, true);
            }
            ArrayList<byte[]> arrayList = ColumnInfo.parseColumnNamesBlock(byArray, this.dataOffset, n);
            if (arrayList.isEmpty()) {
                return new ArrayList<ColumnInfo>();
            }
            long l = this.dataOffset + n;
            ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>();
            for (int i = 1; i < this.headerIndex.length; ++i) {
                long l2 = this.headerIndex[i];
                ColumnInfo columnInfo = new ColumnInfo(arrayList.get(i - 1), l, l2);
                l += l2;
                arrayList2.add(columnInfo);
            }
            return arrayList2;
        }

        public String toString() {
            return "Header{blockType=" + Arrays.toString(this.blockType) + ", blockData=" + this.blockData + ", metadata=" + this.metadata + ", indexType=" + this.indexType + ", headerIndex=" + Arrays.toString(this.headerIndex) + ", dataOffset=" + this.dataOffset + '}';
        }
    }

    public static class InsufficientHeaderLengthException
    extends IOException {
        private final int expectedHeaderSize;
        private final boolean isExact;

        public InsufficientHeaderLengthException(int n, boolean bl) {
            this.expectedHeaderSize = n;
            this.isExact = bl;
        }

        public boolean isExactSize() {
            return this.isExact;
        }

        public int getExpectedHeaderSize() {
            return this.expectedHeaderSize;
        }
    }

    public static class InvalidMPCFormatException
    extends IOException {
        public InvalidMPCFormatException(String string) {
            super(string);
        }
    }

    public static class HeaderAndColumnInfo {
        private final Header header;
        private final ArrayList<ColumnInfo> columnList;

        public HeaderAndColumnInfo(Header header, ArrayList<ColumnInfo> arrayList) {
            this.header = header;
            this.columnList = arrayList;
        }

        public Header getHeader() {
            return this.header;
        }

        public ArrayList<ColumnInfo> getColumnList() {
            return this.columnList;
        }
    }
}

