/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.provider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.treasuredata.partition.io.IOProvider;
import com.treasuredata.partition.io.IORequestFilter;
import com.treasuredata.partition.io.auth.RackSpaceAuthentication;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class RackSpaceProvider
implements IOProvider {
    private static final Logger log = Logger.getLogger(RackSpaceProvider.class.getName());
    private static final String TOKEN_URL = "https://identity.api.rackspacecloud.com/v2.0/tokens";
    private static final ObjectReader OBJECT_READER = new ObjectMapper().enable(DeserializationFeature.UNWRAP_ROOT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).reader(TokenResponse.class).withRootName("access");
    private static final String TOKEN_TEMPLATE = "{\n\"auth\":\n   {\n      \"RAX-KSKEY:apiKeyCredentials\":\n      {\n         \"username\": \"%s\",\n         \"apiKey\": \"%s\"\n      }\n   }\n}";
    private final String region;
    private final boolean internal;
    private final CountDownLatch started = new CountDownLatch(1);
    private final AtomicLong expires = new AtomicLong();
    private final AtomicReference<URI> endpoint = new AtomicReference();
    private final AtomicReference<String> token = new AtomicReference();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final byte[] tokenRequest;

    public RackSpaceProvider(String string, String string2, String string3, boolean bl) {
        this.region = string;
        this.internal = bl;
        this.tokenRequest = String.format(TOKEN_TEMPLATE, string2, string3).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint.get();
    }

    @Override
    public List<IORequestFilter> getFilters() {
        return ImmutableList.of(new RackSpaceAuthentication(this.token.get()));
    }

    @Override
    public void start() {
        this.executor.scheduleAtFixedRate(this::fetchToken, 0L, 1L, TimeUnit.HOURS);
        try {
            this.started.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.failure.get() != null) {
            throw new RuntimeException(this.failure.get());
        }
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchToken() {
        if (this.expires.get() > System.currentTimeMillis() + TimeUnit.HOURS.toMillis(12L)) {
            return;
        }
        boolean bl = this.token.get() == null;
        try {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(TOKEN_URL).openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "application/json");
            httpsURLConnection.setRequestProperty("User-Agent", "Presto-Client");
            httpsURLConnection.setDoOutput(true);
            try (Closeable closeable = httpsURLConnection.getOutputStream();){
                ((OutputStream)closeable).write(this.tokenRequest);
                ((OutputStream)closeable).flush();
            }
            closeable = httpsURLConnection.getInputStream();
            var4_5 = null;
            try {
                int n = httpsURLConnection.getResponseCode();
                if (n != 200) {
                    byte[] byArray = new byte[1024];
                    ((InputStream)closeable).read(byArray);
                    String string = String.format("Token Response error %d, %s", n, new String(byArray, StandardCharsets.UTF_8));
                    log.warning(string);
                    this.failure.set(new Exception(string));
                    return;
                }
                TokenResponse tokenResponse = (TokenResponse)OBJECT_READER.readValue((InputStream)closeable);
                Token token = tokenResponse.getToken();
                Endpoint endpoint = tokenResponse.getCatalog("object-store").getEndpoint(this.region);
                this.token.set(token.getId());
                this.expires.set(token.getExpires());
                if (this.internal) {
                    this.endpoint.set(URI.create(endpoint.getInternalURL()));
                } else {
                    this.endpoint.set(URI.create(endpoint.getPublicURL()));
                }
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var4_5 != null) {
                        try {
                            ((InputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, iOException.getMessage(), iOException);
            this.failure.set(iOException);
        }
        finally {
            if (bl) {
                this.started.countDown();
            }
        }
    }

    static class Endpoint {
        private final String region;
        private final String publicURL;
        private final String internalURL;

        @JsonCreator
        public Endpoint(@JsonProperty(value="region") String string, @JsonProperty(value="publicURL") String string2, @JsonProperty(value="internalURL") String string3) {
            this.region = string;
            this.publicURL = string2;
            this.internalURL = string3;
        }

        public String getRegion() {
            return this.region;
        }

        public String getPublicURL() {
            return this.publicURL;
        }

        public String getInternalURL() {
            return this.internalURL;
        }
    }

    static class ServiceCatalog {
        private final String name;
        private final String type;
        private final List<Endpoint> endpoints;

        @JsonCreator
        public ServiceCatalog(@JsonProperty(value="name") String string, @JsonProperty(value="type") String string2, @JsonProperty(value="endpoints") List<Endpoint> list) {
            this.name = string;
            this.type = string2;
            this.endpoints = list;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Endpoint getEndpoint(String string) {
            return this.endpoints.stream().filter(endpoint -> string.equals(endpoint.getRegion())).findFirst().get();
        }
    }

    static class Token {
        private static final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime();
        private final String id;
        private final long expires;

        @JsonCreator
        public Token(@JsonProperty(value="id") String string, @JsonProperty(value="expires") String string2) {
            this.id = string;
            this.expires = DATE_TIME_FORMATTER.parseDateTime(string2).getMillis();
        }

        public String getId() {
            return this.id;
        }

        public long getExpires() {
            return this.expires;
        }
    }

    static class TokenResponse {
        private final Token token;
        private final List<ServiceCatalog> catalogs;

        @JsonCreator
        public TokenResponse(@JsonProperty(value="token") Token token, @JsonProperty(value="serviceCatalog") List<ServiceCatalog> list) {
            this.token = token;
            this.catalogs = list;
        }

        public ServiceCatalog getCatalog(String string) {
            return this.catalogs.stream().filter(serviceCatalog -> string.equals(serviceCatalog.getType())).findFirst().get();
        }

        public Token getToken() {
            return this.token;
        }
    }
}

