/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl.jetty;

import com.treasuredata.partition.io.buffer.IOBufferPool;
import com.treasuredata.partition.io.impl.jetty.ManagedHttpChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Promise;

public class ManagedHttpConnection
extends HttpConnectionOverHTTP {
    private static final int MAX_CONNECTION_REUSE = 80;
    private final AtomicInteger usedCount = new AtomicInteger(0);
    private final IOBufferPool bufferPool;

    public ManagedHttpConnection(EndPoint endPoint, HttpDestination httpDestination, Promise<Connection> promise, IOBufferPool iOBufferPool) {
        super(endPoint, httpDestination, promise);
        this.bufferPool = iOBufferPool;
    }

    public IOBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    protected HttpChannelOverHTTP newHttpChannel() {
        return new ManagedHttpChannel(this);
    }

    @Override
    public void release() {
        if (this.usedCount.incrementAndGet() > 80) {
            this.close();
        } else {
            super.release();
        }
    }

    @Override
    protected boolean abort(Throwable throwable) {
        boolean bl = super.abort(throwable);
        ((ManagedHttpChannel)this.getHttpChannel()).onClose();
        return bl;
    }

    @Override
    public void close(Throwable throwable) {
        super.close(throwable);
    }
}

