/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.auth;

import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.IORequestFilter;
import com.treasuredata.spark.thirdparty.com.google.common.base.Strings;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AwsV4Authentication
implements IORequestFilter {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String X_AMZ_DATE = "X-Amz-Date";
    private static final String X_AMZ_CONTENT_SHA256 = "X-Amz-Content-Sha256";
    private static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final char NEWLINE = '\n';
    private final String endpoint;
    private final String region;
    private final String service;
    private final String accessKey;
    private final String secretKey;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public AwsV4Authentication(String string, String string2, String string3, String string4, String string5) {
        this.endpoint = Objects.requireNonNull(Strings.emptyToNull(string), "endpoint is null");
        this.region = Objects.requireNonNull(Strings.emptyToNull(string2), "region is null");
        this.service = Objects.requireNonNull(Strings.emptyToNull(string3), "service is null");
        this.accessKey = Objects.requireNonNull(Strings.emptyToNull(string4), "access Key is null");
        this.secretKey = Objects.requireNonNull(Strings.emptyToNull(string5), "secret Key is null");
    }

    @Override
    public IORequest filter(IORequest iORequest) {
        List<String> list = Arrays.asList("Host", X_AMZ_CONTENT_SHA256, X_AMZ_DATE);
        String string = iORequest.getHeader(X_AMZ_DATE);
        if (string == null) {
            string = new DateTime(DateTimeZone.UTC).toString("YYYYMMdd'T'HHmmss'Z'");
            iORequest = iORequest.addHeader(X_AMZ_DATE, string);
        }
        if (iORequest.getHeader("Host") == null) {
            iORequest = iORequest.addHeader("Host", this.endpoint);
        }
        iORequest = iORequest.addHeader(X_AMZ_CONTENT_SHA256, UNSIGNED_PAYLOAD);
        String string2 = AwsV4Authentication.canonicalize(iORequest, list, UNSIGNED_PAYLOAD);
        String string3 = AwsV4Authentication.scope(string, this.region);
        String string4 = AwsV4Authentication.stringToSign(string, string3, string2);
        byte[] byArray = AwsV4Authentication.getSignatureKey(this.secretKey, string, this.region, this.service);
        byte[] byArray2 = AwsV4Authentication.HmacSHA256(string4, byArray);
        String string5 = String.format("AWS4-HMAC-SHA256 Credential=%s, SignedHeaders=%s, Signature=%s", this.credential(string3), AwsV4Authentication.signedHeader(list), AwsV4Authentication.toHex(byArray2));
        iORequest = iORequest.addHeader("Authorization", string5);
        return iORequest;
    }

    private static byte[] HmacSHA256(String string, byte[] byArray) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(new SecretKeySpec(byArray, HMAC_SHA256));
            return mac.doFinal(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw Throwables.propagate(generalSecurityException);
        }
    }

    private static byte[] hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Throwables.propagate(noSuchAlgorithmException);
        }
    }

    private String credential(String string) {
        return this.accessKey + "/" + string;
    }

    private static byte[] getSignatureKey(String string, String string2, String string3, String string4) {
        byte[] byArray = ("AWS4" + string).getBytes(StandardCharsets.UTF_8);
        return AwsV4Authentication.HmacSHA256("aws4_request", AwsV4Authentication.HmacSHA256(string4, AwsV4Authentication.HmacSHA256(string3, AwsV4Authentication.HmacSHA256(string2.substring(0, 8), byArray))));
    }

    private static String scope(String string, String string2) {
        return string.substring(0, 8) + "/" + string2 + "/s3/aws4_request";
    }

    private static String stringToSign(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(ALGORITHM).append('\n').append(string).append('\n').append(string2).append('\n').append(AwsV4Authentication.toHex(AwsV4Authentication.hash(string3)));
        return stringBuilder.toString();
    }

    private static String canonicalize(IORequest iORequest, List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append(iORequest.getMethod()).append('\n').append(iORequest.getUri().getPath()).append('\n').append(iORequest.getUri().getQuery()).append('\n');
        for (String string2 : list) {
            stringBuilder.append(string2.toLowerCase(Locale.ENGLISH)).append(':').append(iORequest.getHeader(string2).trim().replaceAll("\\s+", " ")).append('\n');
        }
        stringBuilder.append('\n');
        stringBuilder.append(AwsV4Authentication.signedHeader(list)).append('\n');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String signedHeader(List<String> list) {
        return list.stream().map(string -> string.toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(";"));
    }

    private static String toHex(byte[] byArray) {
        char[] cArray = new char[2 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[2 * i] = HEX_CHARS[(byArray[i] & 0xF0) >>> 4];
            cArray[2 * i + 1] = HEX_CHARS[byArray[i] & 0xF];
        }
        return new String(cArray);
    }
}

