/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

import com.treasuredata.partition.io.IOConfig;
import com.treasuredata.partition.io.IOManager;
import com.treasuredata.partition.io.IOServiceType;
import com.treasuredata.partition.io.impl.AlluxioIOManager;
import com.treasuredata.partition.io.impl.JettyIOManager;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Iterators;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class IOManagerFactory {
    private static final Map<IOServiceType, Map<String, Class<? extends IOManager>>> managerClasses = new HashMap<IOServiceType, Map<String, Class<? extends IOManager>>>();

    public static synchronized IOManager create(IOServiceType iOServiceType, Optional<String> optional, IOConfig iOConfig) {
        Map<String, Class<? extends IOManager>> map = Preconditions.checkNotNull(managerClasses.get((Object)iOServiceType), "No IOManager for %s", (Object)iOServiceType);
        if (!optional.isPresent() && map.size() == 1) {
            optional = Optional.of(Iterators.getOnlyElement(map.keySet().iterator()));
        }
        return IOManagerFactory.construct(Preconditions.checkNotNull(map.get(optional.get()), "No IOManager for %s/%s", (Object)iOServiceType, (Object)optional.get()), optional.get(), iOConfig);
    }

    private static IOManager construct(Class<? extends IOManager> clazz, String string, IOConfig iOConfig) {
        try {
            Constructor<? extends IOManager> constructor = clazz.getConstructor(String.class, IOConfig.class);
            return constructor.newInstance(string, iOConfig);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw Throwables.propagate(reflectiveOperationException);
        }
    }

    public static synchronized void install(IOServiceType iOServiceType, String string, Class<? extends IOManager> clazz) {
        managerClasses.putIfAbsent(iOServiceType, new HashMap());
        managerClasses.get((Object)iOServiceType).put(string, clazz);
    }

    public static IOManager createDefaultHttp() {
        return IOManagerFactory.createDefaultHttp(IOConfig.builder().http().build());
    }

    public static IOManager createDefaultHttp(IOConfig iOConfig) {
        Preconditions.checkArgument(iOConfig.getServiceType() == IOServiceType.HTTP, "require service type %s", (Object)IOServiceType.HTTP);
        return IOManagerFactory.create(iOConfig.getServiceType(), Optional.of("jetty"), iOConfig);
    }

    public static IOManager createIOManager(IOConfig iOConfig) {
        return IOManagerFactory.create(iOConfig.getServiceType(), Optional.empty(), iOConfig);
    }

    static {
        IOManagerFactory.install(IOServiceType.HTTP, "jetty", JettyIOManager.class);
        IOManagerFactory.install(IOServiceType.ALLUXIO, "alluxio", AlluxioIOManager.class);
    }
}

