/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.treasuredata.client.model.TDApiKey;
import com.treasuredata.spark.thirdparty.com.google.common.base.MoreObjects;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Lists;
import com.treasuredata.spark.thirdparty.com.google.common.primitives.Booleans;
import java.util.ArrayList;

final class ImmutableTDApiKey
extends TDApiKey {
    private final String keyType;
    private final Integer accountId;
    private final Integer userId;
    private final boolean isAdministrator;

    private ImmutableTDApiKey(String keyType, Integer accountId, Integer userId, boolean isAdministrator) {
        this.keyType = keyType;
        this.accountId = accountId;
        this.userId = userId;
        this.isAdministrator = isAdministrator;
    }

    @Override
    @JsonProperty(value="key_type")
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    @JsonProperty(value="account_id")
    public Integer getAccountId() {
        return this.accountId;
    }

    @Override
    @JsonProperty(value="user_id")
    public Integer getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="administrator")
    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public final ImmutableTDApiKey withKeyType(String keyType) {
        if (this.keyType.equals(keyType)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(keyType, "keyType");
        return new ImmutableTDApiKey(newValue, this.accountId, this.userId, this.isAdministrator);
    }

    public final ImmutableTDApiKey withAccountId(Integer accountId) {
        if (this.accountId.equals(accountId)) {
            return this;
        }
        Integer newValue = Preconditions.checkNotNull(accountId, "accountId");
        return new ImmutableTDApiKey(this.keyType, newValue, this.userId, this.isAdministrator);
    }

    public final ImmutableTDApiKey withUserId(Integer userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        Integer newValue = Preconditions.checkNotNull(userId, "userId");
        return new ImmutableTDApiKey(this.keyType, this.accountId, newValue, this.isAdministrator);
    }

    public final ImmutableTDApiKey withIsAdministrator(boolean isAdministrator) {
        if (this.isAdministrator == isAdministrator) {
            return this;
        }
        return new ImmutableTDApiKey(this.keyType, this.accountId, this.userId, isAdministrator);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTDApiKey && this.equalTo((ImmutableTDApiKey)another);
    }

    private boolean equalTo(ImmutableTDApiKey another) {
        return this.keyType.equals(another.keyType) && this.accountId.equals(another.accountId) && this.userId.equals(another.userId) && this.isAdministrator == another.isAdministrator;
    }

    public int hashCode() {
        int h2 = 31;
        h2 = h2 * 17 + this.keyType.hashCode();
        h2 = h2 * 17 + this.accountId.hashCode();
        h2 = h2 * 17 + this.userId.hashCode();
        h2 = h2 * 17 + Booleans.hashCode(this.isAdministrator);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TDApiKey").omitNullValues().add("keyType", this.keyType).add("accountId", this.accountId).add("userId", this.userId).add("isAdministrator", this.isAdministrator).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTDApiKey fromJson(Json json) {
        Builder builder = ImmutableTDApiKey.builder();
        if (json.keyType != null) {
            builder.keyType(json.keyType);
        }
        if (json.accountId != null) {
            builder.accountId(json.accountId);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.isAdministratorIsSet) {
            builder.isAdministrator(json.isAdministrator);
        }
        return builder.build();
    }

    public static ImmutableTDApiKey copyOf(TDApiKey instance) {
        if (instance instanceof ImmutableTDApiKey) {
            return (ImmutableTDApiKey)instance;
        }
        return ImmutableTDApiKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements TDApiKey.Builder {
        private static final long INIT_BIT_KEY_TYPE = 1L;
        private static final long INIT_BIT_ACCOUNT_ID = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long INIT_BIT_IS_ADMINISTRATOR = 8L;
        private long initBits = 15L;
        private String keyType;
        private Integer accountId;
        private Integer userId;
        private boolean isAdministrator;

        private Builder() {
        }

        public final Builder from(TDApiKey instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.keyType(instance.getKeyType());
            this.accountId(instance.getAccountId());
            this.userId(instance.getUserId());
            this.isAdministrator(instance.isAdministrator());
            return this;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = Preconditions.checkNotNull(keyType, "keyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder accountId(Integer accountId) {
            this.accountId = Preconditions.checkNotNull(accountId, "accountId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder userId(Integer userId) {
            this.userId = Preconditions.checkNotNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public final Builder isAdministrator(boolean isAdministrator) {
            this.isAdministrator = isAdministrator;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        public ImmutableTDApiKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTDApiKey(this.keyType, this.accountId, this.userId, this.isAdministrator);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("keyType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accountId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isAdministrator");
            }
            return "Cannot build TDApiKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TDApiKey {
        String keyType;
        Integer accountId;
        Integer userId;
        boolean isAdministrator;
        boolean isAdministratorIsSet;

        Json() {
        }

        @JsonProperty(value="key_type")
        public void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @JsonProperty(value="account_id")
        public void setAccountId(Integer accountId) {
            this.accountId = accountId;
        }

        @JsonProperty(value="user_id")
        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        @JsonProperty(value="administrator")
        public void setIsAdministrator(boolean isAdministrator) {
            this.isAdministrator = isAdministrator;
            this.isAdministratorIsSet = true;
        }

        @Override
        public String getKeyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getAccountId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAdministrator() {
            throw new UnsupportedOperationException();
        }
    }
}

