/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.TDApiRequest;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDRequestErrorHandler;
import com.treasuredata.spark.thirdparty.okhttp3.OkHttpClient;
import com.treasuredata.spark.thirdparty.okhttp3.Request;
import com.treasuredata.spark.thirdparty.okhttp3.Response;
import java.io.IOException;

public interface TDHttpRequestHandler<Result> {
    default public Request prepareRequest(Request request) {
        return request;
    }

    default public boolean isSuccess(ResponseContext responseContext) {
        return responseContext.response.isSuccessful();
    }

    default public Response send(OkHttpClient httpClient, Request request) throws IOException {
        return httpClient.newCall(request).execute();
    }

    public Result onSuccess(Response var1) throws Exception;

    default public TDClientException resolveHttpResponseError(ResponseContext responseContext) throws TDClientException {
        return TDRequestErrorHandler.defaultHttpResponseErrorResolver(responseContext);
    }

    default public TDClientException resolveError(Throwable e) throws TDClientException {
        return TDRequestErrorHandler.defaultErrorResolver(e);
    }

    default public byte[] onError(Response response) throws IOException {
        try {
            return response.body().bytes();
        }
        catch (IOException e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
        }
    }

    public static class ResponseContext {
        public final TDApiRequest apiRequest;
        public final Response response;

        public ResponseContext(TDApiRequest apiRequest, Response response) {
            this.apiRequest = apiRequest;
            this.response = response;
        }
    }
}

