/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.TDClientException;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;

public class ProxyConfig {
    private final String host;
    private final int port;
    private final boolean useSSL;
    private final Optional<String> user;
    private final Optional<String> password;

    public ProxyConfig(String host, int port, boolean useSSL, Optional<String> user, Optional<String> password) {
        this.host = host;
        this.port = port;
        this.useSSL = useSSL;
        this.user = user;
        this.password = password;
    }

    public URI getUri() {
        String protocol = this.useSSL ? "https" : "http";
        String url = String.format("%s://%s:%s", protocol, this.host, this.port);
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_CONFIGURATION, "invalid proxy url: " + url);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean requireAuthentication() {
        return this.user.isPresent() || this.password.isPresent();
    }

    public String toString() {
        return "ProxyConfig{host='" + this.host + '\'' + ", port=" + this.port + ", useSSL=" + this.useSSL + ", user=" + this.user + ", password=" + this.password + '}';
    }

    public static class ProxyConfigBuilder {
        private String host = "localhost";
        private int port = 8080;
        private boolean useSSL = false;
        private Optional<String> user = Optional.absent();
        private Optional<String> password = Optional.absent();

        public ProxyConfigBuilder() {
        }

        public ProxyConfigBuilder(ProxyConfig config) {
            this.host = config.host;
            this.port = config.port;
            this.useSSL = config.useSSL;
            this.user = config.user;
            this.password = config.password;
        }

        public ProxyConfigBuilder setHost(String host) {
            this.host = host;
            return this;
        }

        public ProxyConfigBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public void useSSL(boolean useSSL) {
            this.useSSL = useSSL;
        }

        public ProxyConfigBuilder setUser(String user) {
            this.user = Optional.of(user);
            return this;
        }

        public ProxyConfigBuilder setPassword(String password) {
            this.password = Optional.of(password);
            return this;
        }

        public ProxyConfig createProxyConfig() {
            return new ProxyConfig(this.host, this.port, this.useSSL, this.user, this.password);
        }
    }
}

