/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;

public class ExponentialBackOff {
    private final int initialIntervalMills;
    private final int maxIntervalMillis;
    private final double multiplier;
    private int executionCount;
    private int nextIntervalMillis;

    public ExponentialBackOff() {
        this(2000, 60000, 1.5);
    }

    public ExponentialBackOff(int initialIntervalMillis, int maxIntervalMillis, double multiplier) {
        this.initialIntervalMills = initialIntervalMillis;
        this.maxIntervalMillis = maxIntervalMillis;
        this.multiplier = multiplier;
        this.executionCount = 0;
        this.nextIntervalMillis = initialIntervalMillis;
        Preconditions.checkArgument(initialIntervalMillis >= 0, "initialIntervalMillis must be >= 0");
        Preconditions.checkArgument(maxIntervalMillis >= 0, "maxIntervalMillis must be >= 0");
        Preconditions.checkArgument(multiplier >= 0.0, "multiplier must be >= 0");
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public int incrementExecutionCount() {
        return this.executionCount++;
    }

    public int nextWaitTimeMillis() {
        int currentWaitTimeMillis = this.nextIntervalMillis;
        this.nextIntervalMillis = Math.min((int)((double)this.nextIntervalMillis * this.multiplier), this.maxIntervalMillis);
        ++this.executionCount;
        return currentWaitTimeMillis;
    }
}

