from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ResearchSubjectSchema:
    """
    A process where a researcher or organization plans and then executes a series
    of steps intended to increase the field of healthcare-related knowledge.  This
    includes studies of safety, efficacy, comparative effectiveness and other
    information about medications, devices, therapies and other interventional and
    investigative techniques.  A ResearchStudy involves the gathering of
    information about human or animal subjects.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A process where a researcher or organization plans and then executes a series
        of steps intended to increase the field of healthcare-related knowledge.  This
        includes studies of safety, efficacy, comparative effectiveness and other
        information about medications, devices, therapies and other interventional and
        investigative techniques.  A ResearchStudy involves the gathering of
        information about human or animal subjects.


        resourceType: This is a ResearchSubject resource

        identifier: Identifiers assigned to this research study by the sponsor or other systems.

        status: The current state of the subject.

        period: The dates the subject began and ended their participation in the study.

        study: Reference to the study the subject is participating in.

        individual: The record of the person or animal who is involved in the study.

        assignedArm: The name of the arm in the study the subject is expected to follow as part of
            this study.

        actualArm: The name of the arm in the study the subject actually followed as part of this
            study.

        consent: A record of the patient's informed agreement to participate in the study.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("ResearchSubject") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ResearchSubject"]
        schema = StructType(
            [
                # This is a ResearchSubject resource
                StructField("resourceType", StringType(), True),
                # Identifiers assigned to this research study by the sponsor or other systems.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The current state of the subject.
                StructField("status", StringType(), True),
                # The dates the subject began and ended their participation in the study.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Reference to the study the subject is participating in.
                StructField(
                    "study",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The record of the person or animal who is involved in the study.
                StructField(
                    "individual",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The name of the arm in the study the subject is expected to follow as part of
                # this study.
                StructField("assignedArm", StringType(), True),
                # The name of the arm in the study the subject actually followed as part of this
                # study.
                StructField("actualArm", StringType(), True),
                # A record of the patient's informed agreement to participate in the study.
                StructField(
                    "consent",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
