from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ProcedureRequestSchema:
    """
    A record of a request for diagnostic investigations, treatments, or operations
    to be performed.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A record of a request for diagnostic investigations, treatments, or operations
        to be performed.


        resourceType: This is a ProcedureRequest resource

        identifier: Identifiers assigned to this order instance by the orderer and/or the receiver
            and/or order fulfiller.

        definition: Protocol or definition followed by this request.

        basedOn: Plan/proposal/order fulfilled by this request.

        replaces: The request takes the place of the referenced completed or terminated
            request(s).

        requisition: A shared identifier common to all procedure or diagnostic requests that were
            authorized more or less simultaneously by a single author, representing the
            composite or group identifier.

        status: The status of the order.

        intent: Whether the request is a proposal, plan, an original order or a reflex order.

        priority: Indicates how quickly the ProcedureRequest should be addressed with respect to
            other requests.

        doNotPerform: Set this to true if the record is saying that the procedure should NOT be
            performed.

        category: A code that classifies the procedure for searching, sorting and display
            purposes (e.g. "Surgical Procedure").

        code: A code that identifies a particular procedure, diagnostic investigation, or
            panel of investigations, that have been requested.

        subject: On whom or what the procedure or diagnostic is to be performed. This is
            usually a human patient, but can also be requested on animals, groups of
            humans or animals, devices such as dialysis machines, or even locations
            (typically for environmental scans).

        context: An encounter or episode of care that provides additional information about the
            healthcare context in which this request is made.

        occurrenceDateTime: The date/time at which the diagnostic testing should occur.

        occurrencePeriod: The date/time at which the diagnostic testing should occur.

        occurrenceTiming: The date/time at which the diagnostic testing should occur.

        asNeededBoolean: If a CodeableConcept is present, it indicates the pre-condition for performing
            the procedure.  For example "pain", "on flare-up", etc.

        asNeededCodeableConcept: If a CodeableConcept is present, it indicates the pre-condition for performing
            the procedure.  For example "pain", "on flare-up", etc.

        authoredOn: When the request transitioned to being actionable.

        requester: The individual who initiated the request and has responsibility for its
            activation.

        performerType: Desired type of performer for doing the diagnostic testing.

        performer: The desired perfomer for doing the diagnostic testing.  For example, the
            surgeon, dermatopathologist, endoscopist, etc.

        reasonCode: An explanation or justification for why this diagnostic investigation is being
            requested in coded or textual form.   This is often for billing purposes.  May
            relate to the resources referred to in supportingInformation.

        reasonReference: Indicates another resource that provides a justification for why this
            diagnostic investigation is being requested.   May relate to the resources
            referred to in supportingInformation.

        supportingInfo: Additional clinical information about the patient or specimen that may
            influence the procedure or diagnostics or their interpretations.     This
            information includes diagnosis, clinical findings and other observations.  In
            laboratory ordering these are typically referred to as "ask at order entry
            questions (AOEs)".  This includes observations explicitly requested by the
            producer (filler) to provide context or supporting information needed to
            complete the order. For example,  reporting the amount of inspired oxygen for
            blood gas measurements.

        specimen: One or more specimens that the laboratory procedure will use.

        bodySite: Anatomic location where the procedure should be performed. This is the target
            site.

        note: Any other notes and comments made about the service request. For example,
            letting provider know that "patient hates needles" or other provider
            instructions.

        relevantHistory: Key events in the history of the request.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.timing import TimingSchema
        from spark_fhir_schemas.stu3.complex_types.procedurerequest_requester import (
            ProcedureRequest_RequesterSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema

        if (
            max_recursion_limit
            and nesting_list.count("ProcedureRequest") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ProcedureRequest"]
        schema = StructType(
            [
                # This is a ProcedureRequest resource
                StructField("resourceType", StringType(), True),
                # Identifiers assigned to this order instance by the orderer and/or the receiver
                # and/or order fulfiller.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Protocol or definition followed by this request.
                StructField(
                    "definition",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Plan/proposal/order fulfilled by this request.
                StructField(
                    "basedOn",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The request takes the place of the referenced completed or terminated
                # request(s).
                StructField(
                    "replaces",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A shared identifier common to all procedure or diagnostic requests that were
                # authorized more or less simultaneously by a single author, representing the
                # composite or group identifier.
                StructField(
                    "requisition",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The status of the order.
                StructField("status", StringType(), True),
                # Whether the request is a proposal, plan, an original order or a reflex order.
                StructField("intent", StringType(), True),
                # Indicates how quickly the ProcedureRequest should be addressed with respect to
                # other requests.
                StructField("priority", StringType(), True),
                # Set this to true if the record is saying that the procedure should NOT be
                # performed.
                StructField("doNotPerform", BooleanType(), True),
                # A code that classifies the procedure for searching, sorting and display
                # purposes (e.g. "Surgical Procedure").
                StructField(
                    "category",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A code that identifies a particular procedure, diagnostic investigation, or
                # panel of investigations, that have been requested.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # On whom or what the procedure or diagnostic is to be performed. This is
                # usually a human patient, but can also be requested on animals, groups of
                # humans or animals, devices such as dialysis machines, or even locations
                # (typically for environmental scans).
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # An encounter or episode of care that provides additional information about the
                # healthcare context in which this request is made.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date/time at which the diagnostic testing should occur.
                StructField("occurrenceDateTime", StringType(), True),
                # The date/time at which the diagnostic testing should occur.
                StructField(
                    "occurrencePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date/time at which the diagnostic testing should occur.
                StructField(
                    "occurrenceTiming",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # If a CodeableConcept is present, it indicates the pre-condition for performing
                # the procedure.  For example "pain", "on flare-up", etc.
                StructField("asNeededBoolean", BooleanType(), True),
                # If a CodeableConcept is present, it indicates the pre-condition for performing
                # the procedure.  For example "pain", "on flare-up", etc.
                StructField(
                    "asNeededCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # When the request transitioned to being actionable.
                StructField("authoredOn", StringType(), True),
                # The individual who initiated the request and has responsibility for its
                # activation.
                StructField(
                    "requester",
                    ProcedureRequest_RequesterSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Desired type of performer for doing the diagnostic testing.
                StructField(
                    "performerType",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The desired perfomer for doing the diagnostic testing.  For example, the
                # surgeon, dermatopathologist, endoscopist, etc.
                StructField(
                    "performer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # An explanation or justification for why this diagnostic investigation is being
                # requested in coded or textual form.   This is often for billing purposes.  May
                # relate to the resources referred to in supportingInformation.
                StructField(
                    "reasonCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Indicates another resource that provides a justification for why this
                # diagnostic investigation is being requested.   May relate to the resources
                # referred to in supportingInformation.
                StructField(
                    "reasonReference",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Additional clinical information about the patient or specimen that may
                # influence the procedure or diagnostics or their interpretations.     This
                # information includes diagnosis, clinical findings and other observations.  In
                # laboratory ordering these are typically referred to as "ask at order entry
                # questions (AOEs)".  This includes observations explicitly requested by the
                # producer (filler) to provide context or supporting information needed to
                # complete the order. For example,  reporting the amount of inspired oxygen for
                # blood gas measurements.
                StructField(
                    "supportingInfo",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # One or more specimens that the laboratory procedure will use.
                StructField(
                    "specimen",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Anatomic location where the procedure should be performed. This is the target
                # site.
                StructField(
                    "bodySite",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Any other notes and comments made about the service request. For example,
                # letting provider know that "patient hates needles" or other provider
                # instructions.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Key events in the history of the request.
                StructField(
                    "relevantHistory",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
