from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class PractitionerRole_NotAvailableSchema:
    """
    A specific set of Roles/Locations/specialties/services that a practitioner may
    perform at an organization for a period of time.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A specific set of Roles/Locations/specialties/services that a practitioner may
        perform at an organization for a period of time.


        description: The reason that can be presented to the user as to why this time is not
            available.

        during: Service is not available (seasonally or for a public holiday) from this date.

        """
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema

        if (
            max_recursion_limit
            and nesting_list.count("PractitionerRole_NotAvailable")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["PractitionerRole_NotAvailable"]
        schema = StructType(
            [
                # The reason that can be presented to the user as to why this time is not
                # available.
                StructField("description", StringType(), True),
                # Service is not available (seasonally or for a public holiday) from this date.
                StructField(
                    "during",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
