from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MedicationAdministrationSchema:
    """
    Describes the event of a patient consuming or otherwise being administered a
    medication.  This may be as simple as swallowing a tablet or it may be a long
    running infusion.  Related resources tie this event to the authorizing
    prescription, and the specific encounter between patient and health care
    practitioner.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Describes the event of a patient consuming or otherwise being administered a
        medication.  This may be as simple as swallowing a tablet or it may be a long
        running infusion.  Related resources tie this event to the authorizing
        prescription, and the specific encounter between patient and health care
        practitioner.


        resourceType: This is a MedicationAdministration resource

        identifier: External identifier - FHIR will generate its own internal identifiers
            (probably URLs) which do not need to be explicitly managed by the resource.
            The identifier here is one that would be used by another non-FHIR system - for
            example an automated medication pump would provide a record each time it
            operated; an administration while the patient was off the ward might be made
            with a different system and entered after the event.  Particularly important
            if these records have to be updated.

        definition: A protocol, guideline, orderset or other definition that was adhered to in
            whole or in part by this event.

        partOf: A larger event of which this particular event is a component or step.

        status: Will generally be set to show that the administration has been completed.  For
            some long running administrations such as infusions it is possible for an
            administration to be started but not completed or it may be paused while some
            other process is under way.

        category: Indicates the type of medication administration and where the medication is
            expected to be consumed or administered.

        medicationCodeableConcept: Identifies the medication that was administered. This is either a link to a
            resource representing the details of the medication or a simple attribute
            carrying a code that identifies the medication from a known list of
            medications.

        medicationReference: Identifies the medication that was administered. This is either a link to a
            resource representing the details of the medication or a simple attribute
            carrying a code that identifies the medication from a known list of
            medications.

        subject: The person or animal or group receiving the medication.

        context: The visit, admission or other contact between patient and health care provider
            the medication administration was performed as part of.

        supportingInformation: Additional information (for example, patient height and weight) that supports
            the administration of the medication.

        effectiveDateTime: A specific date/time or interval of time during which the administration took
            place (or did not take place, when the 'notGiven' attribute is true). For many
            administrations, such as swallowing a tablet the use of dateTime is more
            appropriate.

        effectivePeriod: A specific date/time or interval of time during which the administration took
            place (or did not take place, when the 'notGiven' attribute is true). For many
            administrations, such as swallowing a tablet the use of dateTime is more
            appropriate.

        performer: The individual who was responsible for giving the medication to the patient.

        notGiven: Set this to true if the record is saying that the medication was NOT
            administered.

        reasonNotGiven: A code indicating why the administration was not performed.

        reasonCode: A code indicating why the medication was given.

        reasonReference: Condition or observation that supports why the medication was administered.

        prescription: The original request, instruction or authority to perform the administration.

        device: The device used in administering the medication to the patient.  For example,
            a particular infusion pump.

        note: Extra information about the medication administration that is not conveyed by
            the other attributes.

        dosage: Describes the medication dosage information details e.g. dose, rate, site,
            route, etc.

        eventHistory: A summary of the events of interest that have occurred, such as when the
            administration was verified.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.medicationadministration_performer import (
            MedicationAdministration_PerformerSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema
        from spark_fhir_schemas.stu3.complex_types.medicationadministration_dosage import (
            MedicationAdministration_DosageSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("MedicationAdministration") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MedicationAdministration"]
        schema = StructType(
            [
                # This is a MedicationAdministration resource
                StructField("resourceType", StringType(), True),
                # External identifier - FHIR will generate its own internal identifiers
                # (probably URLs) which do not need to be explicitly managed by the resource.
                # The identifier here is one that would be used by another non-FHIR system - for
                # example an automated medication pump would provide a record each time it
                # operated; an administration while the patient was off the ward might be made
                # with a different system and entered after the event.  Particularly important
                # if these records have to be updated.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A protocol, guideline, orderset or other definition that was adhered to in
                # whole or in part by this event.
                StructField(
                    "definition",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A larger event of which this particular event is a component or step.
                StructField(
                    "partOf",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Will generally be set to show that the administration has been completed.  For
                # some long running administrations such as infusions it is possible for an
                # administration to be started but not completed or it may be paused while some
                # other process is under way.
                StructField("status", StringType(), True),
                # Indicates the type of medication administration and where the medication is
                # expected to be consumed or administered.
                StructField(
                    "category",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the medication that was administered. This is either a link to a
                # resource representing the details of the medication or a simple attribute
                # carrying a code that identifies the medication from a known list of
                # medications.
                StructField(
                    "medicationCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the medication that was administered. This is either a link to a
                # resource representing the details of the medication or a simple attribute
                # carrying a code that identifies the medication from a known list of
                # medications.
                StructField(
                    "medicationReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The person or animal or group receiving the medication.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The visit, admission or other contact between patient and health care provider
                # the medication administration was performed as part of.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Additional information (for example, patient height and weight) that supports
                # the administration of the medication.
                StructField(
                    "supportingInformation",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A specific date/time or interval of time during which the administration took
                # place (or did not take place, when the 'notGiven' attribute is true). For many
                # administrations, such as swallowing a tablet the use of dateTime is more
                # appropriate.
                StructField("effectiveDateTime", StringType(), True),
                # A specific date/time or interval of time during which the administration took
                # place (or did not take place, when the 'notGiven' attribute is true). For many
                # administrations, such as swallowing a tablet the use of dateTime is more
                # appropriate.
                StructField(
                    "effectivePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The individual who was responsible for giving the medication to the patient.
                StructField(
                    "performer",
                    ArrayType(
                        MedicationAdministration_PerformerSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Set this to true if the record is saying that the medication was NOT
                # administered.
                StructField("notGiven", BooleanType(), True),
                # A code indicating why the administration was not performed.
                StructField(
                    "reasonNotGiven",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A code indicating why the medication was given.
                StructField(
                    "reasonCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Condition or observation that supports why the medication was administered.
                StructField(
                    "reasonReference",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The original request, instruction or authority to perform the administration.
                StructField(
                    "prescription",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The device used in administering the medication to the patient.  For example,
                # a particular infusion pump.
                StructField(
                    "device",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Extra information about the medication administration that is not conveyed by
                # the other attributes.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Describes the medication dosage information details e.g. dose, rate, site,
                # route, etc.
                StructField(
                    "dosage",
                    MedicationAdministration_DosageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A summary of the events of interest that have occurred, such as when the
                # administration was verified.
                StructField(
                    "eventHistory",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
