from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MeasureReport_StratumSchema:
    """
    The MeasureReport resource contains the results of evaluating a measure.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        The MeasureReport resource contains the results of evaluating a measure.


        value: The value for this stratum, expressed as a string. When defining stratifiers
            on complex values, the value must be rendered such that the value for each
            stratum within the stratifier is unique.

        population: The populations that make up the stratum, one for each type of population
            appropriate to the measure.

        measureScore: The measure score for this stratum, calculated as appropriate for the measure
            type and scoring method, and based on only the members of this stratum.

        """
        from spark_fhir_schemas.stu3.complex_types.measurereport_population1 import (
            MeasureReport_Population1Schema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("MeasureReport_Stratum") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["MeasureReport_Stratum"]
        schema = StructType(
            [
                # The value for this stratum, expressed as a string. When defining stratifiers
                # on complex values, the value must be rendered such that the value for each
                # stratum within the stratifier is unique.
                StructField("value", StringType(), True),
                # The populations that make up the stratum, one for each type of population
                # appropriate to the measure.
                StructField(
                    "population",
                    ArrayType(
                        MeasureReport_Population1Schema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The measure score for this stratum, calculated as appropriate for the measure
                # type and scoring method, and based on only the members of this stratum.
                StructField("measureScore", IntegerType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
