from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImagingManifest_StudySchema:
    """
    A text description of the DICOM SOP instances selected in the ImagingManifest;
    or the reason for, or significance of, the selection.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A text description of the DICOM SOP instances selected in the ImagingManifest;
        or the reason for, or significance of, the selection.


        uid: Study instance UID of the SOP instances in the selection.

        imagingStudy: Reference to the Imaging Study in FHIR form.

        endpoint: The network service providing access (e.g., query, view, or retrieval) for the
            study. See implementation notes for information about using DICOM endpoints. A
            study-level endpoint applies to each series in the study, unless overridden by
            a series-level endpoint with the same Endpoint.type.

        series: Series identity and locating information of the DICOM SOP instances in the
            selection.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.imagingmanifest_series import (
            ImagingManifest_SeriesSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ImagingManifest_Study") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImagingManifest_Study"]
        schema = StructType(
            [
                # Study instance UID of the SOP instances in the selection.
                StructField("uid", StringType(), True),
                # Reference to the Imaging Study in FHIR form.
                StructField(
                    "imagingStudy",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The network service providing access (e.g., query, view, or retrieval) for the
                # study. See implementation notes for information about using DICOM endpoints. A
                # study-level endpoint applies to each series in the study, unless overridden by
                # a series-level endpoint with the same Endpoint.type.
                StructField(
                    "endpoint",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Series identity and locating information of the DICOM SOP instances in the
                # selection.
                StructField(
                    "series",
                    ArrayType(
                        ImagingManifest_SeriesSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
