from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ExplanationOfBenefitSchema:
    """
    This resource provides: the claim details; adjudication details from the
    processing of a Claim; and optionally account balance information, for
    informing the subscriber of the benefits provided.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        This resource provides: the claim details; adjudication details from the
        processing of a Claim; and optionally account balance information, for
        informing the subscriber of the benefits provided.


        resourceType: This is a ExplanationOfBenefit resource

        identifier: The EOB Business Identifier.

        status: The status of the resource instance.

        type: The category of claim, eg, oral, pharmacy, vision, insitutional, professional.

        subType: A finer grained suite of claim subtype codes which may convey Inpatient vs
            Outpatient and/or a specialty service. In the US the BillType.

        patient: Patient Resource.

        billablePeriod: The billable period for which charges are being submitted.

        created: The date when the EOB was created.

        enterer: The person who created the explanation of benefit.

        insurer: The insurer which is responsible for the explanation of benefit.

        provider: The provider which is responsible for the claim.

        organization: The provider which is responsible for the claim.

        referral: The referral resource which lists the date, practitioner, reason and other
            supporting information.

        facility: Facility where the services were provided.

        claim: The business identifier for the instance: invoice number, claim number, pre-
            determination or pre-authorization number.

        claimResponse: The business identifier for the instance: invoice number, claim number, pre-
            determination or pre-authorization number.

        outcome: Processing outcome errror, partial or complete processing.

        disposition: A description of the status of the adjudication.

        related: Other claims which are related to this claim such as prior claim versions or
            for related services.

        prescription: Prescription to support the dispensing of Pharmacy or Vision products.

        originalPrescription: Original prescription which has been superceded by this prescription to
            support the dispensing of pharmacy services, medications or products. For
            example, a physician may prescribe a medication which the pharmacy determines
            is contraindicated, or for which the patient has an intolerance, and therefor
            issues a new precription for an alternate medication which has the same
            theraputic intent. The prescription from the pharmacy becomes the
            'prescription' and that from the physician becomes the 'original
            prescription'.

        payee: The party to be reimbursed for the services.

        information: Additional information codes regarding exceptions, special considerations, the
            condition, situation, prior or concurrent issues. Often there are mutiple
            jurisdiction specific valuesets which are required.

        careTeam: The members of the team who provided the overall service as well as their role
            and whether responsible and qualifications.

        diagnosis: Ordered list of patient diagnosis for which care is sought.

        procedure: Ordered list of patient procedures performed to support the adjudication.

        precedence: Precedence (primary, secondary, etc.).

        insurance: Financial instrument by which payment information for health care.

        accident: An accident which resulted in the need for healthcare services.

        employmentImpacted: The start and optional end dates of when the patient was precluded from
            working due to the treatable condition(s).

        hospitalization: The start and optional end dates of when the patient was confined to a
            treatment center.

        item: First tier of goods and services.

        addItem: The first tier service adjudications for payor added services.

        totalCost: The total cost of the services reported.

        unallocDeductable: The amount of deductable applied which was not allocated to any particular
            service line.

        totalBenefit: Total amount of benefit payable (Equal to sum of the Benefit amounts from all
            detail lines and additions less the Unallocated Deductable).

        payment: Payment details for the claim if the claim has been paid.

        form: The form to be used for printing the content.

        processNote: Note text.

        benefitBalance: Balance by Benefit Category.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_related import (
            ExplanationOfBenefit_RelatedSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_payee import (
            ExplanationOfBenefit_PayeeSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_information import (
            ExplanationOfBenefit_InformationSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_careteam import (
            ExplanationOfBenefit_CareTeamSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_diagnosis import (
            ExplanationOfBenefit_DiagnosisSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_procedure import (
            ExplanationOfBenefit_ProcedureSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_insurance import (
            ExplanationOfBenefit_InsuranceSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_accident import (
            ExplanationOfBenefit_AccidentSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_item import (
            ExplanationOfBenefit_ItemSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_additem import (
            ExplanationOfBenefit_AddItemSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.money import MoneySchema
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_payment import (
            ExplanationOfBenefit_PaymentSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_processnote import (
            ExplanationOfBenefit_ProcessNoteSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.explanationofbenefit_benefitbalance import (
            ExplanationOfBenefit_BenefitBalanceSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ExplanationOfBenefit") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ExplanationOfBenefit"]
        schema = StructType(
            [
                # This is a ExplanationOfBenefit resource
                StructField("resourceType", StringType(), True),
                # The EOB Business Identifier.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The status of the resource instance.
                StructField("status", StringType(), True),
                # The category of claim, eg, oral, pharmacy, vision, insitutional, professional.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A finer grained suite of claim subtype codes which may convey Inpatient vs
                # Outpatient and/or a specialty service. In the US the BillType.
                StructField(
                    "subType",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Patient Resource.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The billable period for which charges are being submitted.
                StructField(
                    "billablePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date when the EOB was created.
                StructField("created", StringType(), True),
                # The person who created the explanation of benefit.
                StructField(
                    "enterer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The insurer which is responsible for the explanation of benefit.
                StructField(
                    "insurer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The provider which is responsible for the claim.
                StructField(
                    "provider",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The provider which is responsible for the claim.
                StructField(
                    "organization",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The referral resource which lists the date, practitioner, reason and other
                # supporting information.
                StructField(
                    "referral",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Facility where the services were provided.
                StructField(
                    "facility",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The business identifier for the instance: invoice number, claim number, pre-
                # determination or pre-authorization number.
                StructField(
                    "claim",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The business identifier for the instance: invoice number, claim number, pre-
                # determination or pre-authorization number.
                StructField(
                    "claimResponse",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Processing outcome errror, partial or complete processing.
                StructField(
                    "outcome",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A description of the status of the adjudication.
                StructField("disposition", StringType(), True),
                # Other claims which are related to this claim such as prior claim versions or
                # for related services.
                StructField(
                    "related",
                    ArrayType(
                        ExplanationOfBenefit_RelatedSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Prescription to support the dispensing of Pharmacy or Vision products.
                StructField(
                    "prescription",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Original prescription which has been superceded by this prescription to
                # support the dispensing of pharmacy services, medications or products. For
                # example, a physician may prescribe a medication which the pharmacy determines
                # is contraindicated, or for which the patient has an intolerance, and therefor
                # issues a new precription for an alternate medication which has the same
                # theraputic intent. The prescription from the pharmacy becomes the
                # 'prescription' and that from the physician becomes the 'original
                # prescription'.
                StructField(
                    "originalPrescription",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The party to be reimbursed for the services.
                StructField(
                    "payee",
                    ExplanationOfBenefit_PayeeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Additional information codes regarding exceptions, special considerations, the
                # condition, situation, prior or concurrent issues. Often there are mutiple
                # jurisdiction specific valuesets which are required.
                StructField(
                    "information",
                    ArrayType(
                        ExplanationOfBenefit_InformationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The members of the team who provided the overall service as well as their role
                # and whether responsible and qualifications.
                StructField(
                    "careTeam",
                    ArrayType(
                        ExplanationOfBenefit_CareTeamSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Ordered list of patient diagnosis for which care is sought.
                StructField(
                    "diagnosis",
                    ArrayType(
                        ExplanationOfBenefit_DiagnosisSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Ordered list of patient procedures performed to support the adjudication.
                StructField(
                    "procedure",
                    ArrayType(
                        ExplanationOfBenefit_ProcedureSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Precedence (primary, secondary, etc.).
                StructField("precedence", IntegerType(), True),
                # Financial instrument by which payment information for health care.
                StructField(
                    "insurance",
                    ExplanationOfBenefit_InsuranceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # An accident which resulted in the need for healthcare services.
                StructField(
                    "accident",
                    ExplanationOfBenefit_AccidentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The start and optional end dates of when the patient was precluded from
                # working due to the treatable condition(s).
                StructField(
                    "employmentImpacted",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The start and optional end dates of when the patient was confined to a
                # treatment center.
                StructField(
                    "hospitalization",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # First tier of goods and services.
                StructField(
                    "item",
                    ArrayType(
                        ExplanationOfBenefit_ItemSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The first tier service adjudications for payor added services.
                StructField(
                    "addItem",
                    ArrayType(
                        ExplanationOfBenefit_AddItemSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The total cost of the services reported.
                StructField(
                    "totalCost",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The amount of deductable applied which was not allocated to any particular
                # service line.
                StructField(
                    "unallocDeductable",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Total amount of benefit payable (Equal to sum of the Benefit amounts from all
                # detail lines and additions less the Unallocated Deductable).
                StructField(
                    "totalBenefit",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Payment details for the claim if the claim has been paid.
                StructField(
                    "payment",
                    ExplanationOfBenefit_PaymentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The form to be used for printing the content.
                StructField(
                    "form",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Note text.
                StructField(
                    "processNote",
                    ArrayType(
                        ExplanationOfBenefit_ProcessNoteSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Balance by Benefit Category.
                StructField(
                    "benefitBalance",
                    ArrayType(
                        ExplanationOfBenefit_BenefitBalanceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
