from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ElementDefinition_SlicingSchema:
    """
    Captures constraints on each element within the resource, profile, or
    extension.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Captures constraints on each element within the resource, profile, or
        extension.


        discriminator: Designates which child elements are used to discriminate between the slices
            when processing an instance. If one or more discriminators are provided, the
            value of the child elements in the instance data SHALL completely distinguish
            which slice the element in the resource matches based on the allowed values
            for those elements in each of the slices.

        description: A human-readable text description of how the slicing works. If there is no
            discriminator, this is required to be present to provide whatever information
            is possible about how the slices can be differentiated.

        ordered: If the matching elements have to occur in the same order as defined in the
            profile.

        rules: Whether additional slices are allowed or not. When the slices are ordered,
            profile authors can also say that additional slices are only allowed at the
            end.

        """
        from spark_fhir_schemas.stu3.complex_types.elementdefinition_discriminator import (
            ElementDefinition_DiscriminatorSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ElementDefinition_Slicing") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ElementDefinition_Slicing"]
        schema = StructType(
            [
                # Designates which child elements are used to discriminate between the slices
                # when processing an instance. If one or more discriminators are provided, the
                # value of the child elements in the instance data SHALL completely distinguish
                # which slice the element in the resource matches based on the allowed values
                # for those elements in each of the slices.
                StructField(
                    "discriminator",
                    ArrayType(
                        ElementDefinition_DiscriminatorSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A human-readable text description of how the slicing works. If there is no
                # discriminator, this is required to be present to provide whatever information
                # is possible about how the slices can be differentiated.
                StructField("description", StringType(), True),
                # If the matching elements have to occur in the same order as defined in the
                # profile.
                StructField("ordered", BooleanType(), True),
                # Whether additional slices are allowed or not. When the slices are ordered,
                # profile authors can also say that additional slices are only allowed at the
                # end.
                StructField("rules", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
