from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class CodingSchema:
    """
    A reference to a code defined by a terminology system.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A reference to a code defined by a terminology system.


        system: The identification of the code system that defines the meaning of the symbol
            in the code.

        version: The version of the code system which was used when choosing this code. Note
            that a well-maintained code system does not need the version reported, because
            the meaning of codes is consistent across versions. However this cannot
            consistently be assured. and when the meaning is not guaranteed to be
            consistent, the version SHOULD be exchanged.

        code: A symbol in syntax defined by the system. The symbol may be a predefined code
            or an expression in a syntax defined by the coding system (e.g. post-
            coordination).

        display: A representation of the meaning of the code in the system, following the rules
            of the system.

        userSelected: Indicates that this coding was chosen by a user directly - i.e. off a pick
            list of available items (codes or displays).

        """
        if (
            max_recursion_limit and nesting_list.count("Coding") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Coding"]
        schema = StructType(
            [
                # The identification of the code system that defines the meaning of the symbol
                # in the code.
                StructField("system", StringType(), True),
                # The version of the code system which was used when choosing this code. Note
                # that a well-maintained code system does not need the version reported, because
                # the meaning of codes is consistent across versions. However this cannot
                # consistently be assured. and when the meaning is not guaranteed to be
                # consistent, the version SHOULD be exchanged.
                StructField("version", StringType(), True),
                # A symbol in syntax defined by the system. The symbol may be a predefined code
                # or an expression in a syntax defined by the coding system (e.g. post-
                # coordination).
                StructField("code", StringType(), True),
                # A representation of the meaning of the code in the system, following the rules
                # of the system.
                StructField("display", StringType(), True),
                # Indicates that this coding was chosen by a user directly - i.e. off a pick
                # list of available items (codes or displays).
                StructField("userSelected", BooleanType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
