import { Endpoint } from "./http";
import { FinalizeHandler, FinalizeHandlerArguments, FinalizeHandlerOutput } from "./middleware";
import { MetadataBearer } from "./response";

export interface Encoder {
    (input: Uint8Array): string;
}

export interface Decoder {
    (input: string): Uint8Array;
}

export interface Provider<T> {
    (): Promise<T>;
}

export interface BodyLengthCalculator {
    (body: any): number | undefined;
}

export interface RetryStrategy {
    
    mode?: string;
    
    retry: <Input extends object, Output extends MetadataBearer>(next: FinalizeHandler<Input, Output>, args: FinalizeHandlerArguments<Input>) => Promise<FinalizeHandlerOutput<Output>>;
}

export interface UrlParser {
    (url: string): Endpoint;
}

export interface RegionInfo {
    hostname: string;
    partition: string;
    path?: string;
    signingService?: string;
    signingRegion?: string;
}

export interface RegionInfoProviderOptions {
    
    useDualstackEndpoint: boolean;
    
    useFipsEndpoint: boolean;
}

export interface RegionInfoProvider {
    (region: string, options?: RegionInfoProviderOptions): Promise<RegionInfo | undefined>;
}

export declare type UserAgentPair = [
     string,
     string
];

export declare type UserAgent = UserAgentPair[];
