"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CredentialsProviderError = exports.ProviderError = void 0;
class ProviderError extends Error {
    constructor(message, tryNextLink = true) {
        super(message);
        this.tryNextLink = tryNextLink;
    }
    static from(error, tryNextLink = true) {
        Object.defineProperty(error, "tryNextLink", {
            value: tryNextLink,
            configurable: false,
            enumerable: false,
            writable: false,
        });
        return error;
    }
}
exports.ProviderError = ProviderError;
class CredentialsProviderError extends Error {
    constructor(message, tryNextLink = true) {
        super(message);
        this.tryNextLink = tryNextLink;
        this.name = "CredentialsProviderError";
    }
    static from(error, tryNextLink = true) {
        Object.defineProperty(error, "tryNextLink", {
            value: tryNextLink,
            configurable: false,
            enumerable: false,
            writable: false,
        });
        return error;
    }
}
exports.CredentialsProviderError = CredentialsProviderError;
