
import { HttpHandler, HttpRequest, HttpResponse } from "@aws-sdk/protocol-http";
import { HttpHandlerOptions } from "@aws-sdk/types";
import { Agent as hAgent } from "http";
import { Agent as hsAgent } from "https";

export interface NodeHttpHandlerOptions {
    
    connectionTimeout?: number;
    
    socketTimeout?: number;
    httpAgent?: hAgent;
    httpsAgent?: hsAgent;
}
export declare class NodeHttpHandler implements HttpHandler {
    private readonly httpAgent;
    private readonly httpsAgent;
    private readonly connectionTimeout?;
    private readonly socketTimeout?;
    readonly metadata: {
        handlerProtocol: string;
    };
    constructor({ connectionTimeout, socketTimeout, httpAgent, httpsAgent }?: NodeHttpHandlerOptions);
    destroy(): void;
    handle(request: HttpRequest, { abortSignal }?: HttpHandlerOptions): Promise<{
        response: HttpResponse;
    }>;
}
