import { __awaiter, __generator } from "tslib";
import { CredentialsProviderError } from "@aws-sdk/property-provider";
import { getMasterProfileName, parseKnownFiles } from "@aws-sdk/util-credentials";
import { exec } from "child_process";
export var ENV_PROFILE = "AWS_PROFILE";
export var fromProcess = function (init) {
    if (init === void 0) { init = {}; }
    return function () { return __awaiter(void 0, void 0, void 0, function () {
        var profiles;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, parseKnownFiles(init)];
                case 1:
                    profiles = _a.sent();
                    return [2, resolveProcessCredentials(getMasterProfileName(init), profiles)];
            }
        });
    }); };
};
var resolveProcessCredentials = function (profileName, profiles) { return __awaiter(void 0, void 0, void 0, function () {
    var profile, credentialProcess;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                profile = profiles[profileName];
                if (!profiles[profileName]) return [3, 4];
                credentialProcess = profile["credential_process"];
                if (!(credentialProcess !== undefined)) return [3, 2];
                return [4, execPromise(credentialProcess)
                        .then(function (processResult) {
                        var data;
                        try {
                            data = JSON.parse(processResult);
                        }
                        catch (_a) {
                            throw Error("Profile " + profileName + " credential_process returned invalid JSON.");
                        }
                        var version = data.Version, accessKeyId = data.AccessKeyId, secretAccessKey = data.SecretAccessKey, sessionToken = data.SessionToken, expiration = data.Expiration;
                        if (version !== 1) {
                            throw Error("Profile " + profileName + " credential_process did not return Version 1.");
                        }
                        if (accessKeyId === undefined || secretAccessKey === undefined) {
                            throw Error("Profile " + profileName + " credential_process returned invalid credentials.");
                        }
                        var expirationUnix;
                        if (expiration) {
                            var currentTime = new Date();
                            var expireTime = new Date(expiration);
                            if (expireTime < currentTime) {
                                throw Error("Profile " + profileName + " credential_process returned expired credentials.");
                            }
                            expirationUnix = Math.floor(new Date(expiration).valueOf() / 1000);
                        }
                        return {
                            accessKeyId: accessKeyId,
                            secretAccessKey: secretAccessKey,
                            sessionToken: sessionToken,
                            expirationUnix: expirationUnix,
                        };
                    })
                        .catch(function (error) {
                        throw new CredentialsProviderError(error.message);
                    })];
            case 1: return [2, _a.sent()];
            case 2: throw new CredentialsProviderError("Profile " + profileName + " did not contain credential_process.");
            case 3: return [3, 5];
            case 4: throw new CredentialsProviderError("Profile " + profileName + " could not be found in shared credentials file.");
            case 5: return [2];
        }
    });
}); };
var execPromise = function (command) {
    return new Promise(function (resolve, reject) {
        exec(command, function (error, stdout) {
            if (error) {
                reject(error);
                return;
            }
            resolve(stdout.trim());
        });
    });
};
