import { CredentialsProviderError } from "@aws-sdk/property-provider";
export var ENV_KEY = "AWS_ACCESS_KEY_ID";
export var ENV_SECRET = "AWS_SECRET_ACCESS_KEY";
export var ENV_SESSION = "AWS_SESSION_TOKEN";
export var ENV_EXPIRATION = "AWS_CREDENTIAL_EXPIRATION";
export function fromEnv() {
    return function () {
        var accessKeyId = process.env[ENV_KEY];
        var secretAccessKey = process.env[ENV_SECRET];
        var expiry = process.env[ENV_EXPIRATION];
        if (accessKeyId && secretAccessKey) {
            return Promise.resolve({
                accessKeyId: accessKeyId,
                secretAccessKey: secretAccessKey,
                sessionToken: process.env[ENV_SESSION],
                expiration: expiry ? new Date(expiry) : undefined,
            });
        }
        return Promise.reject(new CredentialsProviderError("Unable to find environment variable credentials."));
    };
}
