"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveRegionConfig = void 0;
const getRealRegion_1 = require("./getRealRegion");
const isFipsRegion_1 = require("./isFipsRegion");
const resolveRegionConfig = (input) => {
    const { region, useFipsEndpoint } = input;
    if (!region) {
        throw new Error("Region is missing");
    }
    return {
        ...input,
        region: async () => {
            if (typeof region === "string") {
                return getRealRegion_1.getRealRegion(region);
            }
            const providedRegion = await region();
            return getRealRegion_1.getRealRegion(providedRegion);
        },
        useFipsEndpoint: async () => {
            const providedRegion = typeof region === "string" ? region : await region();
            if (isFipsRegion_1.isFipsRegion(providedRegion)) {
                return true;
            }
            return typeof useFipsEndpoint === "boolean" ? Promise.resolve(useFipsEndpoint) : useFipsEndpoint();
        },
    };
};
exports.resolveRegionConfig = resolveRegionConfig;
