"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveCustomEndpointsConfig = void 0;
const normalizeBoolean_1 = require("./utils/normalizeBoolean");
const normalizeEndpoint_1 = require("./utils/normalizeEndpoint");
const resolveCustomEndpointsConfig = (input) => {
    var _a;
    return ({
        ...input,
        tls: (_a = input.tls) !== null && _a !== void 0 ? _a : true,
        endpoint: normalizeEndpoint_1.normalizeEndpoint(input),
        isCustomEndpoint: true,
        useDualstackEndpoint: normalizeBoolean_1.normalizeBoolean(input.useDualstackEndpoint),
    });
};
exports.resolveCustomEndpointsConfig = resolveCustomEndpointsConfig;
