import { MetadataBearer as $MetadataBearer, SmithyException as __SmithyException } from "@aws-sdk/types";

export interface AssumedRoleUser {
    
    AssumedRoleId: string | undefined;
    
    Arn: string | undefined;
}
export declare namespace AssumedRoleUser {
    
    const filterSensitiveLog: (obj: AssumedRoleUser) => any;
}

export interface PolicyDescriptorType {
    
    arn?: string;
}
export declare namespace PolicyDescriptorType {
    
    const filterSensitiveLog: (obj: PolicyDescriptorType) => any;
}

export interface Tag {
    
    Key: string | undefined;
    
    Value: string | undefined;
}
export declare namespace Tag {
    
    const filterSensitiveLog: (obj: Tag) => any;
}
export interface AssumeRoleRequest {
    
    RoleArn: string | undefined;
    
    RoleSessionName: string | undefined;
    
    PolicyArns?: PolicyDescriptorType[];
    
    Policy?: string;
    
    DurationSeconds?: number;
    
    Tags?: Tag[];
    
    TransitiveTagKeys?: string[];
    
    ExternalId?: string;
    
    SerialNumber?: string;
    
    TokenCode?: string;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleRequest {
    
    const filterSensitiveLog: (obj: AssumeRoleRequest) => any;
}

export interface Credentials {
    
    AccessKeyId: string | undefined;
    
    SecretAccessKey: string | undefined;
    
    SessionToken: string | undefined;
    
    Expiration: Date | undefined;
}
export declare namespace Credentials {
    
    const filterSensitiveLog: (obj: Credentials) => any;
}

export interface AssumeRoleResponse {
    
    Credentials?: Credentials;
    
    AssumedRoleUser?: AssumedRoleUser;
    
    PackedPolicySize?: number;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleResponse {
    
    const filterSensitiveLog: (obj: AssumeRoleResponse) => any;
}

export interface ExpiredTokenException extends __SmithyException, $MetadataBearer {
    name: "ExpiredTokenException";
    $fault: "client";
    message?: string;
}
export declare namespace ExpiredTokenException {
    
    const filterSensitiveLog: (obj: ExpiredTokenException) => any;
}

export interface MalformedPolicyDocumentException extends __SmithyException, $MetadataBearer {
    name: "MalformedPolicyDocumentException";
    $fault: "client";
    message?: string;
}
export declare namespace MalformedPolicyDocumentException {
    
    const filterSensitiveLog: (obj: MalformedPolicyDocumentException) => any;
}

export interface PackedPolicyTooLargeException extends __SmithyException, $MetadataBearer {
    name: "PackedPolicyTooLargeException";
    $fault: "client";
    message?: string;
}
export declare namespace PackedPolicyTooLargeException {
    
    const filterSensitiveLog: (obj: PackedPolicyTooLargeException) => any;
}

export interface RegionDisabledException extends __SmithyException, $MetadataBearer {
    name: "RegionDisabledException";
    $fault: "client";
    message?: string;
}
export declare namespace RegionDisabledException {
    
    const filterSensitiveLog: (obj: RegionDisabledException) => any;
}
export interface AssumeRoleWithSAMLRequest {
    
    RoleArn: string | undefined;
    
    PrincipalArn: string | undefined;
    
    SAMLAssertion: string | undefined;
    
    PolicyArns?: PolicyDescriptorType[];
    
    Policy?: string;
    
    DurationSeconds?: number;
}
export declare namespace AssumeRoleWithSAMLRequest {
    
    const filterSensitiveLog: (obj: AssumeRoleWithSAMLRequest) => any;
}

export interface AssumeRoleWithSAMLResponse {
    
    Credentials?: Credentials;
    
    AssumedRoleUser?: AssumedRoleUser;
    
    PackedPolicySize?: number;
    
    Subject?: string;
    
    SubjectType?: string;
    
    Issuer?: string;
    
    Audience?: string;
    
    NameQualifier?: string;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleWithSAMLResponse {
    
    const filterSensitiveLog: (obj: AssumeRoleWithSAMLResponse) => any;
}

export interface IDPRejectedClaimException extends __SmithyException, $MetadataBearer {
    name: "IDPRejectedClaimException";
    $fault: "client";
    message?: string;
}
export declare namespace IDPRejectedClaimException {
    
    const filterSensitiveLog: (obj: IDPRejectedClaimException) => any;
}

export interface InvalidIdentityTokenException extends __SmithyException, $MetadataBearer {
    name: "InvalidIdentityTokenException";
    $fault: "client";
    message?: string;
}
export declare namespace InvalidIdentityTokenException {
    
    const filterSensitiveLog: (obj: InvalidIdentityTokenException) => any;
}
export interface AssumeRoleWithWebIdentityRequest {
    
    RoleArn: string | undefined;
    
    RoleSessionName: string | undefined;
    
    WebIdentityToken: string | undefined;
    
    ProviderId?: string;
    
    PolicyArns?: PolicyDescriptorType[];
    
    Policy?: string;
    
    DurationSeconds?: number;
}
export declare namespace AssumeRoleWithWebIdentityRequest {
    
    const filterSensitiveLog: (obj: AssumeRoleWithWebIdentityRequest) => any;
}

export interface AssumeRoleWithWebIdentityResponse {
    
    Credentials?: Credentials;
    
    SubjectFromWebIdentityToken?: string;
    
    AssumedRoleUser?: AssumedRoleUser;
    
    PackedPolicySize?: number;
    
    Provider?: string;
    
    Audience?: string;
    
    SourceIdentity?: string;
}
export declare namespace AssumeRoleWithWebIdentityResponse {
    
    const filterSensitiveLog: (obj: AssumeRoleWithWebIdentityResponse) => any;
}

export interface IDPCommunicationErrorException extends __SmithyException, $MetadataBearer {
    name: "IDPCommunicationErrorException";
    $fault: "client";
    message?: string;
}
export declare namespace IDPCommunicationErrorException {
    
    const filterSensitiveLog: (obj: IDPCommunicationErrorException) => any;
}
export interface DecodeAuthorizationMessageRequest {
    
    EncodedMessage: string | undefined;
}
export declare namespace DecodeAuthorizationMessageRequest {
    
    const filterSensitiveLog: (obj: DecodeAuthorizationMessageRequest) => any;
}

export interface DecodeAuthorizationMessageResponse {
    
    DecodedMessage?: string;
}
export declare namespace DecodeAuthorizationMessageResponse {
    
    const filterSensitiveLog: (obj: DecodeAuthorizationMessageResponse) => any;
}

export interface InvalidAuthorizationMessageException extends __SmithyException, $MetadataBearer {
    name: "InvalidAuthorizationMessageException";
    $fault: "client";
    message?: string;
}
export declare namespace InvalidAuthorizationMessageException {
    
    const filterSensitiveLog: (obj: InvalidAuthorizationMessageException) => any;
}
export interface GetAccessKeyInfoRequest {
    
    AccessKeyId: string | undefined;
}
export declare namespace GetAccessKeyInfoRequest {
    
    const filterSensitiveLog: (obj: GetAccessKeyInfoRequest) => any;
}
export interface GetAccessKeyInfoResponse {
    
    Account?: string;
}
export declare namespace GetAccessKeyInfoResponse {
    
    const filterSensitiveLog: (obj: GetAccessKeyInfoResponse) => any;
}
export interface GetCallerIdentityRequest {
}
export declare namespace GetCallerIdentityRequest {
    
    const filterSensitiveLog: (obj: GetCallerIdentityRequest) => any;
}

export interface GetCallerIdentityResponse {
    
    UserId?: string;
    
    Account?: string;
    
    Arn?: string;
}
export declare namespace GetCallerIdentityResponse {
    
    const filterSensitiveLog: (obj: GetCallerIdentityResponse) => any;
}
export interface GetFederationTokenRequest {
    
    Name: string | undefined;
    
    Policy?: string;
    
    PolicyArns?: PolicyDescriptorType[];
    
    DurationSeconds?: number;
    
    Tags?: Tag[];
}
export declare namespace GetFederationTokenRequest {
    
    const filterSensitiveLog: (obj: GetFederationTokenRequest) => any;
}

export interface FederatedUser {
    
    FederatedUserId: string | undefined;
    
    Arn: string | undefined;
}
export declare namespace FederatedUser {
    
    const filterSensitiveLog: (obj: FederatedUser) => any;
}

export interface GetFederationTokenResponse {
    
    Credentials?: Credentials;
    
    FederatedUser?: FederatedUser;
    
    PackedPolicySize?: number;
}
export declare namespace GetFederationTokenResponse {
    
    const filterSensitiveLog: (obj: GetFederationTokenResponse) => any;
}
export interface GetSessionTokenRequest {
    
    DurationSeconds?: number;
    
    SerialNumber?: string;
    
    TokenCode?: string;
}
export declare namespace GetSessionTokenRequest {
    
    const filterSensitiveLog: (obj: GetSessionTokenRequest) => any;
}

export interface GetSessionTokenResponse {
    
    Credentials?: Credentials;
}
export declare namespace GetSessionTokenResponse {
    
    const filterSensitiveLog: (obj: GetSessionTokenResponse) => any;
}
