import { _InstanceType, ByoipCidr, HostnameType, IamInstanceProfileSpecification, IpPermission, TagSpecification, TransitGatewayAttachmentResourceType } from "./models_0";
import { BlockDeviceMapping, CreditSpecificationRequest, ElasticGpuSpecification, InstanceIpv6Address, LocalGatewayRoute, Placement, ShutdownBehavior } from "./models_1";
import { ClientVpnConnectionStatus, Filter, TransitGatewayRoute } from "./models_2";
import { HttpTokensState, InstanceMetadataEndpointState, InstanceMetadataProtocolState, InstanceState, NetworkInsightsAccessScopeAnalysis, NetworkInsightsAnalysis } from "./models_3";
import { InstanceNetworkInterfaceSpecification, RunInstancesMonitoringEnabled } from "./models_4";
import { CapacityReservationSpecification, CpuOptionsRequest, ElasticInferenceAccelerator, EnclaveOptionsRequest, HibernationOptionsRequest, InstanceMarketOptionsRequest, InstanceMonitoring } from "./models_5";

export interface LaunchTemplateSpecification {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    Version?: string;
}
export declare namespace LaunchTemplateSpecification {
    
    const filterSensitiveLog: (obj: LaunchTemplateSpecification) => any;
}

export interface LicenseConfigurationRequest {
    
    LicenseConfigurationArn?: string;
}
export declare namespace LicenseConfigurationRequest {
    
    const filterSensitiveLog: (obj: LicenseConfigurationRequest) => any;
}

export interface InstanceMetadataOptionsRequest {
    
    HttpTokens?: HttpTokensState | string;
    
    HttpPutResponseHopLimit?: number;
    
    HttpEndpoint?: InstanceMetadataEndpointState | string;
    
    HttpProtocolIpv6?: InstanceMetadataProtocolState | string;
}
export declare namespace InstanceMetadataOptionsRequest {
    
    const filterSensitiveLog: (obj: InstanceMetadataOptionsRequest) => any;
}

export interface PrivateDnsNameOptionsRequest {
    
    HostnameType?: HostnameType | string;
    
    EnableResourceNameDnsARecord?: boolean;
    
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace PrivateDnsNameOptionsRequest {
    
    const filterSensitiveLog: (obj: PrivateDnsNameOptionsRequest) => any;
}
export interface RunInstancesRequest {
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    ImageId?: string;
    
    InstanceType?: _InstanceType | string;
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: InstanceIpv6Address[];
    
    KernelId?: string;
    
    KeyName?: string;
    
    MaxCount: number | undefined;
    
    MinCount: number | undefined;
    
    Monitoring?: RunInstancesMonitoringEnabled;
    
    Placement?: Placement;
    
    RamdiskId?: string;
    
    SecurityGroupIds?: string[];
    
    SecurityGroups?: string[];
    
    SubnetId?: string;
    
    UserData?: string;
    
    AdditionalInfo?: string;
    
    ClientToken?: string;
    
    DisableApiTermination?: boolean;
    
    DryRun?: boolean;
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: IamInstanceProfileSpecification;
    
    InstanceInitiatedShutdownBehavior?: ShutdownBehavior | string;
    
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    
    PrivateIpAddress?: string;
    
    ElasticGpuSpecification?: ElasticGpuSpecification[];
    
    ElasticInferenceAccelerators?: ElasticInferenceAccelerator[];
    
    TagSpecifications?: TagSpecification[];
    
    LaunchTemplate?: LaunchTemplateSpecification;
    
    InstanceMarketOptions?: InstanceMarketOptionsRequest;
    
    CreditSpecification?: CreditSpecificationRequest;
    
    CpuOptions?: CpuOptionsRequest;
    
    CapacityReservationSpecification?: CapacityReservationSpecification;
    
    HibernationOptions?: HibernationOptionsRequest;
    
    LicenseSpecifications?: LicenseConfigurationRequest[];
    
    MetadataOptions?: InstanceMetadataOptionsRequest;
    
    EnclaveOptions?: EnclaveOptionsRequest;
    
    PrivateDnsNameOptions?: PrivateDnsNameOptionsRequest;
}
export declare namespace RunInstancesRequest {
    
    const filterSensitiveLog: (obj: RunInstancesRequest) => any;
}

export interface ScheduledInstancesEbs {
    
    DeleteOnTermination?: boolean;
    
    Encrypted?: boolean;
    
    Iops?: number;
    
    SnapshotId?: string;
    
    VolumeSize?: number;
    
    VolumeType?: string;
}
export declare namespace ScheduledInstancesEbs {
    
    const filterSensitiveLog: (obj: ScheduledInstancesEbs) => any;
}

export interface ScheduledInstancesBlockDeviceMapping {
    
    DeviceName?: string;
    
    Ebs?: ScheduledInstancesEbs;
    
    NoDevice?: string;
    
    VirtualName?: string;
}
export declare namespace ScheduledInstancesBlockDeviceMapping {
    
    const filterSensitiveLog: (obj: ScheduledInstancesBlockDeviceMapping) => any;
}

export interface ScheduledInstancesIamInstanceProfile {
    
    Arn?: string;
    
    Name?: string;
}
export declare namespace ScheduledInstancesIamInstanceProfile {
    
    const filterSensitiveLog: (obj: ScheduledInstancesIamInstanceProfile) => any;
}

export interface ScheduledInstancesMonitoring {
    
    Enabled?: boolean;
}
export declare namespace ScheduledInstancesMonitoring {
    
    const filterSensitiveLog: (obj: ScheduledInstancesMonitoring) => any;
}

export interface ScheduledInstancesIpv6Address {
    
    Ipv6Address?: string;
}
export declare namespace ScheduledInstancesIpv6Address {
    
    const filterSensitiveLog: (obj: ScheduledInstancesIpv6Address) => any;
}

export interface ScheduledInstancesPrivateIpAddressConfig {
    
    Primary?: boolean;
    
    PrivateIpAddress?: string;
}
export declare namespace ScheduledInstancesPrivateIpAddressConfig {
    
    const filterSensitiveLog: (obj: ScheduledInstancesPrivateIpAddressConfig) => any;
}

export interface ScheduledInstancesNetworkInterface {
    
    AssociatePublicIpAddress?: boolean;
    
    DeleteOnTermination?: boolean;
    
    Description?: string;
    
    DeviceIndex?: number;
    
    Groups?: string[];
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: ScheduledInstancesIpv6Address[];
    
    NetworkInterfaceId?: string;
    
    PrivateIpAddress?: string;
    
    PrivateIpAddressConfigs?: ScheduledInstancesPrivateIpAddressConfig[];
    
    SecondaryPrivateIpAddressCount?: number;
    
    SubnetId?: string;
}
export declare namespace ScheduledInstancesNetworkInterface {
    
    const filterSensitiveLog: (obj: ScheduledInstancesNetworkInterface) => any;
}

export interface ScheduledInstancesPlacement {
    
    AvailabilityZone?: string;
    
    GroupName?: string;
}
export declare namespace ScheduledInstancesPlacement {
    
    const filterSensitiveLog: (obj: ScheduledInstancesPlacement) => any;
}

export interface ScheduledInstancesLaunchSpecification {
    
    BlockDeviceMappings?: ScheduledInstancesBlockDeviceMapping[];
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: ScheduledInstancesIamInstanceProfile;
    
    ImageId: string | undefined;
    
    InstanceType?: string;
    
    KernelId?: string;
    
    KeyName?: string;
    
    Monitoring?: ScheduledInstancesMonitoring;
    
    NetworkInterfaces?: ScheduledInstancesNetworkInterface[];
    
    Placement?: ScheduledInstancesPlacement;
    
    RamdiskId?: string;
    
    SecurityGroupIds?: string[];
    
    SubnetId?: string;
    
    UserData?: string;
}
export declare namespace ScheduledInstancesLaunchSpecification {
    
    const filterSensitiveLog: (obj: ScheduledInstancesLaunchSpecification) => any;
}

export interface RunScheduledInstancesRequest {
    
    ClientToken?: string;
    
    DryRun?: boolean;
    
    InstanceCount?: number;
    
    LaunchSpecification: ScheduledInstancesLaunchSpecification | undefined;
    
    ScheduledInstanceId: string | undefined;
}
export declare namespace RunScheduledInstancesRequest {
    
    const filterSensitiveLog: (obj: RunScheduledInstancesRequest) => any;
}

export interface RunScheduledInstancesResult {
    
    InstanceIdSet?: string[];
}
export declare namespace RunScheduledInstancesResult {
    
    const filterSensitiveLog: (obj: RunScheduledInstancesResult) => any;
}
export interface SearchLocalGatewayRoutesRequest {
    
    LocalGatewayRouteTableId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace SearchLocalGatewayRoutesRequest {
    
    const filterSensitiveLog: (obj: SearchLocalGatewayRoutesRequest) => any;
}
export interface SearchLocalGatewayRoutesResult {
    
    Routes?: LocalGatewayRoute[];
    
    NextToken?: string;
}
export declare namespace SearchLocalGatewayRoutesResult {
    
    const filterSensitiveLog: (obj: SearchLocalGatewayRoutesResult) => any;
}
export interface SearchTransitGatewayMulticastGroupsRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace SearchTransitGatewayMulticastGroupsRequest {
    
    const filterSensitiveLog: (obj: SearchTransitGatewayMulticastGroupsRequest) => any;
}
export declare type MembershipType = "igmp" | "static";

export interface TransitGatewayMulticastGroup {
    
    GroupIpAddress?: string;
    
    TransitGatewayAttachmentId?: string;
    
    SubnetId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    ResourceOwnerId?: string;
    
    NetworkInterfaceId?: string;
    
    GroupMember?: boolean;
    
    GroupSource?: boolean;
    
    MemberType?: MembershipType | string;
    
    SourceType?: MembershipType | string;
}
export declare namespace TransitGatewayMulticastGroup {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastGroup) => any;
}
export interface SearchTransitGatewayMulticastGroupsResult {
    
    MulticastGroups?: TransitGatewayMulticastGroup[];
    
    NextToken?: string;
}
export declare namespace SearchTransitGatewayMulticastGroupsResult {
    
    const filterSensitiveLog: (obj: SearchTransitGatewayMulticastGroupsResult) => any;
}
export interface SearchTransitGatewayRoutesRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    Filters: Filter[] | undefined;
    
    MaxResults?: number;
    
    DryRun?: boolean;
}
export declare namespace SearchTransitGatewayRoutesRequest {
    
    const filterSensitiveLog: (obj: SearchTransitGatewayRoutesRequest) => any;
}
export interface SearchTransitGatewayRoutesResult {
    
    Routes?: TransitGatewayRoute[];
    
    AdditionalRoutesAvailable?: boolean;
}
export declare namespace SearchTransitGatewayRoutesResult {
    
    const filterSensitiveLog: (obj: SearchTransitGatewayRoutesResult) => any;
}
export interface SendDiagnosticInterruptRequest {
    
    InstanceId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace SendDiagnosticInterruptRequest {
    
    const filterSensitiveLog: (obj: SendDiagnosticInterruptRequest) => any;
}
export interface StartInstancesRequest {
    
    InstanceIds: string[] | undefined;
    
    AdditionalInfo?: string;
    
    DryRun?: boolean;
}
export declare namespace StartInstancesRequest {
    
    const filterSensitiveLog: (obj: StartInstancesRequest) => any;
}

export interface InstanceStateChange {
    
    CurrentState?: InstanceState;
    
    InstanceId?: string;
    
    PreviousState?: InstanceState;
}
export declare namespace InstanceStateChange {
    
    const filterSensitiveLog: (obj: InstanceStateChange) => any;
}
export interface StartInstancesResult {
    
    StartingInstances?: InstanceStateChange[];
}
export declare namespace StartInstancesResult {
    
    const filterSensitiveLog: (obj: StartInstancesResult) => any;
}
export interface StartNetworkInsightsAccessScopeAnalysisRequest {
    
    NetworkInsightsAccessScopeId: string | undefined;
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
    
    ClientToken?: string;
}
export declare namespace StartNetworkInsightsAccessScopeAnalysisRequest {
    
    const filterSensitiveLog: (obj: StartNetworkInsightsAccessScopeAnalysisRequest) => any;
}
export interface StartNetworkInsightsAccessScopeAnalysisResult {
    
    NetworkInsightsAccessScopeAnalysis?: NetworkInsightsAccessScopeAnalysis;
}
export declare namespace StartNetworkInsightsAccessScopeAnalysisResult {
    
    const filterSensitiveLog: (obj: StartNetworkInsightsAccessScopeAnalysisResult) => any;
}
export interface StartNetworkInsightsAnalysisRequest {
    
    NetworkInsightsPathId: string | undefined;
    
    FilterInArns?: string[];
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
    
    ClientToken?: string;
}
export declare namespace StartNetworkInsightsAnalysisRequest {
    
    const filterSensitiveLog: (obj: StartNetworkInsightsAnalysisRequest) => any;
}
export interface StartNetworkInsightsAnalysisResult {
    
    NetworkInsightsAnalysis?: NetworkInsightsAnalysis;
}
export declare namespace StartNetworkInsightsAnalysisResult {
    
    const filterSensitiveLog: (obj: StartNetworkInsightsAnalysisResult) => any;
}
export interface StartVpcEndpointServicePrivateDnsVerificationRequest {
    
    DryRun?: boolean;
    
    ServiceId: string | undefined;
}
export declare namespace StartVpcEndpointServicePrivateDnsVerificationRequest {
    
    const filterSensitiveLog: (obj: StartVpcEndpointServicePrivateDnsVerificationRequest) => any;
}
export interface StartVpcEndpointServicePrivateDnsVerificationResult {
    
    ReturnValue?: boolean;
}
export declare namespace StartVpcEndpointServicePrivateDnsVerificationResult {
    
    const filterSensitiveLog: (obj: StartVpcEndpointServicePrivateDnsVerificationResult) => any;
}
export interface StopInstancesRequest {
    
    InstanceIds: string[] | undefined;
    
    Hibernate?: boolean;
    
    DryRun?: boolean;
    
    Force?: boolean;
}
export declare namespace StopInstancesRequest {
    
    const filterSensitiveLog: (obj: StopInstancesRequest) => any;
}
export interface StopInstancesResult {
    
    StoppingInstances?: InstanceStateChange[];
}
export declare namespace StopInstancesResult {
    
    const filterSensitiveLog: (obj: StopInstancesResult) => any;
}
export interface TerminateClientVpnConnectionsRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    ConnectionId?: string;
    
    Username?: string;
    
    DryRun?: boolean;
}
export declare namespace TerminateClientVpnConnectionsRequest {
    
    const filterSensitiveLog: (obj: TerminateClientVpnConnectionsRequest) => any;
}

export interface TerminateConnectionStatus {
    
    ConnectionId?: string;
    
    PreviousStatus?: ClientVpnConnectionStatus;
    
    CurrentStatus?: ClientVpnConnectionStatus;
}
export declare namespace TerminateConnectionStatus {
    
    const filterSensitiveLog: (obj: TerminateConnectionStatus) => any;
}
export interface TerminateClientVpnConnectionsResult {
    
    ClientVpnEndpointId?: string;
    
    Username?: string;
    
    ConnectionStatuses?: TerminateConnectionStatus[];
}
export declare namespace TerminateClientVpnConnectionsResult {
    
    const filterSensitiveLog: (obj: TerminateClientVpnConnectionsResult) => any;
}
export interface TerminateInstancesRequest {
    
    InstanceIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace TerminateInstancesRequest {
    
    const filterSensitiveLog: (obj: TerminateInstancesRequest) => any;
}
export interface TerminateInstancesResult {
    
    TerminatingInstances?: InstanceStateChange[];
}
export declare namespace TerminateInstancesResult {
    
    const filterSensitiveLog: (obj: TerminateInstancesResult) => any;
}
export interface UnassignIpv6AddressesRequest {
    
    Ipv6Addresses?: string[];
    
    Ipv6Prefixes?: string[];
    
    NetworkInterfaceId: string | undefined;
}
export declare namespace UnassignIpv6AddressesRequest {
    
    const filterSensitiveLog: (obj: UnassignIpv6AddressesRequest) => any;
}
export interface UnassignIpv6AddressesResult {
    
    NetworkInterfaceId?: string;
    
    UnassignedIpv6Addresses?: string[];
    
    UnassignedIpv6Prefixes?: string[];
}
export declare namespace UnassignIpv6AddressesResult {
    
    const filterSensitiveLog: (obj: UnassignIpv6AddressesResult) => any;
}

export interface UnassignPrivateIpAddressesRequest {
    
    NetworkInterfaceId: string | undefined;
    
    PrivateIpAddresses?: string[];
    
    Ipv4Prefixes?: string[];
}
export declare namespace UnassignPrivateIpAddressesRequest {
    
    const filterSensitiveLog: (obj: UnassignPrivateIpAddressesRequest) => any;
}
export interface UnmonitorInstancesRequest {
    
    InstanceIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace UnmonitorInstancesRequest {
    
    const filterSensitiveLog: (obj: UnmonitorInstancesRequest) => any;
}
export interface UnmonitorInstancesResult {
    
    InstanceMonitorings?: InstanceMonitoring[];
}
export declare namespace UnmonitorInstancesResult {
    
    const filterSensitiveLog: (obj: UnmonitorInstancesResult) => any;
}

export interface SecurityGroupRuleDescription {
    
    SecurityGroupRuleId?: string;
    
    Description?: string;
}
export declare namespace SecurityGroupRuleDescription {
    
    const filterSensitiveLog: (obj: SecurityGroupRuleDescription) => any;
}
export interface UpdateSecurityGroupRuleDescriptionsEgressRequest {
    
    DryRun?: boolean;
    
    GroupId?: string;
    
    GroupName?: string;
    
    IpPermissions?: IpPermission[];
    
    SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
export declare namespace UpdateSecurityGroupRuleDescriptionsEgressRequest {
    
    const filterSensitiveLog: (obj: UpdateSecurityGroupRuleDescriptionsEgressRequest) => any;
}
export interface UpdateSecurityGroupRuleDescriptionsEgressResult {
    
    Return?: boolean;
}
export declare namespace UpdateSecurityGroupRuleDescriptionsEgressResult {
    
    const filterSensitiveLog: (obj: UpdateSecurityGroupRuleDescriptionsEgressResult) => any;
}
export interface UpdateSecurityGroupRuleDescriptionsIngressRequest {
    
    DryRun?: boolean;
    
    GroupId?: string;
    
    GroupName?: string;
    
    IpPermissions?: IpPermission[];
    
    SecurityGroupRuleDescriptions?: SecurityGroupRuleDescription[];
}
export declare namespace UpdateSecurityGroupRuleDescriptionsIngressRequest {
    
    const filterSensitiveLog: (obj: UpdateSecurityGroupRuleDescriptionsIngressRequest) => any;
}
export interface UpdateSecurityGroupRuleDescriptionsIngressResult {
    
    Return?: boolean;
}
export declare namespace UpdateSecurityGroupRuleDescriptionsIngressResult {
    
    const filterSensitiveLog: (obj: UpdateSecurityGroupRuleDescriptionsIngressResult) => any;
}
export interface WithdrawByoipCidrRequest {
    
    Cidr: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace WithdrawByoipCidrRequest {
    
    const filterSensitiveLog: (obj: WithdrawByoipCidrRequest) => any;
}
export interface WithdrawByoipCidrResult {
    
    ByoipCidr?: ByoipCidr;
}
export declare namespace WithdrawByoipCidrResult {
    
    const filterSensitiveLog: (obj: WithdrawByoipCidrResult) => any;
}
