import { _InstanceType, ActiveInstance, ActivityStatus, AllocationStrategy, AllowedPrincipal, AssociationStatus, BatchState, CapacityReservationState, CurrencyCodeValues, IamInstanceProfileAssociation, IamInstanceProfileSpecification, InstanceEventWindow, IpamPoolAllocation, IpPermission, ResourceType, SecurityGroupRule, Subnet, SubnetIpv6CidrBlockAssociation, Tag, TagSpecification, Tenancy, TransitGatewayAssociation, TransitGatewayAssociationState, TransitGatewayAttachmentResourceType, TransitGatewayAttachmentState, TransitGatewayMulticastDomainAssociations, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, TrunkInterfaceAssociation, UserIdGroupPair, Vpc, VpcCidrBlockAssociation, VpcIpv6CidrBlockAssociation, VpcPeeringConnection } from "./models_0";
import { BlockDeviceMapping, DiskImageFormat, FleetLaunchTemplateSpecification, FleetType, GroupIdentifier, InstanceInterruptionBehavior, InstanceIpv6Address, InstanceRequirements, InstanceRequirementsRequest, IpamResourceTag, Ipv4PrefixSpecificationRequest, Ipv6PrefixSpecificationRequest, PrivateIpAddressSpecification, RequestIpamResourceTag, RouteTable, Snapshot, SnapshotState, SpotDatafeedSubscription, SpotInstanceStateFault, SpotInstanceType, StorageTier, TargetCapacityUnitType, TrafficMirrorFilter, TrafficMirrorSession, TrafficMirrorTarget, TransitGateway, TransitGatewayConnect, VolumeType } from "./models_1";
import { ConnectionNotification, DnsEntry, DnsNameState, Filter, IpamPoolCidr, ServiceConfiguration, ServiceTypeDetail, State, TransitGatewayConnectPeer, TransitGatewayMulticastDomain, TransitGatewayRouteTable, Volume, VpcEndpoint, VpnConnection, VpnGateway } from "./models_2";
import { ArchitectureType, AttributeBooleanValue, EventInformation, ExportTaskS3Location, FastSnapshotRestoreStateCode, OfferingClassType, OfferingTypeValues, PaymentOption, PermissionGroup, ProductCode, RecurringCharge, ReservedInstancesModification, RIProductDescription, Scope, VirtualizationType } from "./models_3";

export interface DescribeReservedInstancesModificationsResult {
    
    NextToken?: string;
    
    ReservedInstancesModifications?: ReservedInstancesModification[];
}
export declare namespace DescribeReservedInstancesModificationsResult {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesModificationsResult) => any;
}

export interface DescribeReservedInstancesOfferingsRequest {
    
    AvailabilityZone?: string;
    
    Filters?: Filter[];
    
    IncludeMarketplace?: boolean;
    
    InstanceType?: _InstanceType | string;
    
    MaxDuration?: number;
    
    MaxInstanceCount?: number;
    
    MinDuration?: number;
    
    OfferingClass?: OfferingClassType | string;
    
    ProductDescription?: RIProductDescription | string;
    
    ReservedInstancesOfferingIds?: string[];
    
    DryRun?: boolean;
    
    InstanceTenancy?: Tenancy | string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    OfferingType?: OfferingTypeValues | string;
}
export declare namespace DescribeReservedInstancesOfferingsRequest {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesOfferingsRequest) => any;
}

export interface PricingDetail {
    
    Count?: number;
    
    Price?: number;
}
export declare namespace PricingDetail {
    
    const filterSensitiveLog: (obj: PricingDetail) => any;
}

export interface ReservedInstancesOffering {
    
    AvailabilityZone?: string;
    
    Duration?: number;
    
    FixedPrice?: number;
    
    InstanceType?: _InstanceType | string;
    
    ProductDescription?: RIProductDescription | string;
    
    ReservedInstancesOfferingId?: string;
    
    UsagePrice?: number;
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    InstanceTenancy?: Tenancy | string;
    
    Marketplace?: boolean;
    
    OfferingClass?: OfferingClassType | string;
    
    OfferingType?: OfferingTypeValues | string;
    
    PricingDetails?: PricingDetail[];
    
    RecurringCharges?: RecurringCharge[];
    
    Scope?: Scope | string;
}
export declare namespace ReservedInstancesOffering {
    
    const filterSensitiveLog: (obj: ReservedInstancesOffering) => any;
}

export interface DescribeReservedInstancesOfferingsResult {
    
    ReservedInstancesOfferings?: ReservedInstancesOffering[];
    
    NextToken?: string;
}
export declare namespace DescribeReservedInstancesOfferingsResult {
    
    const filterSensitiveLog: (obj: DescribeReservedInstancesOfferingsResult) => any;
}
export interface DescribeRouteTablesRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    RouteTableIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeRouteTablesRequest {
    
    const filterSensitiveLog: (obj: DescribeRouteTablesRequest) => any;
}

export interface DescribeRouteTablesResult {
    
    RouteTables?: RouteTable[];
    
    NextToken?: string;
}
export declare namespace DescribeRouteTablesResult {
    
    const filterSensitiveLog: (obj: DescribeRouteTablesResult) => any;
}

export interface SlotDateTimeRangeRequest {
    
    EarliestTime: Date | undefined;
    
    LatestTime: Date | undefined;
}
export declare namespace SlotDateTimeRangeRequest {
    
    const filterSensitiveLog: (obj: SlotDateTimeRangeRequest) => any;
}

export interface ScheduledInstanceRecurrenceRequest {
    
    Frequency?: string;
    
    Interval?: number;
    
    OccurrenceDays?: number[];
    
    OccurrenceRelativeToEnd?: boolean;
    
    OccurrenceUnit?: string;
}
export declare namespace ScheduledInstanceRecurrenceRequest {
    
    const filterSensitiveLog: (obj: ScheduledInstanceRecurrenceRequest) => any;
}

export interface DescribeScheduledInstanceAvailabilityRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    FirstSlotStartTimeRange: SlotDateTimeRangeRequest | undefined;
    
    MaxResults?: number;
    
    MaxSlotDurationInHours?: number;
    
    MinSlotDurationInHours?: number;
    
    NextToken?: string;
    
    Recurrence: ScheduledInstanceRecurrenceRequest | undefined;
}
export declare namespace DescribeScheduledInstanceAvailabilityRequest {
    
    const filterSensitiveLog: (obj: DescribeScheduledInstanceAvailabilityRequest) => any;
}

export interface ScheduledInstanceRecurrence {
    
    Frequency?: string;
    
    Interval?: number;
    
    OccurrenceDaySet?: number[];
    
    OccurrenceRelativeToEnd?: boolean;
    
    OccurrenceUnit?: string;
}
export declare namespace ScheduledInstanceRecurrence {
    
    const filterSensitiveLog: (obj: ScheduledInstanceRecurrence) => any;
}

export interface ScheduledInstanceAvailability {
    
    AvailabilityZone?: string;
    
    AvailableInstanceCount?: number;
    
    FirstSlotStartTime?: Date;
    
    HourlyPrice?: string;
    
    InstanceType?: string;
    
    MaxTermDurationInDays?: number;
    
    MinTermDurationInDays?: number;
    
    NetworkPlatform?: string;
    
    Platform?: string;
    
    PurchaseToken?: string;
    
    Recurrence?: ScheduledInstanceRecurrence;
    
    SlotDurationInHours?: number;
    
    TotalScheduledInstanceHours?: number;
}
export declare namespace ScheduledInstanceAvailability {
    
    const filterSensitiveLog: (obj: ScheduledInstanceAvailability) => any;
}

export interface DescribeScheduledInstanceAvailabilityResult {
    
    NextToken?: string;
    
    ScheduledInstanceAvailabilitySet?: ScheduledInstanceAvailability[];
}
export declare namespace DescribeScheduledInstanceAvailabilityResult {
    
    const filterSensitiveLog: (obj: DescribeScheduledInstanceAvailabilityResult) => any;
}

export interface SlotStartTimeRangeRequest {
    
    EarliestTime?: Date;
    
    LatestTime?: Date;
}
export declare namespace SlotStartTimeRangeRequest {
    
    const filterSensitiveLog: (obj: SlotStartTimeRangeRequest) => any;
}

export interface DescribeScheduledInstancesRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    ScheduledInstanceIds?: string[];
    
    SlotStartTimeRange?: SlotStartTimeRangeRequest;
}
export declare namespace DescribeScheduledInstancesRequest {
    
    const filterSensitiveLog: (obj: DescribeScheduledInstancesRequest) => any;
}

export interface ScheduledInstance {
    
    AvailabilityZone?: string;
    
    CreateDate?: Date;
    
    HourlyPrice?: string;
    
    InstanceCount?: number;
    
    InstanceType?: string;
    
    NetworkPlatform?: string;
    
    NextSlotStartTime?: Date;
    
    Platform?: string;
    
    PreviousSlotEndTime?: Date;
    
    Recurrence?: ScheduledInstanceRecurrence;
    
    ScheduledInstanceId?: string;
    
    SlotDurationInHours?: number;
    
    TermEndDate?: Date;
    
    TermStartDate?: Date;
    
    TotalScheduledInstanceHours?: number;
}
export declare namespace ScheduledInstance {
    
    const filterSensitiveLog: (obj: ScheduledInstance) => any;
}

export interface DescribeScheduledInstancesResult {
    
    NextToken?: string;
    
    ScheduledInstanceSet?: ScheduledInstance[];
}
export declare namespace DescribeScheduledInstancesResult {
    
    const filterSensitiveLog: (obj: DescribeScheduledInstancesResult) => any;
}
export interface DescribeSecurityGroupReferencesRequest {
    
    DryRun?: boolean;
    
    GroupId: string[] | undefined;
}
export declare namespace DescribeSecurityGroupReferencesRequest {
    
    const filterSensitiveLog: (obj: DescribeSecurityGroupReferencesRequest) => any;
}

export interface SecurityGroupReference {
    
    GroupId?: string;
    
    ReferencingVpcId?: string;
    
    VpcPeeringConnectionId?: string;
}
export declare namespace SecurityGroupReference {
    
    const filterSensitiveLog: (obj: SecurityGroupReference) => any;
}
export interface DescribeSecurityGroupReferencesResult {
    
    SecurityGroupReferenceSet?: SecurityGroupReference[];
}
export declare namespace DescribeSecurityGroupReferencesResult {
    
    const filterSensitiveLog: (obj: DescribeSecurityGroupReferencesResult) => any;
}
export interface DescribeSecurityGroupRulesRequest {
    
    Filters?: Filter[];
    
    SecurityGroupRuleIds?: string[];
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeSecurityGroupRulesRequest {
    
    const filterSensitiveLog: (obj: DescribeSecurityGroupRulesRequest) => any;
}
export interface DescribeSecurityGroupRulesResult {
    
    SecurityGroupRules?: SecurityGroupRule[];
    
    NextToken?: string;
}
export declare namespace DescribeSecurityGroupRulesResult {
    
    const filterSensitiveLog: (obj: DescribeSecurityGroupRulesResult) => any;
}
export interface DescribeSecurityGroupsRequest {
    
    Filters?: Filter[];
    
    GroupIds?: string[];
    
    GroupNames?: string[];
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeSecurityGroupsRequest {
    
    const filterSensitiveLog: (obj: DescribeSecurityGroupsRequest) => any;
}

export interface SecurityGroup {
    
    Description?: string;
    
    GroupName?: string;
    
    IpPermissions?: IpPermission[];
    
    OwnerId?: string;
    
    GroupId?: string;
    
    IpPermissionsEgress?: IpPermission[];
    
    Tags?: Tag[];
    
    VpcId?: string;
}
export declare namespace SecurityGroup {
    
    const filterSensitiveLog: (obj: SecurityGroup) => any;
}
export interface DescribeSecurityGroupsResult {
    
    SecurityGroups?: SecurityGroup[];
    
    NextToken?: string;
}
export declare namespace DescribeSecurityGroupsResult {
    
    const filterSensitiveLog: (obj: DescribeSecurityGroupsResult) => any;
}
export declare type SnapshotAttributeName = "createVolumePermission" | "productCodes";
export interface DescribeSnapshotAttributeRequest {
    
    Attribute: SnapshotAttributeName | string | undefined;
    
    SnapshotId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DescribeSnapshotAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeSnapshotAttributeRequest) => any;
}

export interface CreateVolumePermission {
    
    Group?: PermissionGroup | string;
    
    UserId?: string;
}
export declare namespace CreateVolumePermission {
    
    const filterSensitiveLog: (obj: CreateVolumePermission) => any;
}
export interface DescribeSnapshotAttributeResult {
    
    CreateVolumePermissions?: CreateVolumePermission[];
    
    ProductCodes?: ProductCode[];
    
    SnapshotId?: string;
}
export declare namespace DescribeSnapshotAttributeResult {
    
    const filterSensitiveLog: (obj: DescribeSnapshotAttributeResult) => any;
}
export interface DescribeSnapshotsRequest {
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    OwnerIds?: string[];
    
    RestorableByUserIds?: string[];
    
    SnapshotIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeSnapshotsRequest {
    
    const filterSensitiveLog: (obj: DescribeSnapshotsRequest) => any;
}
export interface DescribeSnapshotsResult {
    
    Snapshots?: Snapshot[];
    
    NextToken?: string;
}
export declare namespace DescribeSnapshotsResult {
    
    const filterSensitiveLog: (obj: DescribeSnapshotsResult) => any;
}
export interface DescribeSnapshotTierStatusRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeSnapshotTierStatusRequest {
    
    const filterSensitiveLog: (obj: DescribeSnapshotTierStatusRequest) => any;
}
export declare enum TieringOperationStatus {
    archival_completed = "archival-completed",
    archival_failed = "archival-failed",
    archival_in_progress = "archival-in-progress",
    permanent_restore_completed = "permanent-restore-completed",
    permanent_restore_failed = "permanent-restore-failed",
    permanent_restore_in_progress = "permanent-restore-in-progress",
    temporary_restore_completed = "temporary-restore-completed",
    temporary_restore_failed = "temporary-restore-failed",
    temporary_restore_in_progress = "temporary-restore-in-progress"
}

export interface SnapshotTierStatus {
    
    SnapshotId?: string;
    
    VolumeId?: string;
    
    Status?: SnapshotState | string;
    
    OwnerId?: string;
    
    Tags?: Tag[];
    
    StorageTier?: StorageTier | string;
    
    LastTieringStartTime?: Date;
    
    LastTieringProgress?: number;
    
    LastTieringOperationStatus?: TieringOperationStatus | string;
    
    LastTieringOperationStatusDetail?: string;
    
    ArchivalCompleteTime?: Date;
    
    RestoreExpiryTime?: Date;
}
export declare namespace SnapshotTierStatus {
    
    const filterSensitiveLog: (obj: SnapshotTierStatus) => any;
}
export interface DescribeSnapshotTierStatusResult {
    
    SnapshotTierStatuses?: SnapshotTierStatus[];
    
    NextToken?: string;
}
export declare namespace DescribeSnapshotTierStatusResult {
    
    const filterSensitiveLog: (obj: DescribeSnapshotTierStatusResult) => any;
}

export interface DescribeSpotDatafeedSubscriptionRequest {
    
    DryRun?: boolean;
}
export declare namespace DescribeSpotDatafeedSubscriptionRequest {
    
    const filterSensitiveLog: (obj: DescribeSpotDatafeedSubscriptionRequest) => any;
}

export interface DescribeSpotDatafeedSubscriptionResult {
    
    SpotDatafeedSubscription?: SpotDatafeedSubscription;
}
export declare namespace DescribeSpotDatafeedSubscriptionResult {
    
    const filterSensitiveLog: (obj: DescribeSpotDatafeedSubscriptionResult) => any;
}

export interface DescribeSpotFleetInstancesRequest {
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    SpotFleetRequestId: string | undefined;
}
export declare namespace DescribeSpotFleetInstancesRequest {
    
    const filterSensitiveLog: (obj: DescribeSpotFleetInstancesRequest) => any;
}

export interface DescribeSpotFleetInstancesResponse {
    
    ActiveInstances?: ActiveInstance[];
    
    NextToken?: string;
    
    SpotFleetRequestId?: string;
}
export declare namespace DescribeSpotFleetInstancesResponse {
    
    const filterSensitiveLog: (obj: DescribeSpotFleetInstancesResponse) => any;
}
export declare enum EventType {
    BATCH_CHANGE = "fleetRequestChange",
    ERROR = "error",
    INFORMATION = "information",
    INSTANCE_CHANGE = "instanceChange"
}

export interface DescribeSpotFleetRequestHistoryRequest {
    
    DryRun?: boolean;
    
    EventType?: EventType | string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    SpotFleetRequestId: string | undefined;
    
    StartTime: Date | undefined;
}
export declare namespace DescribeSpotFleetRequestHistoryRequest {
    
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestHistoryRequest) => any;
}

export interface HistoryRecord {
    
    EventInformation?: EventInformation;
    
    EventType?: EventType | string;
    
    Timestamp?: Date;
}
export declare namespace HistoryRecord {
    
    const filterSensitiveLog: (obj: HistoryRecord) => any;
}

export interface DescribeSpotFleetRequestHistoryResponse {
    
    HistoryRecords?: HistoryRecord[];
    
    LastEvaluatedTime?: Date;
    
    NextToken?: string;
    
    SpotFleetRequestId?: string;
    
    StartTime?: Date;
}
export declare namespace DescribeSpotFleetRequestHistoryResponse {
    
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestHistoryResponse) => any;
}

export interface DescribeSpotFleetRequestsRequest {
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    SpotFleetRequestIds?: string[];
}
export declare namespace DescribeSpotFleetRequestsRequest {
    
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestsRequest) => any;
}
export declare enum ExcessCapacityTerminationPolicy {
    DEFAULT = "default",
    NO_TERMINATION = "noTermination"
}

export interface SpotFleetMonitoring {
    
    Enabled?: boolean;
}
export declare namespace SpotFleetMonitoring {
    
    const filterSensitiveLog: (obj: SpotFleetMonitoring) => any;
}

export interface InstanceNetworkInterfaceSpecification {
    
    AssociatePublicIpAddress?: boolean;
    
    DeleteOnTermination?: boolean;
    
    Description?: string;
    
    DeviceIndex?: number;
    
    Groups?: string[];
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: InstanceIpv6Address[];
    
    NetworkInterfaceId?: string;
    
    PrivateIpAddress?: string;
    
    PrivateIpAddresses?: PrivateIpAddressSpecification[];
    
    SecondaryPrivateIpAddressCount?: number;
    
    SubnetId?: string;
    
    AssociateCarrierIpAddress?: boolean;
    
    InterfaceType?: string;
    
    NetworkCardIndex?: number;
    
    Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[];
    
    Ipv4PrefixCount?: number;
    
    Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[];
    
    Ipv6PrefixCount?: number;
}
export declare namespace InstanceNetworkInterfaceSpecification {
    
    const filterSensitiveLog: (obj: InstanceNetworkInterfaceSpecification) => any;
}

export interface SpotPlacement {
    
    AvailabilityZone?: string;
    
    GroupName?: string;
    
    Tenancy?: Tenancy | string;
}
export declare namespace SpotPlacement {
    
    const filterSensitiveLog: (obj: SpotPlacement) => any;
}

export interface SpotFleetTagSpecification {
    
    ResourceType?: ResourceType | string;
    
    Tags?: Tag[];
}
export declare namespace SpotFleetTagSpecification {
    
    const filterSensitiveLog: (obj: SpotFleetTagSpecification) => any;
}

export interface SpotFleetLaunchSpecification {
    
    SecurityGroups?: GroupIdentifier[];
    
    AddressingType?: string;
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: IamInstanceProfileSpecification;
    
    ImageId?: string;
    
    InstanceType?: _InstanceType | string;
    
    KernelId?: string;
    
    KeyName?: string;
    
    Monitoring?: SpotFleetMonitoring;
    
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    
    Placement?: SpotPlacement;
    
    RamdiskId?: string;
    
    SpotPrice?: string;
    
    SubnetId?: string;
    
    UserData?: string;
    
    WeightedCapacity?: number;
    
    TagSpecifications?: SpotFleetTagSpecification[];
    
    InstanceRequirements?: InstanceRequirements;
}
export declare namespace SpotFleetLaunchSpecification {
    
    const filterSensitiveLog: (obj: SpotFleetLaunchSpecification) => any;
}

export interface LaunchTemplateOverrides {
    
    InstanceType?: _InstanceType | string;
    
    SpotPrice?: string;
    
    SubnetId?: string;
    
    AvailabilityZone?: string;
    
    WeightedCapacity?: number;
    
    Priority?: number;
    
    InstanceRequirements?: InstanceRequirements;
}
export declare namespace LaunchTemplateOverrides {
    
    const filterSensitiveLog: (obj: LaunchTemplateOverrides) => any;
}

export interface LaunchTemplateConfig {
    
    LaunchTemplateSpecification?: FleetLaunchTemplateSpecification;
    
    Overrides?: LaunchTemplateOverrides[];
}
export declare namespace LaunchTemplateConfig {
    
    const filterSensitiveLog: (obj: LaunchTemplateConfig) => any;
}

export interface ClassicLoadBalancer {
    
    Name?: string;
}
export declare namespace ClassicLoadBalancer {
    
    const filterSensitiveLog: (obj: ClassicLoadBalancer) => any;
}

export interface ClassicLoadBalancersConfig {
    
    ClassicLoadBalancers?: ClassicLoadBalancer[];
}
export declare namespace ClassicLoadBalancersConfig {
    
    const filterSensitiveLog: (obj: ClassicLoadBalancersConfig) => any;
}

export interface TargetGroup {
    
    Arn?: string;
}
export declare namespace TargetGroup {
    
    const filterSensitiveLog: (obj: TargetGroup) => any;
}

export interface TargetGroupsConfig {
    
    TargetGroups?: TargetGroup[];
}
export declare namespace TargetGroupsConfig {
    
    const filterSensitiveLog: (obj: TargetGroupsConfig) => any;
}

export interface LoadBalancersConfig {
    
    ClassicLoadBalancersConfig?: ClassicLoadBalancersConfig;
    
    TargetGroupsConfig?: TargetGroupsConfig;
}
export declare namespace LoadBalancersConfig {
    
    const filterSensitiveLog: (obj: LoadBalancersConfig) => any;
}
export declare enum OnDemandAllocationStrategy {
    LOWEST_PRICE = "lowestPrice",
    PRIORITIZED = "prioritized"
}
export declare enum ReplacementStrategy {
    LAUNCH = "launch",
    LAUNCH_BEFORE_TERMINATE = "launch-before-terminate"
}

export interface SpotCapacityRebalance {
    
    ReplacementStrategy?: ReplacementStrategy | string;
    
    TerminationDelay?: number;
}
export declare namespace SpotCapacityRebalance {
    
    const filterSensitiveLog: (obj: SpotCapacityRebalance) => any;
}

export interface SpotMaintenanceStrategies {
    
    CapacityRebalance?: SpotCapacityRebalance;
}
export declare namespace SpotMaintenanceStrategies {
    
    const filterSensitiveLog: (obj: SpotMaintenanceStrategies) => any;
}

export interface SpotFleetRequestConfigData {
    
    AllocationStrategy?: AllocationStrategy | string;
    
    OnDemandAllocationStrategy?: OnDemandAllocationStrategy | string;
    
    SpotMaintenanceStrategies?: SpotMaintenanceStrategies;
    
    ClientToken?: string;
    
    ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | string;
    
    FulfilledCapacity?: number;
    
    OnDemandFulfilledCapacity?: number;
    
    IamFleetRole: string | undefined;
    
    LaunchSpecifications?: SpotFleetLaunchSpecification[];
    
    LaunchTemplateConfigs?: LaunchTemplateConfig[];
    
    SpotPrice?: string;
    
    TargetCapacity: number | undefined;
    
    OnDemandTargetCapacity?: number;
    
    OnDemandMaxTotalPrice?: string;
    
    SpotMaxTotalPrice?: string;
    
    TerminateInstancesWithExpiration?: boolean;
    
    Type?: FleetType | string;
    
    ValidFrom?: Date;
    
    ValidUntil?: Date;
    
    ReplaceUnhealthyInstances?: boolean;
    
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
    
    LoadBalancersConfig?: LoadBalancersConfig;
    
    InstancePoolsToUseCount?: number;
    
    Context?: string;
    
    TargetCapacityUnitType?: TargetCapacityUnitType | string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace SpotFleetRequestConfigData {
    
    const filterSensitiveLog: (obj: SpotFleetRequestConfigData) => any;
}

export interface SpotFleetRequestConfig {
    
    ActivityStatus?: ActivityStatus | string;
    
    CreateTime?: Date;
    
    SpotFleetRequestConfig?: SpotFleetRequestConfigData;
    
    SpotFleetRequestId?: string;
    
    SpotFleetRequestState?: BatchState | string;
    
    Tags?: Tag[];
}
export declare namespace SpotFleetRequestConfig {
    
    const filterSensitiveLog: (obj: SpotFleetRequestConfig) => any;
}

export interface DescribeSpotFleetRequestsResponse {
    
    NextToken?: string;
    
    SpotFleetRequestConfigs?: SpotFleetRequestConfig[];
}
export declare namespace DescribeSpotFleetRequestsResponse {
    
    const filterSensitiveLog: (obj: DescribeSpotFleetRequestsResponse) => any;
}

export interface DescribeSpotInstanceRequestsRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    SpotInstanceRequestIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeSpotInstanceRequestsRequest {
    
    const filterSensitiveLog: (obj: DescribeSpotInstanceRequestsRequest) => any;
}

export interface RunInstancesMonitoringEnabled {
    
    Enabled: boolean | undefined;
}
export declare namespace RunInstancesMonitoringEnabled {
    
    const filterSensitiveLog: (obj: RunInstancesMonitoringEnabled) => any;
}

export interface LaunchSpecification {
    
    UserData?: string;
    
    SecurityGroups?: GroupIdentifier[];
    
    AddressingType?: string;
    
    BlockDeviceMappings?: BlockDeviceMapping[];
    
    EbsOptimized?: boolean;
    
    IamInstanceProfile?: IamInstanceProfileSpecification;
    
    ImageId?: string;
    
    InstanceType?: _InstanceType | string;
    
    KernelId?: string;
    
    KeyName?: string;
    
    NetworkInterfaces?: InstanceNetworkInterfaceSpecification[];
    
    Placement?: SpotPlacement;
    
    RamdiskId?: string;
    
    SubnetId?: string;
    
    Monitoring?: RunInstancesMonitoringEnabled;
}
export declare namespace LaunchSpecification {
    
    const filterSensitiveLog: (obj: LaunchSpecification) => any;
}
export declare type SpotInstanceState = "active" | "cancelled" | "closed" | "failed" | "open";

export interface SpotInstanceStatus {
    
    Code?: string;
    
    Message?: string;
    
    UpdateTime?: Date;
}
export declare namespace SpotInstanceStatus {
    
    const filterSensitiveLog: (obj: SpotInstanceStatus) => any;
}

export interface SpotInstanceRequest {
    
    ActualBlockHourlyPrice?: string;
    
    AvailabilityZoneGroup?: string;
    
    BlockDurationMinutes?: number;
    
    CreateTime?: Date;
    
    Fault?: SpotInstanceStateFault;
    
    InstanceId?: string;
    
    LaunchGroup?: string;
    
    LaunchSpecification?: LaunchSpecification;
    
    LaunchedAvailabilityZone?: string;
    
    ProductDescription?: RIProductDescription | string;
    
    SpotInstanceRequestId?: string;
    
    SpotPrice?: string;
    
    State?: SpotInstanceState | string;
    
    Status?: SpotInstanceStatus;
    
    Tags?: Tag[];
    
    Type?: SpotInstanceType | string;
    
    ValidFrom?: Date;
    
    ValidUntil?: Date;
    
    InstanceInterruptionBehavior?: InstanceInterruptionBehavior | string;
}
export declare namespace SpotInstanceRequest {
    
    const filterSensitiveLog: (obj: SpotInstanceRequest) => any;
}

export interface DescribeSpotInstanceRequestsResult {
    
    SpotInstanceRequests?: SpotInstanceRequest[];
    
    NextToken?: string;
}
export declare namespace DescribeSpotInstanceRequestsResult {
    
    const filterSensitiveLog: (obj: DescribeSpotInstanceRequestsResult) => any;
}

export interface DescribeSpotPriceHistoryRequest {
    
    Filters?: Filter[];
    
    AvailabilityZone?: string;
    
    DryRun?: boolean;
    
    EndTime?: Date;
    
    InstanceTypes?: (_InstanceType | string)[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    ProductDescriptions?: string[];
    
    StartTime?: Date;
}
export declare namespace DescribeSpotPriceHistoryRequest {
    
    const filterSensitiveLog: (obj: DescribeSpotPriceHistoryRequest) => any;
}

export interface SpotPrice {
    
    AvailabilityZone?: string;
    
    InstanceType?: _InstanceType | string;
    
    ProductDescription?: RIProductDescription | string;
    
    SpotPrice?: string;
    
    Timestamp?: Date;
}
export declare namespace SpotPrice {
    
    const filterSensitiveLog: (obj: SpotPrice) => any;
}

export interface DescribeSpotPriceHistoryResult {
    
    NextToken?: string;
    
    SpotPriceHistory?: SpotPrice[];
}
export declare namespace DescribeSpotPriceHistoryResult {
    
    const filterSensitiveLog: (obj: DescribeSpotPriceHistoryResult) => any;
}
export interface DescribeStaleSecurityGroupsRequest {
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    VpcId: string | undefined;
}
export declare namespace DescribeStaleSecurityGroupsRequest {
    
    const filterSensitiveLog: (obj: DescribeStaleSecurityGroupsRequest) => any;
}

export interface StaleIpPermission {
    
    FromPort?: number;
    
    IpProtocol?: string;
    
    IpRanges?: string[];
    
    PrefixListIds?: string[];
    
    ToPort?: number;
    
    UserIdGroupPairs?: UserIdGroupPair[];
}
export declare namespace StaleIpPermission {
    
    const filterSensitiveLog: (obj: StaleIpPermission) => any;
}

export interface StaleSecurityGroup {
    
    Description?: string;
    
    GroupId?: string;
    
    GroupName?: string;
    
    StaleIpPermissions?: StaleIpPermission[];
    
    StaleIpPermissionsEgress?: StaleIpPermission[];
    
    VpcId?: string;
}
export declare namespace StaleSecurityGroup {
    
    const filterSensitiveLog: (obj: StaleSecurityGroup) => any;
}
export interface DescribeStaleSecurityGroupsResult {
    
    NextToken?: string;
    
    StaleSecurityGroupSet?: StaleSecurityGroup[];
}
export declare namespace DescribeStaleSecurityGroupsResult {
    
    const filterSensitiveLog: (obj: DescribeStaleSecurityGroupsResult) => any;
}
export interface DescribeStoreImageTasksRequest {
    
    ImageIds?: string[];
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeStoreImageTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeStoreImageTasksRequest) => any;
}

export interface StoreImageTaskResult {
    
    AmiId?: string;
    
    TaskStartTime?: Date;
    
    Bucket?: string;
    
    S3objectKey?: string;
    
    ProgressPercentage?: number;
    
    StoreTaskState?: string;
    
    StoreTaskFailureReason?: string;
}
export declare namespace StoreImageTaskResult {
    
    const filterSensitiveLog: (obj: StoreImageTaskResult) => any;
}
export interface DescribeStoreImageTasksResult {
    
    StoreImageTaskResults?: StoreImageTaskResult[];
    
    NextToken?: string;
}
export declare namespace DescribeStoreImageTasksResult {
    
    const filterSensitiveLog: (obj: DescribeStoreImageTasksResult) => any;
}
export interface DescribeSubnetsRequest {
    
    Filters?: Filter[];
    
    SubnetIds?: string[];
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeSubnetsRequest {
    
    const filterSensitiveLog: (obj: DescribeSubnetsRequest) => any;
}
export interface DescribeSubnetsResult {
    
    Subnets?: Subnet[];
    
    NextToken?: string;
}
export declare namespace DescribeSubnetsResult {
    
    const filterSensitiveLog: (obj: DescribeSubnetsResult) => any;
}
export interface DescribeTagsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeTagsRequest {
    
    const filterSensitiveLog: (obj: DescribeTagsRequest) => any;
}

export interface TagDescription {
    
    Key?: string;
    
    ResourceId?: string;
    
    ResourceType?: ResourceType | string;
    
    Value?: string;
}
export declare namespace TagDescription {
    
    const filterSensitiveLog: (obj: TagDescription) => any;
}
export interface DescribeTagsResult {
    
    NextToken?: string;
    
    Tags?: TagDescription[];
}
export declare namespace DescribeTagsResult {
    
    const filterSensitiveLog: (obj: DescribeTagsResult) => any;
}
export interface DescribeTrafficMirrorFiltersRequest {
    
    TrafficMirrorFilterIds?: string[];
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorFiltersRequest {
    
    const filterSensitiveLog: (obj: DescribeTrafficMirrorFiltersRequest) => any;
}
export interface DescribeTrafficMirrorFiltersResult {
    
    TrafficMirrorFilters?: TrafficMirrorFilter[];
    
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorFiltersResult {
    
    const filterSensitiveLog: (obj: DescribeTrafficMirrorFiltersResult) => any;
}
export interface DescribeTrafficMirrorSessionsRequest {
    
    TrafficMirrorSessionIds?: string[];
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorSessionsRequest {
    
    const filterSensitiveLog: (obj: DescribeTrafficMirrorSessionsRequest) => any;
}
export interface DescribeTrafficMirrorSessionsResult {
    
    TrafficMirrorSessions?: TrafficMirrorSession[];
    
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorSessionsResult {
    
    const filterSensitiveLog: (obj: DescribeTrafficMirrorSessionsResult) => any;
}
export interface DescribeTrafficMirrorTargetsRequest {
    
    TrafficMirrorTargetIds?: string[];
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorTargetsRequest {
    
    const filterSensitiveLog: (obj: DescribeTrafficMirrorTargetsRequest) => any;
}
export interface DescribeTrafficMirrorTargetsResult {
    
    TrafficMirrorTargets?: TrafficMirrorTarget[];
    
    NextToken?: string;
}
export declare namespace DescribeTrafficMirrorTargetsResult {
    
    const filterSensitiveLog: (obj: DescribeTrafficMirrorTargetsResult) => any;
}
export interface DescribeTransitGatewayAttachmentsRequest {
    
    TransitGatewayAttachmentIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayAttachmentsRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayAttachmentsRequest) => any;
}

export interface TransitGatewayAttachmentAssociation {
    
    TransitGatewayRouteTableId?: string;
    
    State?: TransitGatewayAssociationState | string;
}
export declare namespace TransitGatewayAttachmentAssociation {
    
    const filterSensitiveLog: (obj: TransitGatewayAttachmentAssociation) => any;
}

export interface TransitGatewayAttachment {
    
    TransitGatewayAttachmentId?: string;
    
    TransitGatewayId?: string;
    
    TransitGatewayOwnerId?: string;
    
    ResourceOwnerId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    ResourceId?: string;
    
    State?: TransitGatewayAttachmentState | string;
    
    Association?: TransitGatewayAttachmentAssociation;
    
    CreationTime?: Date;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayAttachment {
    
    const filterSensitiveLog: (obj: TransitGatewayAttachment) => any;
}
export interface DescribeTransitGatewayAttachmentsResult {
    
    TransitGatewayAttachments?: TransitGatewayAttachment[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayAttachmentsResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayAttachmentsResult) => any;
}
export interface DescribeTransitGatewayConnectPeersRequest {
    
    TransitGatewayConnectPeerIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayConnectPeersRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectPeersRequest) => any;
}
export interface DescribeTransitGatewayConnectPeersResult {
    
    TransitGatewayConnectPeers?: TransitGatewayConnectPeer[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayConnectPeersResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectPeersResult) => any;
}
export interface DescribeTransitGatewayConnectsRequest {
    
    TransitGatewayAttachmentIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayConnectsRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectsRequest) => any;
}
export interface DescribeTransitGatewayConnectsResult {
    
    TransitGatewayConnects?: TransitGatewayConnect[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayConnectsResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayConnectsResult) => any;
}
export interface DescribeTransitGatewayMulticastDomainsRequest {
    
    TransitGatewayMulticastDomainIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayMulticastDomainsRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayMulticastDomainsRequest) => any;
}
export interface DescribeTransitGatewayMulticastDomainsResult {
    
    TransitGatewayMulticastDomains?: TransitGatewayMulticastDomain[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayMulticastDomainsResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayMulticastDomainsResult) => any;
}
export interface DescribeTransitGatewayPeeringAttachmentsRequest {
    
    TransitGatewayAttachmentIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayPeeringAttachmentsRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayPeeringAttachmentsRequest) => any;
}
export interface DescribeTransitGatewayPeeringAttachmentsResult {
    
    TransitGatewayPeeringAttachments?: TransitGatewayPeeringAttachment[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayPeeringAttachmentsResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayPeeringAttachmentsResult) => any;
}
export interface DescribeTransitGatewayRouteTablesRequest {
    
    TransitGatewayRouteTableIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayRouteTablesRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayRouteTablesRequest) => any;
}
export interface DescribeTransitGatewayRouteTablesResult {
    
    TransitGatewayRouteTables?: TransitGatewayRouteTable[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayRouteTablesResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayRouteTablesResult) => any;
}
export interface DescribeTransitGatewaysRequest {
    
    TransitGatewayIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewaysRequest) => any;
}
export interface DescribeTransitGatewaysResult {
    
    TransitGateways?: TransitGateway[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewaysResult) => any;
}
export interface DescribeTransitGatewayVpcAttachmentsRequest {
    
    TransitGatewayAttachmentIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeTransitGatewayVpcAttachmentsRequest {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayVpcAttachmentsRequest) => any;
}
export interface DescribeTransitGatewayVpcAttachmentsResult {
    
    TransitGatewayVpcAttachments?: TransitGatewayVpcAttachment[];
    
    NextToken?: string;
}
export declare namespace DescribeTransitGatewayVpcAttachmentsResult {
    
    const filterSensitiveLog: (obj: DescribeTransitGatewayVpcAttachmentsResult) => any;
}
export interface DescribeTrunkInterfaceAssociationsRequest {
    
    AssociationIds?: string[];
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeTrunkInterfaceAssociationsRequest {
    
    const filterSensitiveLog: (obj: DescribeTrunkInterfaceAssociationsRequest) => any;
}
export interface DescribeTrunkInterfaceAssociationsResult {
    
    InterfaceAssociations?: TrunkInterfaceAssociation[];
    
    NextToken?: string;
}
export declare namespace DescribeTrunkInterfaceAssociationsResult {
    
    const filterSensitiveLog: (obj: DescribeTrunkInterfaceAssociationsResult) => any;
}
export declare type VolumeAttributeName = "autoEnableIO" | "productCodes";
export interface DescribeVolumeAttributeRequest {
    
    Attribute: VolumeAttributeName | string | undefined;
    
    VolumeId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DescribeVolumeAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeVolumeAttributeRequest) => any;
}
export interface DescribeVolumeAttributeResult {
    
    AutoEnableIO?: AttributeBooleanValue;
    
    ProductCodes?: ProductCode[];
    
    VolumeId?: string;
}
export declare namespace DescribeVolumeAttributeResult {
    
    const filterSensitiveLog: (obj: DescribeVolumeAttributeResult) => any;
}
export interface DescribeVolumesRequest {
    
    Filters?: Filter[];
    
    VolumeIds?: string[];
    
    DryRun?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVolumesRequest {
    
    const filterSensitiveLog: (obj: DescribeVolumesRequest) => any;
}
export interface DescribeVolumesResult {
    
    Volumes?: Volume[];
    
    NextToken?: string;
}
export declare namespace DescribeVolumesResult {
    
    const filterSensitiveLog: (obj: DescribeVolumesResult) => any;
}
export interface DescribeVolumesModificationsRequest {
    
    DryRun?: boolean;
    
    VolumeIds?: string[];
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeVolumesModificationsRequest {
    
    const filterSensitiveLog: (obj: DescribeVolumesModificationsRequest) => any;
}
export declare type VolumeModificationState = "completed" | "failed" | "modifying" | "optimizing";

export interface VolumeModification {
    
    VolumeId?: string;
    
    ModificationState?: VolumeModificationState | string;
    
    StatusMessage?: string;
    
    TargetSize?: number;
    
    TargetIops?: number;
    
    TargetVolumeType?: VolumeType | string;
    
    TargetThroughput?: number;
    
    TargetMultiAttachEnabled?: boolean;
    
    OriginalSize?: number;
    
    OriginalIops?: number;
    
    OriginalVolumeType?: VolumeType | string;
    
    OriginalThroughput?: number;
    
    OriginalMultiAttachEnabled?: boolean;
    
    Progress?: number;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export declare namespace VolumeModification {
    
    const filterSensitiveLog: (obj: VolumeModification) => any;
}
export interface DescribeVolumesModificationsResult {
    
    VolumesModifications?: VolumeModification[];
    
    NextToken?: string;
}
export declare namespace DescribeVolumesModificationsResult {
    
    const filterSensitiveLog: (obj: DescribeVolumesModificationsResult) => any;
}
export interface DescribeVolumeStatusRequest {
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    VolumeIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeVolumeStatusRequest {
    
    const filterSensitiveLog: (obj: DescribeVolumeStatusRequest) => any;
}

export interface VolumeStatusAction {
    
    Code?: string;
    
    Description?: string;
    
    EventId?: string;
    
    EventType?: string;
}
export declare namespace VolumeStatusAction {
    
    const filterSensitiveLog: (obj: VolumeStatusAction) => any;
}

export interface VolumeStatusAttachmentStatus {
    
    IoPerformance?: string;
    
    InstanceId?: string;
}
export declare namespace VolumeStatusAttachmentStatus {
    
    const filterSensitiveLog: (obj: VolumeStatusAttachmentStatus) => any;
}

export interface VolumeStatusEvent {
    
    Description?: string;
    
    EventId?: string;
    
    EventType?: string;
    
    NotAfter?: Date;
    
    NotBefore?: Date;
    
    InstanceId?: string;
}
export declare namespace VolumeStatusEvent {
    
    const filterSensitiveLog: (obj: VolumeStatusEvent) => any;
}
export declare type VolumeStatusName = "io-enabled" | "io-performance";

export interface VolumeStatusDetails {
    
    Name?: VolumeStatusName | string;
    
    Status?: string;
}
export declare namespace VolumeStatusDetails {
    
    const filterSensitiveLog: (obj: VolumeStatusDetails) => any;
}
export declare type VolumeStatusInfoStatus = "impaired" | "insufficient-data" | "ok";

export interface VolumeStatusInfo {
    
    Details?: VolumeStatusDetails[];
    
    Status?: VolumeStatusInfoStatus | string;
}
export declare namespace VolumeStatusInfo {
    
    const filterSensitiveLog: (obj: VolumeStatusInfo) => any;
}

export interface VolumeStatusItem {
    
    Actions?: VolumeStatusAction[];
    
    AvailabilityZone?: string;
    
    OutpostArn?: string;
    
    Events?: VolumeStatusEvent[];
    
    VolumeId?: string;
    
    VolumeStatus?: VolumeStatusInfo;
    
    AttachmentStatuses?: VolumeStatusAttachmentStatus[];
}
export declare namespace VolumeStatusItem {
    
    const filterSensitiveLog: (obj: VolumeStatusItem) => any;
}
export interface DescribeVolumeStatusResult {
    
    NextToken?: string;
    
    VolumeStatuses?: VolumeStatusItem[];
}
export declare namespace DescribeVolumeStatusResult {
    
    const filterSensitiveLog: (obj: DescribeVolumeStatusResult) => any;
}
export declare type VpcAttributeName = "enableDnsHostnames" | "enableDnsSupport";
export interface DescribeVpcAttributeRequest {
    
    Attribute: VpcAttributeName | string | undefined;
    
    VpcId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DescribeVpcAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcAttributeRequest) => any;
}
export interface DescribeVpcAttributeResult {
    
    VpcId?: string;
    
    EnableDnsHostnames?: AttributeBooleanValue;
    
    EnableDnsSupport?: AttributeBooleanValue;
}
export declare namespace DescribeVpcAttributeResult {
    
    const filterSensitiveLog: (obj: DescribeVpcAttributeResult) => any;
}
export interface DescribeVpcClassicLinkRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    VpcIds?: string[];
}
export declare namespace DescribeVpcClassicLinkRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkRequest) => any;
}

export interface VpcClassicLink {
    
    ClassicLinkEnabled?: boolean;
    
    Tags?: Tag[];
    
    VpcId?: string;
}
export declare namespace VpcClassicLink {
    
    const filterSensitiveLog: (obj: VpcClassicLink) => any;
}
export interface DescribeVpcClassicLinkResult {
    
    Vpcs?: VpcClassicLink[];
}
export declare namespace DescribeVpcClassicLinkResult {
    
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkResult) => any;
}
export interface DescribeVpcClassicLinkDnsSupportRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
    
    VpcIds?: string[];
}
export declare namespace DescribeVpcClassicLinkDnsSupportRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkDnsSupportRequest) => any;
}

export interface ClassicLinkDnsSupport {
    
    ClassicLinkDnsSupported?: boolean;
    
    VpcId?: string;
}
export declare namespace ClassicLinkDnsSupport {
    
    const filterSensitiveLog: (obj: ClassicLinkDnsSupport) => any;
}
export interface DescribeVpcClassicLinkDnsSupportResult {
    
    NextToken?: string;
    
    Vpcs?: ClassicLinkDnsSupport[];
}
export declare namespace DescribeVpcClassicLinkDnsSupportResult {
    
    const filterSensitiveLog: (obj: DescribeVpcClassicLinkDnsSupportResult) => any;
}
export interface DescribeVpcEndpointConnectionNotificationsRequest {
    
    DryRun?: boolean;
    
    ConnectionNotificationId?: string;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionNotificationsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionNotificationsRequest) => any;
}
export interface DescribeVpcEndpointConnectionNotificationsResult {
    
    ConnectionNotificationSet?: ConnectionNotification[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionNotificationsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionNotificationsResult) => any;
}
export interface DescribeVpcEndpointConnectionsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionsRequest) => any;
}

export interface VpcEndpointConnection {
    
    ServiceId?: string;
    
    VpcEndpointId?: string;
    
    VpcEndpointOwner?: string;
    
    VpcEndpointState?: State | string;
    
    CreationTimestamp?: Date;
    
    DnsEntries?: DnsEntry[];
    
    NetworkLoadBalancerArns?: string[];
    
    GatewayLoadBalancerArns?: string[];
}
export declare namespace VpcEndpointConnection {
    
    const filterSensitiveLog: (obj: VpcEndpointConnection) => any;
}
export interface DescribeVpcEndpointConnectionsResult {
    
    VpcEndpointConnections?: VpcEndpointConnection[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointConnectionsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointConnectionsResult) => any;
}

export interface DescribeVpcEndpointsRequest {
    
    DryRun?: boolean;
    
    VpcEndpointIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointsRequest) => any;
}

export interface DescribeVpcEndpointsResult {
    
    VpcEndpoints?: VpcEndpoint[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointsResult) => any;
}
export interface DescribeVpcEndpointServiceConfigurationsRequest {
    
    DryRun?: boolean;
    
    ServiceIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServiceConfigurationsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointServiceConfigurationsRequest) => any;
}
export interface DescribeVpcEndpointServiceConfigurationsResult {
    
    ServiceConfigurations?: ServiceConfiguration[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServiceConfigurationsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointServiceConfigurationsResult) => any;
}
export interface DescribeVpcEndpointServicePermissionsRequest {
    
    DryRun?: boolean;
    
    ServiceId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicePermissionsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicePermissionsRequest) => any;
}
export interface DescribeVpcEndpointServicePermissionsResult {
    
    AllowedPrincipals?: AllowedPrincipal[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicePermissionsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicePermissionsResult) => any;
}

export interface DescribeVpcEndpointServicesRequest {
    
    DryRun?: boolean;
    
    ServiceNames?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicesRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicesRequest) => any;
}

export interface PrivateDnsDetails {
    
    PrivateDnsName?: string;
}
export declare namespace PrivateDnsDetails {
    
    const filterSensitiveLog: (obj: PrivateDnsDetails) => any;
}

export interface ServiceDetail {
    
    ServiceName?: string;
    
    ServiceId?: string;
    
    ServiceType?: ServiceTypeDetail[];
    
    AvailabilityZones?: string[];
    
    Owner?: string;
    
    BaseEndpointDnsNames?: string[];
    
    PrivateDnsName?: string;
    
    PrivateDnsNames?: PrivateDnsDetails[];
    
    VpcEndpointPolicySupported?: boolean;
    
    AcceptanceRequired?: boolean;
    
    ManagesVpcEndpoints?: boolean;
    
    Tags?: Tag[];
    
    PrivateDnsNameVerificationState?: DnsNameState | string;
}
export declare namespace ServiceDetail {
    
    const filterSensitiveLog: (obj: ServiceDetail) => any;
}

export interface DescribeVpcEndpointServicesResult {
    
    ServiceNames?: string[];
    
    ServiceDetails?: ServiceDetail[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcEndpointServicesResult {
    
    const filterSensitiveLog: (obj: DescribeVpcEndpointServicesResult) => any;
}
export interface DescribeVpcPeeringConnectionsRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    VpcPeeringConnectionIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeVpcPeeringConnectionsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcPeeringConnectionsRequest) => any;
}
export interface DescribeVpcPeeringConnectionsResult {
    
    VpcPeeringConnections?: VpcPeeringConnection[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcPeeringConnectionsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcPeeringConnectionsResult) => any;
}
export interface DescribeVpcsRequest {
    
    Filters?: Filter[];
    
    VpcIds?: string[];
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeVpcsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpcsRequest) => any;
}
export interface DescribeVpcsResult {
    
    Vpcs?: Vpc[];
    
    NextToken?: string;
}
export declare namespace DescribeVpcsResult {
    
    const filterSensitiveLog: (obj: DescribeVpcsResult) => any;
}

export interface DescribeVpnConnectionsRequest {
    
    Filters?: Filter[];
    
    VpnConnectionIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeVpnConnectionsRequest {
    
    const filterSensitiveLog: (obj: DescribeVpnConnectionsRequest) => any;
}

export interface DescribeVpnConnectionsResult {
    
    VpnConnections?: VpnConnection[];
}
export declare namespace DescribeVpnConnectionsResult {
    
    const filterSensitiveLog: (obj: DescribeVpnConnectionsResult) => any;
}

export interface DescribeVpnGatewaysRequest {
    
    Filters?: Filter[];
    
    VpnGatewayIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeVpnGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeVpnGatewaysRequest) => any;
}

export interface DescribeVpnGatewaysResult {
    
    VpnGateways?: VpnGateway[];
}
export declare namespace DescribeVpnGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeVpnGatewaysResult) => any;
}
export interface DetachClassicLinkVpcRequest {
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
    
    VpcId: string | undefined;
}
export declare namespace DetachClassicLinkVpcRequest {
    
    const filterSensitiveLog: (obj: DetachClassicLinkVpcRequest) => any;
}
export interface DetachClassicLinkVpcResult {
    
    Return?: boolean;
}
export declare namespace DetachClassicLinkVpcResult {
    
    const filterSensitiveLog: (obj: DetachClassicLinkVpcResult) => any;
}
export interface DetachInternetGatewayRequest {
    
    DryRun?: boolean;
    
    InternetGatewayId: string | undefined;
    
    VpcId: string | undefined;
}
export declare namespace DetachInternetGatewayRequest {
    
    const filterSensitiveLog: (obj: DetachInternetGatewayRequest) => any;
}

export interface DetachNetworkInterfaceRequest {
    
    AttachmentId: string | undefined;
    
    DryRun?: boolean;
    
    Force?: boolean;
}
export declare namespace DetachNetworkInterfaceRequest {
    
    const filterSensitiveLog: (obj: DetachNetworkInterfaceRequest) => any;
}
export interface DetachVolumeRequest {
    
    Device?: string;
    
    Force?: boolean;
    
    InstanceId?: string;
    
    VolumeId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DetachVolumeRequest {
    
    const filterSensitiveLog: (obj: DetachVolumeRequest) => any;
}

export interface DetachVpnGatewayRequest {
    
    VpcId: string | undefined;
    
    VpnGatewayId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DetachVpnGatewayRequest {
    
    const filterSensitiveLog: (obj: DetachVpnGatewayRequest) => any;
}
export interface DisableEbsEncryptionByDefaultRequest {
    
    DryRun?: boolean;
}
export declare namespace DisableEbsEncryptionByDefaultRequest {
    
    const filterSensitiveLog: (obj: DisableEbsEncryptionByDefaultRequest) => any;
}
export interface DisableEbsEncryptionByDefaultResult {
    
    EbsEncryptionByDefault?: boolean;
}
export declare namespace DisableEbsEncryptionByDefaultResult {
    
    const filterSensitiveLog: (obj: DisableEbsEncryptionByDefaultResult) => any;
}
export interface DisableFastSnapshotRestoresRequest {
    
    AvailabilityZones: string[] | undefined;
    
    SourceSnapshotIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisableFastSnapshotRestoresRequest {
    
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoresRequest) => any;
}

export interface DisableFastSnapshotRestoreSuccessItem {
    
    SnapshotId?: string;
    
    AvailabilityZone?: string;
    
    State?: FastSnapshotRestoreStateCode | string;
    
    StateTransitionReason?: string;
    
    OwnerId?: string;
    
    OwnerAlias?: string;
    
    EnablingTime?: Date;
    
    OptimizingTime?: Date;
    
    EnabledTime?: Date;
    
    DisablingTime?: Date;
    
    DisabledTime?: Date;
}
export declare namespace DisableFastSnapshotRestoreSuccessItem {
    
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreSuccessItem) => any;
}

export interface DisableFastSnapshotRestoreStateError {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace DisableFastSnapshotRestoreStateError {
    
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreStateError) => any;
}

export interface DisableFastSnapshotRestoreStateErrorItem {
    
    AvailabilityZone?: string;
    
    Error?: DisableFastSnapshotRestoreStateError;
}
export declare namespace DisableFastSnapshotRestoreStateErrorItem {
    
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreStateErrorItem) => any;
}

export interface DisableFastSnapshotRestoreErrorItem {
    
    SnapshotId?: string;
    
    FastSnapshotRestoreStateErrors?: DisableFastSnapshotRestoreStateErrorItem[];
}
export declare namespace DisableFastSnapshotRestoreErrorItem {
    
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoreErrorItem) => any;
}
export interface DisableFastSnapshotRestoresResult {
    
    Successful?: DisableFastSnapshotRestoreSuccessItem[];
    
    Unsuccessful?: DisableFastSnapshotRestoreErrorItem[];
}
export declare namespace DisableFastSnapshotRestoresResult {
    
    const filterSensitiveLog: (obj: DisableFastSnapshotRestoresResult) => any;
}
export interface DisableImageDeprecationRequest {
    
    ImageId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisableImageDeprecationRequest {
    
    const filterSensitiveLog: (obj: DisableImageDeprecationRequest) => any;
}
export interface DisableImageDeprecationResult {
    
    Return?: boolean;
}
export declare namespace DisableImageDeprecationResult {
    
    const filterSensitiveLog: (obj: DisableImageDeprecationResult) => any;
}
export interface DisableIpamOrganizationAdminAccountRequest {
    
    DryRun?: boolean;
    
    DelegatedAdminAccountId: string | undefined;
}
export declare namespace DisableIpamOrganizationAdminAccountRequest {
    
    const filterSensitiveLog: (obj: DisableIpamOrganizationAdminAccountRequest) => any;
}
export interface DisableIpamOrganizationAdminAccountResult {
    
    Success?: boolean;
}
export declare namespace DisableIpamOrganizationAdminAccountResult {
    
    const filterSensitiveLog: (obj: DisableIpamOrganizationAdminAccountResult) => any;
}
export interface DisableSerialConsoleAccessRequest {
    
    DryRun?: boolean;
}
export declare namespace DisableSerialConsoleAccessRequest {
    
    const filterSensitiveLog: (obj: DisableSerialConsoleAccessRequest) => any;
}
export interface DisableSerialConsoleAccessResult {
    
    SerialConsoleAccessEnabled?: boolean;
}
export declare namespace DisableSerialConsoleAccessResult {
    
    const filterSensitiveLog: (obj: DisableSerialConsoleAccessResult) => any;
}
export interface DisableTransitGatewayRouteTablePropagationRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisableTransitGatewayRouteTablePropagationRequest {
    
    const filterSensitiveLog: (obj: DisableTransitGatewayRouteTablePropagationRequest) => any;
}
export declare type TransitGatewayPropagationState = "disabled" | "disabling" | "enabled" | "enabling";

export interface TransitGatewayPropagation {
    
    TransitGatewayAttachmentId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    TransitGatewayRouteTableId?: string;
    
    State?: TransitGatewayPropagationState | string;
}
export declare namespace TransitGatewayPropagation {
    
    const filterSensitiveLog: (obj: TransitGatewayPropagation) => any;
}
export interface DisableTransitGatewayRouteTablePropagationResult {
    
    Propagation?: TransitGatewayPropagation;
}
export declare namespace DisableTransitGatewayRouteTablePropagationResult {
    
    const filterSensitiveLog: (obj: DisableTransitGatewayRouteTablePropagationResult) => any;
}

export interface DisableVgwRoutePropagationRequest {
    
    GatewayId: string | undefined;
    
    RouteTableId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisableVgwRoutePropagationRequest {
    
    const filterSensitiveLog: (obj: DisableVgwRoutePropagationRequest) => any;
}
export interface DisableVpcClassicLinkRequest {
    
    DryRun?: boolean;
    
    VpcId: string | undefined;
}
export declare namespace DisableVpcClassicLinkRequest {
    
    const filterSensitiveLog: (obj: DisableVpcClassicLinkRequest) => any;
}
export interface DisableVpcClassicLinkResult {
    
    Return?: boolean;
}
export declare namespace DisableVpcClassicLinkResult {
    
    const filterSensitiveLog: (obj: DisableVpcClassicLinkResult) => any;
}
export interface DisableVpcClassicLinkDnsSupportRequest {
    
    VpcId?: string;
}
export declare namespace DisableVpcClassicLinkDnsSupportRequest {
    
    const filterSensitiveLog: (obj: DisableVpcClassicLinkDnsSupportRequest) => any;
}
export interface DisableVpcClassicLinkDnsSupportResult {
    
    Return?: boolean;
}
export declare namespace DisableVpcClassicLinkDnsSupportResult {
    
    const filterSensitiveLog: (obj: DisableVpcClassicLinkDnsSupportResult) => any;
}
export interface DisassociateAddressRequest {
    
    AssociationId?: string;
    
    PublicIp?: string;
    
    DryRun?: boolean;
}
export declare namespace DisassociateAddressRequest {
    
    const filterSensitiveLog: (obj: DisassociateAddressRequest) => any;
}
export interface DisassociateClientVpnTargetNetworkRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    AssociationId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisassociateClientVpnTargetNetworkRequest {
    
    const filterSensitiveLog: (obj: DisassociateClientVpnTargetNetworkRequest) => any;
}
export interface DisassociateClientVpnTargetNetworkResult {
    
    AssociationId?: string;
    
    Status?: AssociationStatus;
}
export declare namespace DisassociateClientVpnTargetNetworkResult {
    
    const filterSensitiveLog: (obj: DisassociateClientVpnTargetNetworkResult) => any;
}
export interface DisassociateEnclaveCertificateIamRoleRequest {
    
    CertificateArn?: string;
    
    RoleArn?: string;
    
    DryRun?: boolean;
}
export declare namespace DisassociateEnclaveCertificateIamRoleRequest {
    
    const filterSensitiveLog: (obj: DisassociateEnclaveCertificateIamRoleRequest) => any;
}
export interface DisassociateEnclaveCertificateIamRoleResult {
    
    Return?: boolean;
}
export declare namespace DisassociateEnclaveCertificateIamRoleResult {
    
    const filterSensitiveLog: (obj: DisassociateEnclaveCertificateIamRoleResult) => any;
}
export interface DisassociateIamInstanceProfileRequest {
    
    AssociationId: string | undefined;
}
export declare namespace DisassociateIamInstanceProfileRequest {
    
    const filterSensitiveLog: (obj: DisassociateIamInstanceProfileRequest) => any;
}
export interface DisassociateIamInstanceProfileResult {
    
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export declare namespace DisassociateIamInstanceProfileResult {
    
    const filterSensitiveLog: (obj: DisassociateIamInstanceProfileResult) => any;
}

export interface InstanceEventWindowDisassociationRequest {
    
    InstanceIds?: string[];
    
    InstanceTags?: Tag[];
    
    DedicatedHostIds?: string[];
}
export declare namespace InstanceEventWindowDisassociationRequest {
    
    const filterSensitiveLog: (obj: InstanceEventWindowDisassociationRequest) => any;
}
export interface DisassociateInstanceEventWindowRequest {
    
    DryRun?: boolean;
    
    InstanceEventWindowId: string | undefined;
    
    AssociationTarget: InstanceEventWindowDisassociationRequest | undefined;
}
export declare namespace DisassociateInstanceEventWindowRequest {
    
    const filterSensitiveLog: (obj: DisassociateInstanceEventWindowRequest) => any;
}
export interface DisassociateInstanceEventWindowResult {
    
    InstanceEventWindow?: InstanceEventWindow;
}
export declare namespace DisassociateInstanceEventWindowResult {
    
    const filterSensitiveLog: (obj: DisassociateInstanceEventWindowResult) => any;
}
export interface DisassociateRouteTableRequest {
    
    AssociationId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisassociateRouteTableRequest {
    
    const filterSensitiveLog: (obj: DisassociateRouteTableRequest) => any;
}
export interface DisassociateSubnetCidrBlockRequest {
    
    AssociationId: string | undefined;
}
export declare namespace DisassociateSubnetCidrBlockRequest {
    
    const filterSensitiveLog: (obj: DisassociateSubnetCidrBlockRequest) => any;
}
export interface DisassociateSubnetCidrBlockResult {
    
    Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
    
    SubnetId?: string;
}
export declare namespace DisassociateSubnetCidrBlockResult {
    
    const filterSensitiveLog: (obj: DisassociateSubnetCidrBlockResult) => any;
}
export interface DisassociateTransitGatewayMulticastDomainRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    SubnetIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DisassociateTransitGatewayMulticastDomainRequest {
    
    const filterSensitiveLog: (obj: DisassociateTransitGatewayMulticastDomainRequest) => any;
}
export interface DisassociateTransitGatewayMulticastDomainResult {
    
    Associations?: TransitGatewayMulticastDomainAssociations;
}
export declare namespace DisassociateTransitGatewayMulticastDomainResult {
    
    const filterSensitiveLog: (obj: DisassociateTransitGatewayMulticastDomainResult) => any;
}
export interface DisassociateTransitGatewayRouteTableRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DisassociateTransitGatewayRouteTableRequest {
    
    const filterSensitiveLog: (obj: DisassociateTransitGatewayRouteTableRequest) => any;
}
export interface DisassociateTransitGatewayRouteTableResult {
    
    Association?: TransitGatewayAssociation;
}
export declare namespace DisassociateTransitGatewayRouteTableResult {
    
    const filterSensitiveLog: (obj: DisassociateTransitGatewayRouteTableResult) => any;
}
export interface DisassociateTrunkInterfaceRequest {
    
    AssociationId: string | undefined;
    
    ClientToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DisassociateTrunkInterfaceRequest {
    
    const filterSensitiveLog: (obj: DisassociateTrunkInterfaceRequest) => any;
}
export interface DisassociateTrunkInterfaceResult {
    
    Return?: boolean;
    
    ClientToken?: string;
}
export declare namespace DisassociateTrunkInterfaceResult {
    
    const filterSensitiveLog: (obj: DisassociateTrunkInterfaceResult) => any;
}
export interface DisassociateVpcCidrBlockRequest {
    
    AssociationId: string | undefined;
}
export declare namespace DisassociateVpcCidrBlockRequest {
    
    const filterSensitiveLog: (obj: DisassociateVpcCidrBlockRequest) => any;
}
export interface DisassociateVpcCidrBlockResult {
    
    Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
    
    CidrBlockAssociation?: VpcCidrBlockAssociation;
    
    VpcId?: string;
}
export declare namespace DisassociateVpcCidrBlockResult {
    
    const filterSensitiveLog: (obj: DisassociateVpcCidrBlockResult) => any;
}
export interface EnableEbsEncryptionByDefaultRequest {
    
    DryRun?: boolean;
}
export declare namespace EnableEbsEncryptionByDefaultRequest {
    
    const filterSensitiveLog: (obj: EnableEbsEncryptionByDefaultRequest) => any;
}
export interface EnableEbsEncryptionByDefaultResult {
    
    EbsEncryptionByDefault?: boolean;
}
export declare namespace EnableEbsEncryptionByDefaultResult {
    
    const filterSensitiveLog: (obj: EnableEbsEncryptionByDefaultResult) => any;
}
export interface EnableFastSnapshotRestoresRequest {
    
    AvailabilityZones: string[] | undefined;
    
    SourceSnapshotIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace EnableFastSnapshotRestoresRequest {
    
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoresRequest) => any;
}

export interface EnableFastSnapshotRestoreSuccessItem {
    
    SnapshotId?: string;
    
    AvailabilityZone?: string;
    
    State?: FastSnapshotRestoreStateCode | string;
    
    StateTransitionReason?: string;
    
    OwnerId?: string;
    
    OwnerAlias?: string;
    
    EnablingTime?: Date;
    
    OptimizingTime?: Date;
    
    EnabledTime?: Date;
    
    DisablingTime?: Date;
    
    DisabledTime?: Date;
}
export declare namespace EnableFastSnapshotRestoreSuccessItem {
    
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreSuccessItem) => any;
}

export interface EnableFastSnapshotRestoreStateError {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace EnableFastSnapshotRestoreStateError {
    
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreStateError) => any;
}

export interface EnableFastSnapshotRestoreStateErrorItem {
    
    AvailabilityZone?: string;
    
    Error?: EnableFastSnapshotRestoreStateError;
}
export declare namespace EnableFastSnapshotRestoreStateErrorItem {
    
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreStateErrorItem) => any;
}

export interface EnableFastSnapshotRestoreErrorItem {
    
    SnapshotId?: string;
    
    FastSnapshotRestoreStateErrors?: EnableFastSnapshotRestoreStateErrorItem[];
}
export declare namespace EnableFastSnapshotRestoreErrorItem {
    
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoreErrorItem) => any;
}
export interface EnableFastSnapshotRestoresResult {
    
    Successful?: EnableFastSnapshotRestoreSuccessItem[];
    
    Unsuccessful?: EnableFastSnapshotRestoreErrorItem[];
}
export declare namespace EnableFastSnapshotRestoresResult {
    
    const filterSensitiveLog: (obj: EnableFastSnapshotRestoresResult) => any;
}
export interface EnableImageDeprecationRequest {
    
    ImageId: string | undefined;
    
    DeprecateAt: Date | undefined;
    
    DryRun?: boolean;
}
export declare namespace EnableImageDeprecationRequest {
    
    const filterSensitiveLog: (obj: EnableImageDeprecationRequest) => any;
}
export interface EnableImageDeprecationResult {
    
    Return?: boolean;
}
export declare namespace EnableImageDeprecationResult {
    
    const filterSensitiveLog: (obj: EnableImageDeprecationResult) => any;
}
export interface EnableIpamOrganizationAdminAccountRequest {
    
    DryRun?: boolean;
    
    DelegatedAdminAccountId: string | undefined;
}
export declare namespace EnableIpamOrganizationAdminAccountRequest {
    
    const filterSensitiveLog: (obj: EnableIpamOrganizationAdminAccountRequest) => any;
}
export interface EnableIpamOrganizationAdminAccountResult {
    
    Success?: boolean;
}
export declare namespace EnableIpamOrganizationAdminAccountResult {
    
    const filterSensitiveLog: (obj: EnableIpamOrganizationAdminAccountResult) => any;
}
export interface EnableSerialConsoleAccessRequest {
    
    DryRun?: boolean;
}
export declare namespace EnableSerialConsoleAccessRequest {
    
    const filterSensitiveLog: (obj: EnableSerialConsoleAccessRequest) => any;
}
export interface EnableSerialConsoleAccessResult {
    
    SerialConsoleAccessEnabled?: boolean;
}
export declare namespace EnableSerialConsoleAccessResult {
    
    const filterSensitiveLog: (obj: EnableSerialConsoleAccessResult) => any;
}
export interface EnableTransitGatewayRouteTablePropagationRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace EnableTransitGatewayRouteTablePropagationRequest {
    
    const filterSensitiveLog: (obj: EnableTransitGatewayRouteTablePropagationRequest) => any;
}
export interface EnableTransitGatewayRouteTablePropagationResult {
    
    Propagation?: TransitGatewayPropagation;
}
export declare namespace EnableTransitGatewayRouteTablePropagationResult {
    
    const filterSensitiveLog: (obj: EnableTransitGatewayRouteTablePropagationResult) => any;
}

export interface EnableVgwRoutePropagationRequest {
    
    GatewayId: string | undefined;
    
    RouteTableId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace EnableVgwRoutePropagationRequest {
    
    const filterSensitiveLog: (obj: EnableVgwRoutePropagationRequest) => any;
}
export interface EnableVolumeIORequest {
    
    DryRun?: boolean;
    
    VolumeId: string | undefined;
}
export declare namespace EnableVolumeIORequest {
    
    const filterSensitiveLog: (obj: EnableVolumeIORequest) => any;
}
export interface EnableVpcClassicLinkRequest {
    
    DryRun?: boolean;
    
    VpcId: string | undefined;
}
export declare namespace EnableVpcClassicLinkRequest {
    
    const filterSensitiveLog: (obj: EnableVpcClassicLinkRequest) => any;
}
export interface EnableVpcClassicLinkResult {
    
    Return?: boolean;
}
export declare namespace EnableVpcClassicLinkResult {
    
    const filterSensitiveLog: (obj: EnableVpcClassicLinkResult) => any;
}
export interface EnableVpcClassicLinkDnsSupportRequest {
    
    VpcId?: string;
}
export declare namespace EnableVpcClassicLinkDnsSupportRequest {
    
    const filterSensitiveLog: (obj: EnableVpcClassicLinkDnsSupportRequest) => any;
}
export interface EnableVpcClassicLinkDnsSupportResult {
    
    Return?: boolean;
}
export declare namespace EnableVpcClassicLinkDnsSupportResult {
    
    const filterSensitiveLog: (obj: EnableVpcClassicLinkDnsSupportResult) => any;
}
export interface ExportClientVpnClientCertificateRevocationListRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ExportClientVpnClientCertificateRevocationListRequest {
    
    const filterSensitiveLog: (obj: ExportClientVpnClientCertificateRevocationListRequest) => any;
}
export declare type ClientCertificateRevocationListStatusCode = "active" | "pending";

export interface ClientCertificateRevocationListStatus {
    
    Code?: ClientCertificateRevocationListStatusCode | string;
    
    Message?: string;
}
export declare namespace ClientCertificateRevocationListStatus {
    
    const filterSensitiveLog: (obj: ClientCertificateRevocationListStatus) => any;
}
export interface ExportClientVpnClientCertificateRevocationListResult {
    
    CertificateRevocationList?: string;
    
    Status?: ClientCertificateRevocationListStatus;
}
export declare namespace ExportClientVpnClientCertificateRevocationListResult {
    
    const filterSensitiveLog: (obj: ExportClientVpnClientCertificateRevocationListResult) => any;
}
export interface ExportClientVpnClientConfigurationRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ExportClientVpnClientConfigurationRequest {
    
    const filterSensitiveLog: (obj: ExportClientVpnClientConfigurationRequest) => any;
}
export interface ExportClientVpnClientConfigurationResult {
    
    ClientConfiguration?: string;
}
export declare namespace ExportClientVpnClientConfigurationResult {
    
    const filterSensitiveLog: (obj: ExportClientVpnClientConfigurationResult) => any;
}

export interface ExportTaskS3LocationRequest {
    
    S3Bucket: string | undefined;
    
    S3Prefix?: string;
}
export declare namespace ExportTaskS3LocationRequest {
    
    const filterSensitiveLog: (obj: ExportTaskS3LocationRequest) => any;
}
export interface ExportImageRequest {
    
    ClientToken?: string;
    
    Description?: string;
    
    DiskImageFormat: DiskImageFormat | string | undefined;
    
    DryRun?: boolean;
    
    ImageId: string | undefined;
    
    S3ExportLocation: ExportTaskS3LocationRequest | undefined;
    
    RoleName?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace ExportImageRequest {
    
    const filterSensitiveLog: (obj: ExportImageRequest) => any;
}
export interface ExportImageResult {
    
    Description?: string;
    
    DiskImageFormat?: DiskImageFormat | string;
    
    ExportImageTaskId?: string;
    
    ImageId?: string;
    
    RoleName?: string;
    
    Progress?: string;
    
    S3ExportLocation?: ExportTaskS3Location;
    
    Status?: string;
    
    StatusMessage?: string;
    
    Tags?: Tag[];
}
export declare namespace ExportImageResult {
    
    const filterSensitiveLog: (obj: ExportImageResult) => any;
}
export interface ExportTransitGatewayRoutesRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    Filters?: Filter[];
    
    S3Bucket: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ExportTransitGatewayRoutesRequest {
    
    const filterSensitiveLog: (obj: ExportTransitGatewayRoutesRequest) => any;
}
export interface ExportTransitGatewayRoutesResult {
    
    S3Location?: string;
}
export declare namespace ExportTransitGatewayRoutesResult {
    
    const filterSensitiveLog: (obj: ExportTransitGatewayRoutesResult) => any;
}
export interface GetAssociatedEnclaveCertificateIamRolesRequest {
    
    CertificateArn?: string;
    
    DryRun?: boolean;
}
export declare namespace GetAssociatedEnclaveCertificateIamRolesRequest {
    
    const filterSensitiveLog: (obj: GetAssociatedEnclaveCertificateIamRolesRequest) => any;
}

export interface AssociatedRole {
    
    AssociatedRoleArn?: string;
    
    CertificateS3BucketName?: string;
    
    CertificateS3ObjectKey?: string;
    
    EncryptionKmsKeyId?: string;
}
export declare namespace AssociatedRole {
    
    const filterSensitiveLog: (obj: AssociatedRole) => any;
}
export interface GetAssociatedEnclaveCertificateIamRolesResult {
    
    AssociatedRoles?: AssociatedRole[];
}
export declare namespace GetAssociatedEnclaveCertificateIamRolesResult {
    
    const filterSensitiveLog: (obj: GetAssociatedEnclaveCertificateIamRolesResult) => any;
}
export interface GetAssociatedIpv6PoolCidrsRequest {
    
    PoolId: string | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    DryRun?: boolean;
}
export declare namespace GetAssociatedIpv6PoolCidrsRequest {
    
    const filterSensitiveLog: (obj: GetAssociatedIpv6PoolCidrsRequest) => any;
}

export interface Ipv6CidrAssociation {
    
    Ipv6Cidr?: string;
    
    AssociatedResource?: string;
}
export declare namespace Ipv6CidrAssociation {
    
    const filterSensitiveLog: (obj: Ipv6CidrAssociation) => any;
}
export interface GetAssociatedIpv6PoolCidrsResult {
    
    Ipv6CidrAssociations?: Ipv6CidrAssociation[];
    
    NextToken?: string;
}
export declare namespace GetAssociatedIpv6PoolCidrsResult {
    
    const filterSensitiveLog: (obj: GetAssociatedIpv6PoolCidrsResult) => any;
}
export interface GetCapacityReservationUsageRequest {
    
    CapacityReservationId: string | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    DryRun?: boolean;
}
export declare namespace GetCapacityReservationUsageRequest {
    
    const filterSensitiveLog: (obj: GetCapacityReservationUsageRequest) => any;
}

export interface InstanceUsage {
    
    AccountId?: string;
    
    UsedInstanceCount?: number;
}
export declare namespace InstanceUsage {
    
    const filterSensitiveLog: (obj: InstanceUsage) => any;
}
export interface GetCapacityReservationUsageResult {
    
    NextToken?: string;
    
    CapacityReservationId?: string;
    
    InstanceType?: string;
    
    TotalInstanceCount?: number;
    
    AvailableInstanceCount?: number;
    
    State?: CapacityReservationState | string;
    
    InstanceUsages?: InstanceUsage[];
}
export declare namespace GetCapacityReservationUsageResult {
    
    const filterSensitiveLog: (obj: GetCapacityReservationUsageResult) => any;
}
export interface GetCoipPoolUsageRequest {
    
    PoolId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace GetCoipPoolUsageRequest {
    
    const filterSensitiveLog: (obj: GetCoipPoolUsageRequest) => any;
}

export interface CoipAddressUsage {
    
    AllocationId?: string;
    
    AwsAccountId?: string;
    
    AwsService?: string;
    
    CoIp?: string;
}
export declare namespace CoipAddressUsage {
    
    const filterSensitiveLog: (obj: CoipAddressUsage) => any;
}
export interface GetCoipPoolUsageResult {
    
    CoipPoolId?: string;
    
    CoipAddressUsages?: CoipAddressUsage[];
    
    LocalGatewayRouteTableId?: string;
}
export declare namespace GetCoipPoolUsageResult {
    
    const filterSensitiveLog: (obj: GetCoipPoolUsageResult) => any;
}
export interface GetConsoleOutputRequest {
    
    InstanceId: string | undefined;
    
    DryRun?: boolean;
    
    Latest?: boolean;
}
export declare namespace GetConsoleOutputRequest {
    
    const filterSensitiveLog: (obj: GetConsoleOutputRequest) => any;
}
export interface GetConsoleOutputResult {
    
    InstanceId?: string;
    
    Output?: string;
    
    Timestamp?: Date;
}
export declare namespace GetConsoleOutputResult {
    
    const filterSensitiveLog: (obj: GetConsoleOutputResult) => any;
}
export interface GetConsoleScreenshotRequest {
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
    
    WakeUp?: boolean;
}
export declare namespace GetConsoleScreenshotRequest {
    
    const filterSensitiveLog: (obj: GetConsoleScreenshotRequest) => any;
}
export interface GetConsoleScreenshotResult {
    
    ImageData?: string;
    
    InstanceId?: string;
}
export declare namespace GetConsoleScreenshotResult {
    
    const filterSensitiveLog: (obj: GetConsoleScreenshotResult) => any;
}
export declare type UnlimitedSupportedInstanceFamily = "t2" | "t3" | "t3a" | "t4g";
export interface GetDefaultCreditSpecificationRequest {
    
    DryRun?: boolean;
    
    InstanceFamily: UnlimitedSupportedInstanceFamily | string | undefined;
}
export declare namespace GetDefaultCreditSpecificationRequest {
    
    const filterSensitiveLog: (obj: GetDefaultCreditSpecificationRequest) => any;
}

export interface InstanceFamilyCreditSpecification {
    
    InstanceFamily?: UnlimitedSupportedInstanceFamily | string;
    
    CpuCredits?: string;
}
export declare namespace InstanceFamilyCreditSpecification {
    
    const filterSensitiveLog: (obj: InstanceFamilyCreditSpecification) => any;
}
export interface GetDefaultCreditSpecificationResult {
    
    InstanceFamilyCreditSpecification?: InstanceFamilyCreditSpecification;
}
export declare namespace GetDefaultCreditSpecificationResult {
    
    const filterSensitiveLog: (obj: GetDefaultCreditSpecificationResult) => any;
}
export interface GetEbsDefaultKmsKeyIdRequest {
    
    DryRun?: boolean;
}
export declare namespace GetEbsDefaultKmsKeyIdRequest {
    
    const filterSensitiveLog: (obj: GetEbsDefaultKmsKeyIdRequest) => any;
}
export interface GetEbsDefaultKmsKeyIdResult {
    
    KmsKeyId?: string;
}
export declare namespace GetEbsDefaultKmsKeyIdResult {
    
    const filterSensitiveLog: (obj: GetEbsDefaultKmsKeyIdResult) => any;
}
export interface GetEbsEncryptionByDefaultRequest {
    
    DryRun?: boolean;
}
export declare namespace GetEbsEncryptionByDefaultRequest {
    
    const filterSensitiveLog: (obj: GetEbsEncryptionByDefaultRequest) => any;
}
export interface GetEbsEncryptionByDefaultResult {
    
    EbsEncryptionByDefault?: boolean;
}
export declare namespace GetEbsEncryptionByDefaultResult {
    
    const filterSensitiveLog: (obj: GetEbsEncryptionByDefaultResult) => any;
}
export declare enum PartitionLoadFrequency {
    DAILY = "daily",
    MONTHLY = "monthly",
    NONE = "none",
    WEEKLY = "weekly"
}

export interface AthenaIntegration {
    
    IntegrationResultS3DestinationArn: string | undefined;
    
    PartitionLoadFrequency: PartitionLoadFrequency | string | undefined;
    
    PartitionStartDate?: Date;
    
    PartitionEndDate?: Date;
}
export declare namespace AthenaIntegration {
    
    const filterSensitiveLog: (obj: AthenaIntegration) => any;
}

export interface IntegrateServices {
    
    AthenaIntegrations?: AthenaIntegration[];
}
export declare namespace IntegrateServices {
    
    const filterSensitiveLog: (obj: IntegrateServices) => any;
}
export interface GetFlowLogsIntegrationTemplateRequest {
    
    DryRun?: boolean;
    
    FlowLogId: string | undefined;
    
    ConfigDeliveryS3DestinationArn: string | undefined;
    
    IntegrateServices: IntegrateServices | undefined;
}
export declare namespace GetFlowLogsIntegrationTemplateRequest {
    
    const filterSensitiveLog: (obj: GetFlowLogsIntegrationTemplateRequest) => any;
}
export interface GetFlowLogsIntegrationTemplateResult {
    
    Result?: string;
}
export declare namespace GetFlowLogsIntegrationTemplateResult {
    
    const filterSensitiveLog: (obj: GetFlowLogsIntegrationTemplateResult) => any;
}
export interface GetGroupsForCapacityReservationRequest {
    
    CapacityReservationId: string | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    DryRun?: boolean;
}
export declare namespace GetGroupsForCapacityReservationRequest {
    
    const filterSensitiveLog: (obj: GetGroupsForCapacityReservationRequest) => any;
}

export interface CapacityReservationGroup {
    
    GroupArn?: string;
    
    OwnerId?: string;
}
export declare namespace CapacityReservationGroup {
    
    const filterSensitiveLog: (obj: CapacityReservationGroup) => any;
}
export interface GetGroupsForCapacityReservationResult {
    
    NextToken?: string;
    
    CapacityReservationGroups?: CapacityReservationGroup[];
}
export declare namespace GetGroupsForCapacityReservationResult {
    
    const filterSensitiveLog: (obj: GetGroupsForCapacityReservationResult) => any;
}
export interface GetHostReservationPurchasePreviewRequest {
    
    HostIdSet: string[] | undefined;
    
    OfferingId: string | undefined;
}
export declare namespace GetHostReservationPurchasePreviewRequest {
    
    const filterSensitiveLog: (obj: GetHostReservationPurchasePreviewRequest) => any;
}

export interface Purchase {
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Duration?: number;
    
    HostIdSet?: string[];
    
    HostReservationId?: string;
    
    HourlyPrice?: string;
    
    InstanceFamily?: string;
    
    PaymentOption?: PaymentOption | string;
    
    UpfrontPrice?: string;
}
export declare namespace Purchase {
    
    const filterSensitiveLog: (obj: Purchase) => any;
}
export interface GetHostReservationPurchasePreviewResult {
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Purchase?: Purchase[];
    
    TotalHourlyPrice?: string;
    
    TotalUpfrontPrice?: string;
}
export declare namespace GetHostReservationPurchasePreviewResult {
    
    const filterSensitiveLog: (obj: GetHostReservationPurchasePreviewResult) => any;
}
export interface GetInstanceTypesFromInstanceRequirementsRequest {
    
    DryRun?: boolean;
    
    ArchitectureTypes: (ArchitectureType | string)[] | undefined;
    
    VirtualizationTypes: (VirtualizationType | string)[] | undefined;
    
    InstanceRequirements: InstanceRequirementsRequest | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetInstanceTypesFromInstanceRequirementsRequest {
    
    const filterSensitiveLog: (obj: GetInstanceTypesFromInstanceRequirementsRequest) => any;
}

export interface InstanceTypeInfoFromInstanceRequirements {
    
    InstanceType?: string;
}
export declare namespace InstanceTypeInfoFromInstanceRequirements {
    
    const filterSensitiveLog: (obj: InstanceTypeInfoFromInstanceRequirements) => any;
}
export interface GetInstanceTypesFromInstanceRequirementsResult {
    
    InstanceTypes?: InstanceTypeInfoFromInstanceRequirements[];
    
    NextToken?: string;
}
export declare namespace GetInstanceTypesFromInstanceRequirementsResult {
    
    const filterSensitiveLog: (obj: GetInstanceTypesFromInstanceRequirementsResult) => any;
}
export interface GetIpamAddressHistoryRequest {
    
    DryRun?: boolean;
    
    Cidr: string | undefined;
    
    IpamScopeId: string | undefined;
    
    VpcId?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetIpamAddressHistoryRequest {
    
    const filterSensitiveLog: (obj: GetIpamAddressHistoryRequest) => any;
}
export declare enum IpamComplianceStatus {
    compliant = "compliant",
    ignored = "ignored",
    noncompliant = "noncompliant",
    unmanaged = "unmanaged"
}
export declare enum IpamOverlapStatus {
    ignored = "ignored",
    nonoverlapping = "nonoverlapping",
    overlapping = "overlapping"
}
export declare enum IpamAddressHistoryResourceType {
    eip = "eip",
    instance = "instance",
    network_interface = "network-interface",
    subnet = "subnet",
    vpc = "vpc"
}

export interface IpamAddressHistoryRecord {
    
    ResourceOwnerId?: string;
    
    ResourceRegion?: string;
    
    ResourceType?: IpamAddressHistoryResourceType | string;
    
    ResourceId?: string;
    
    ResourceCidr?: string;
    
    ResourceName?: string;
    
    ResourceComplianceStatus?: IpamComplianceStatus | string;
    
    ResourceOverlapStatus?: IpamOverlapStatus | string;
    
    VpcId?: string;
    
    SampledStartTime?: Date;
    
    SampledEndTime?: Date;
}
export declare namespace IpamAddressHistoryRecord {
    
    const filterSensitiveLog: (obj: IpamAddressHistoryRecord) => any;
}
export interface GetIpamAddressHistoryResult {
    
    HistoryRecords?: IpamAddressHistoryRecord[];
    
    NextToken?: string;
}
export declare namespace GetIpamAddressHistoryResult {
    
    const filterSensitiveLog: (obj: GetIpamAddressHistoryResult) => any;
}
export interface GetIpamPoolAllocationsRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    IpamPoolAllocationId?: string;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetIpamPoolAllocationsRequest {
    
    const filterSensitiveLog: (obj: GetIpamPoolAllocationsRequest) => any;
}
export interface GetIpamPoolAllocationsResult {
    
    IpamPoolAllocations?: IpamPoolAllocation[];
    
    NextToken?: string;
}
export declare namespace GetIpamPoolAllocationsResult {
    
    const filterSensitiveLog: (obj: GetIpamPoolAllocationsResult) => any;
}
export interface GetIpamPoolCidrsRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetIpamPoolCidrsRequest {
    
    const filterSensitiveLog: (obj: GetIpamPoolCidrsRequest) => any;
}
export interface GetIpamPoolCidrsResult {
    
    IpamPoolCidrs?: IpamPoolCidr[];
    
    NextToken?: string;
}
export declare namespace GetIpamPoolCidrsResult {
    
    const filterSensitiveLog: (obj: GetIpamPoolCidrsResult) => any;
}
export declare enum IpamResourceType {
    eip = "eip",
    ipv6_pool = "ipv6-pool",
    public_ipv4_pool = "public-ipv4-pool",
    subnet = "subnet",
    vpc = "vpc"
}
export interface GetIpamResourceCidrsRequest {
    
    DryRun?: boolean;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    IpamScopeId: string | undefined;
    
    IpamPoolId?: string;
    
    ResourceId?: string;
    
    ResourceType?: IpamResourceType | string;
    
    ResourceTag?: RequestIpamResourceTag;
    
    ResourceOwner?: string;
}
export declare namespace GetIpamResourceCidrsRequest {
    
    const filterSensitiveLog: (obj: GetIpamResourceCidrsRequest) => any;
}
export declare enum IpamManagementState {
    ignored = "ignored",
    managed = "managed",
    unmanaged = "unmanaged"
}

export interface IpamResourceCidr {
    
    IpamId?: string;
    
    IpamScopeId?: string;
    
    IpamPoolId?: string;
    
    ResourceRegion?: string;
    
    ResourceOwnerId?: string;
    
    ResourceId?: string;
    
    ResourceName?: string;
    
    ResourceCidr?: string;
    
    ResourceType?: IpamResourceType | string;
    
    ResourceTags?: IpamResourceTag[];
    
    IpUsage?: number;
    
    ComplianceStatus?: IpamComplianceStatus | string;
    
    ManagementState?: IpamManagementState | string;
    
    OverlapStatus?: IpamOverlapStatus | string;
    
    VpcId?: string;
}
export declare namespace IpamResourceCidr {
    
    const filterSensitiveLog: (obj: IpamResourceCidr) => any;
}
export interface GetIpamResourceCidrsResult {
    
    NextToken?: string;
    
    IpamResourceCidrs?: IpamResourceCidr[];
}
export declare namespace GetIpamResourceCidrsResult {
    
    const filterSensitiveLog: (obj: GetIpamResourceCidrsResult) => any;
}
export interface GetLaunchTemplateDataRequest {
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
}
export declare namespace GetLaunchTemplateDataRequest {
    
    const filterSensitiveLog: (obj: GetLaunchTemplateDataRequest) => any;
}
