import { AccountAttribute, AccountAttributeName, Address, AddressAttribute, AddressAttributeName, ApplianceModeSupportValue, AssociationStatus, BundleTask, ByoipCidr, CapacityReservation, CapacityReservationFleetState, CarrierGateway, ClientVpnAuthenticationType, ClientVpnAuthorizationRuleStatus, ClientVpnEndpointStatus, ClientVpnRouteStatus, DnsSupportValue, FleetCapacityReservation, FleetCapacityReservationTenancy, FleetInstanceMatchCriteria, GatewayType, InstanceEventWindowState, Ipv6SupportValue, Tag, TagSpecification, Tenancy, TransitGatewayAttachmentResourceType, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, TransportProtocol, UnsuccessfulItem, VolumeAttachment, Vpc, VpcAttachment, VpcPeeringConnection } from "./models_0";
import { DiskImageFormat, GroupIdentifier, Ipam, IpamPool, IpamScope, LaunchTemplate, LocalGatewayRoute, LocalGatewayRouteTableVpcAssociation, ManagedPrefixList, PlatformValues, ProtocolValue, SubnetCidrReservation, TransitGateway, TransitGatewayAttachmentBgpConfiguration, TransitGatewayConnect, VolumeType } from "./models_1";

export interface TransitGatewayConnectPeerConfiguration {
    
    TransitGatewayAddress?: string;
    
    PeerAddress?: string;
    
    InsideCidrBlocks?: string[];
    
    Protocol?: ProtocolValue | string;
    
    BgpConfigurations?: TransitGatewayAttachmentBgpConfiguration[];
}
export declare namespace TransitGatewayConnectPeerConfiguration {
    
    const filterSensitiveLog: (obj: TransitGatewayConnectPeerConfiguration) => any;
}
export declare type TransitGatewayConnectPeerState = "available" | "deleted" | "deleting" | "pending";

export interface TransitGatewayConnectPeer {
    
    TransitGatewayAttachmentId?: string;
    
    TransitGatewayConnectPeerId?: string;
    
    State?: TransitGatewayConnectPeerState | string;
    
    CreationTime?: Date;
    
    ConnectPeerConfiguration?: TransitGatewayConnectPeerConfiguration;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayConnectPeer {
    
    const filterSensitiveLog: (obj: TransitGatewayConnectPeer) => any;
}
export interface CreateTransitGatewayConnectPeerResult {
    
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export declare namespace CreateTransitGatewayConnectPeerResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayConnectPeerResult) => any;
}
export declare type AutoAcceptSharedAssociationsValue = "disable" | "enable";
export declare type Igmpv2SupportValue = "disable" | "enable";
export declare type StaticSourcesSupportValue = "disable" | "enable";

export interface CreateTransitGatewayMulticastDomainRequestOptions {
    
    Igmpv2Support?: Igmpv2SupportValue | string;
    
    StaticSourcesSupport?: StaticSourcesSupportValue | string;
    
    AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | string;
}
export declare namespace CreateTransitGatewayMulticastDomainRequestOptions {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayMulticastDomainRequestOptions) => any;
}
export interface CreateTransitGatewayMulticastDomainRequest {
    
    TransitGatewayId: string | undefined;
    
    Options?: CreateTransitGatewayMulticastDomainRequestOptions;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayMulticastDomainRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayMulticastDomainRequest) => any;
}

export interface TransitGatewayMulticastDomainOptions {
    
    Igmpv2Support?: Igmpv2SupportValue | string;
    
    StaticSourcesSupport?: StaticSourcesSupportValue | string;
    
    AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | string;
}
export declare namespace TransitGatewayMulticastDomainOptions {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomainOptions) => any;
}
export declare type TransitGatewayMulticastDomainState = "available" | "deleted" | "deleting" | "pending";

export interface TransitGatewayMulticastDomain {
    
    TransitGatewayMulticastDomainId?: string;
    
    TransitGatewayId?: string;
    
    TransitGatewayMulticastDomainArn?: string;
    
    OwnerId?: string;
    
    Options?: TransitGatewayMulticastDomainOptions;
    
    State?: TransitGatewayMulticastDomainState | string;
    
    CreationTime?: Date;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayMulticastDomain {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomain) => any;
}
export interface CreateTransitGatewayMulticastDomainResult {
    
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export declare namespace CreateTransitGatewayMulticastDomainResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayMulticastDomainResult) => any;
}
export interface CreateTransitGatewayPeeringAttachmentRequest {
    
    TransitGatewayId: string | undefined;
    
    PeerTransitGatewayId: string | undefined;
    
    PeerAccountId: string | undefined;
    
    PeerRegion: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayPeeringAttachmentRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayPeeringAttachmentRequest) => any;
}
export interface CreateTransitGatewayPeeringAttachmentResult {
    
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace CreateTransitGatewayPeeringAttachmentResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayPeeringAttachmentResult) => any;
}
export interface CreateTransitGatewayPrefixListReferenceRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    PrefixListId: string | undefined;
    
    TransitGatewayAttachmentId?: string;
    
    Blackhole?: boolean;
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayPrefixListReferenceRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayPrefixListReferenceRequest) => any;
}
export declare type TransitGatewayPrefixListReferenceState = "available" | "deleting" | "modifying" | "pending";

export interface TransitGatewayPrefixListAttachment {
    
    TransitGatewayAttachmentId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    ResourceId?: string;
}
export declare namespace TransitGatewayPrefixListAttachment {
    
    const filterSensitiveLog: (obj: TransitGatewayPrefixListAttachment) => any;
}

export interface TransitGatewayPrefixListReference {
    
    TransitGatewayRouteTableId?: string;
    
    PrefixListId?: string;
    
    PrefixListOwnerId?: string;
    
    State?: TransitGatewayPrefixListReferenceState | string;
    
    Blackhole?: boolean;
    
    TransitGatewayAttachment?: TransitGatewayPrefixListAttachment;
}
export declare namespace TransitGatewayPrefixListReference {
    
    const filterSensitiveLog: (obj: TransitGatewayPrefixListReference) => any;
}
export interface CreateTransitGatewayPrefixListReferenceResult {
    
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export declare namespace CreateTransitGatewayPrefixListReferenceResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayPrefixListReferenceResult) => any;
}
export interface CreateTransitGatewayRouteRequest {
    
    DestinationCidrBlock: string | undefined;
    
    TransitGatewayRouteTableId: string | undefined;
    
    TransitGatewayAttachmentId?: string;
    
    Blackhole?: boolean;
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayRouteRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteRequest) => any;
}
export declare type TransitGatewayRouteState = "active" | "blackhole" | "deleted" | "deleting" | "pending";

export interface TransitGatewayRouteAttachment {
    
    ResourceId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
}
export declare namespace TransitGatewayRouteAttachment {
    
    const filterSensitiveLog: (obj: TransitGatewayRouteAttachment) => any;
}
export declare type TransitGatewayRouteType = "propagated" | "static";

export interface TransitGatewayRoute {
    
    DestinationCidrBlock?: string;
    
    PrefixListId?: string;
    
    TransitGatewayAttachments?: TransitGatewayRouteAttachment[];
    
    Type?: TransitGatewayRouteType | string;
    
    State?: TransitGatewayRouteState | string;
}
export declare namespace TransitGatewayRoute {
    
    const filterSensitiveLog: (obj: TransitGatewayRoute) => any;
}
export interface CreateTransitGatewayRouteResult {
    
    Route?: TransitGatewayRoute;
}
export declare namespace CreateTransitGatewayRouteResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteResult) => any;
}
export interface CreateTransitGatewayRouteTableRequest {
    
    TransitGatewayId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayRouteTableRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteTableRequest) => any;
}
export declare type TransitGatewayRouteTableState = "available" | "deleted" | "deleting" | "pending";

export interface TransitGatewayRouteTable {
    
    TransitGatewayRouteTableId?: string;
    
    TransitGatewayId?: string;
    
    State?: TransitGatewayRouteTableState | string;
    
    DefaultAssociationRouteTable?: boolean;
    
    DefaultPropagationRouteTable?: boolean;
    
    CreationTime?: Date;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayRouteTable {
    
    const filterSensitiveLog: (obj: TransitGatewayRouteTable) => any;
}
export interface CreateTransitGatewayRouteTableResult {
    
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export declare namespace CreateTransitGatewayRouteTableResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteTableResult) => any;
}

export interface CreateTransitGatewayVpcAttachmentRequestOptions {
    
    DnsSupport?: DnsSupportValue | string;
    
    Ipv6Support?: Ipv6SupportValue | string;
    
    ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export declare namespace CreateTransitGatewayVpcAttachmentRequestOptions {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayVpcAttachmentRequestOptions) => any;
}
export interface CreateTransitGatewayVpcAttachmentRequest {
    
    TransitGatewayId: string | undefined;
    
    VpcId: string | undefined;
    
    SubnetIds: string[] | undefined;
    
    Options?: CreateTransitGatewayVpcAttachmentRequestOptions;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayVpcAttachmentRequest {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayVpcAttachmentRequest) => any;
}
export interface CreateTransitGatewayVpcAttachmentResult {
    
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace CreateTransitGatewayVpcAttachmentResult {
    
    const filterSensitiveLog: (obj: CreateTransitGatewayVpcAttachmentResult) => any;
}
export interface CreateVolumeRequest {
    
    AvailabilityZone: string | undefined;
    
    Encrypted?: boolean;
    
    Iops?: number;
    
    KmsKeyId?: string;
    
    OutpostArn?: string;
    
    Size?: number;
    
    SnapshotId?: string;
    
    VolumeType?: VolumeType | string;
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
    
    MultiAttachEnabled?: boolean;
    
    Throughput?: number;
    
    ClientToken?: string;
}
export declare namespace CreateVolumeRequest {
    
    const filterSensitiveLog: (obj: CreateVolumeRequest) => any;
}
export declare type VolumeState = "available" | "creating" | "deleted" | "deleting" | "error" | "in-use";

export interface Volume {
    
    Attachments?: VolumeAttachment[];
    
    AvailabilityZone?: string;
    
    CreateTime?: Date;
    
    Encrypted?: boolean;
    
    KmsKeyId?: string;
    
    OutpostArn?: string;
    
    Size?: number;
    
    SnapshotId?: string;
    
    State?: VolumeState | string;
    
    VolumeId?: string;
    
    Iops?: number;
    
    Tags?: Tag[];
    
    VolumeType?: VolumeType | string;
    
    FastRestored?: boolean;
    
    MultiAttachEnabled?: boolean;
    
    Throughput?: number;
}
export declare namespace Volume {
    
    const filterSensitiveLog: (obj: Volume) => any;
}
export interface CreateVpcRequest {
    
    CidrBlock?: string;
    
    AmazonProvidedIpv6CidrBlock?: boolean;
    
    Ipv6Pool?: string;
    
    Ipv6CidrBlock?: string;
    
    Ipv4IpamPoolId?: string;
    
    Ipv4NetmaskLength?: number;
    
    Ipv6IpamPoolId?: string;
    
    Ipv6NetmaskLength?: number;
    
    DryRun?: boolean;
    
    InstanceTenancy?: Tenancy | string;
    
    Ipv6CidrBlockNetworkBorderGroup?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcRequest {
    
    const filterSensitiveLog: (obj: CreateVpcRequest) => any;
}
export interface CreateVpcResult {
    
    Vpc?: Vpc;
}
export declare namespace CreateVpcResult {
    
    const filterSensitiveLog: (obj: CreateVpcResult) => any;
}
export declare enum VpcEndpointType {
    Gateway = "Gateway",
    GatewayLoadBalancer = "GatewayLoadBalancer",
    Interface = "Interface"
}

export interface CreateVpcEndpointRequest {
    
    DryRun?: boolean;
    
    VpcEndpointType?: VpcEndpointType | string;
    
    VpcId: string | undefined;
    
    ServiceName: string | undefined;
    
    PolicyDocument?: string;
    
    RouteTableIds?: string[];
    
    SubnetIds?: string[];
    
    SecurityGroupIds?: string[];
    
    ClientToken?: string;
    
    PrivateDnsEnabled?: boolean;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcEndpointRequest {
    
    const filterSensitiveLog: (obj: CreateVpcEndpointRequest) => any;
}

export interface DnsEntry {
    
    DnsName?: string;
    
    HostedZoneId?: string;
}
export declare namespace DnsEntry {
    
    const filterSensitiveLog: (obj: DnsEntry) => any;
}

export interface SecurityGroupIdentifier {
    
    GroupId?: string;
    
    GroupName?: string;
}
export declare namespace SecurityGroupIdentifier {
    
    const filterSensitiveLog: (obj: SecurityGroupIdentifier) => any;
}

export interface LastError {
    
    Message?: string;
    
    Code?: string;
}
export declare namespace LastError {
    
    const filterSensitiveLog: (obj: LastError) => any;
}
export declare enum State {
    Available = "Available",
    Deleted = "Deleted",
    Deleting = "Deleting",
    Expired = "Expired",
    Failed = "Failed",
    Pending = "Pending",
    PendingAcceptance = "PendingAcceptance",
    Rejected = "Rejected"
}

export interface VpcEndpoint {
    
    VpcEndpointId?: string;
    
    VpcEndpointType?: VpcEndpointType | string;
    
    VpcId?: string;
    
    ServiceName?: string;
    
    State?: State | string;
    
    PolicyDocument?: string;
    
    RouteTableIds?: string[];
    
    SubnetIds?: string[];
    
    Groups?: SecurityGroupIdentifier[];
    
    PrivateDnsEnabled?: boolean;
    
    RequesterManaged?: boolean;
    
    NetworkInterfaceIds?: string[];
    
    DnsEntries?: DnsEntry[];
    
    CreationTimestamp?: Date;
    
    Tags?: Tag[];
    
    OwnerId?: string;
    
    LastError?: LastError;
}
export declare namespace VpcEndpoint {
    
    const filterSensitiveLog: (obj: VpcEndpoint) => any;
}

export interface CreateVpcEndpointResult {
    
    VpcEndpoint?: VpcEndpoint;
    
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointResult {
    
    const filterSensitiveLog: (obj: CreateVpcEndpointResult) => any;
}
export interface CreateVpcEndpointConnectionNotificationRequest {
    
    DryRun?: boolean;
    
    ServiceId?: string;
    
    VpcEndpointId?: string;
    
    ConnectionNotificationArn: string | undefined;
    
    ConnectionEvents: string[] | undefined;
    
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointConnectionNotificationRequest {
    
    const filterSensitiveLog: (obj: CreateVpcEndpointConnectionNotificationRequest) => any;
}
export declare enum ConnectionNotificationState {
    Disabled = "Disabled",
    Enabled = "Enabled"
}
export declare enum ConnectionNotificationType {
    Topic = "Topic"
}

export interface ConnectionNotification {
    
    ConnectionNotificationId?: string;
    
    ServiceId?: string;
    
    VpcEndpointId?: string;
    
    ConnectionNotificationType?: ConnectionNotificationType | string;
    
    ConnectionNotificationArn?: string;
    
    ConnectionEvents?: string[];
    
    ConnectionNotificationState?: ConnectionNotificationState | string;
}
export declare namespace ConnectionNotification {
    
    const filterSensitiveLog: (obj: ConnectionNotification) => any;
}
export interface CreateVpcEndpointConnectionNotificationResult {
    
    ConnectionNotification?: ConnectionNotification;
    
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointConnectionNotificationResult {
    
    const filterSensitiveLog: (obj: CreateVpcEndpointConnectionNotificationResult) => any;
}
export interface CreateVpcEndpointServiceConfigurationRequest {
    
    DryRun?: boolean;
    
    AcceptanceRequired?: boolean;
    
    PrivateDnsName?: string;
    
    NetworkLoadBalancerArns?: string[];
    
    GatewayLoadBalancerArns?: string[];
    
    ClientToken?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcEndpointServiceConfigurationRequest {
    
    const filterSensitiveLog: (obj: CreateVpcEndpointServiceConfigurationRequest) => any;
}
export declare enum DnsNameState {
    Failed = "failed",
    PendingVerification = "pendingVerification",
    Verified = "verified"
}

export interface PrivateDnsNameConfiguration {
    
    State?: DnsNameState | string;
    
    Type?: string;
    
    Value?: string;
    
    Name?: string;
}
export declare namespace PrivateDnsNameConfiguration {
    
    const filterSensitiveLog: (obj: PrivateDnsNameConfiguration) => any;
}
export declare enum ServiceState {
    Available = "Available",
    Deleted = "Deleted",
    Deleting = "Deleting",
    Failed = "Failed",
    Pending = "Pending"
}
export declare enum ServiceType {
    Gateway = "Gateway",
    GatewayLoadBalancer = "GatewayLoadBalancer",
    Interface = "Interface"
}

export interface ServiceTypeDetail {
    
    ServiceType?: ServiceType | string;
}
export declare namespace ServiceTypeDetail {
    
    const filterSensitiveLog: (obj: ServiceTypeDetail) => any;
}

export interface ServiceConfiguration {
    
    ServiceType?: ServiceTypeDetail[];
    
    ServiceId?: string;
    
    ServiceName?: string;
    
    ServiceState?: ServiceState | string;
    
    AvailabilityZones?: string[];
    
    AcceptanceRequired?: boolean;
    
    ManagesVpcEndpoints?: boolean;
    
    NetworkLoadBalancerArns?: string[];
    
    GatewayLoadBalancerArns?: string[];
    
    BaseEndpointDnsNames?: string[];
    
    PrivateDnsName?: string;
    
    PrivateDnsNameConfiguration?: PrivateDnsNameConfiguration;
    
    Tags?: Tag[];
}
export declare namespace ServiceConfiguration {
    
    const filterSensitiveLog: (obj: ServiceConfiguration) => any;
}
export interface CreateVpcEndpointServiceConfigurationResult {
    
    ServiceConfiguration?: ServiceConfiguration;
    
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointServiceConfigurationResult {
    
    const filterSensitiveLog: (obj: CreateVpcEndpointServiceConfigurationResult) => any;
}
export interface CreateVpcPeeringConnectionRequest {
    
    DryRun?: boolean;
    
    PeerOwnerId?: string;
    
    PeerVpcId?: string;
    
    VpcId?: string;
    
    PeerRegion?: string;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcPeeringConnectionRequest {
    
    const filterSensitiveLog: (obj: CreateVpcPeeringConnectionRequest) => any;
}
export interface CreateVpcPeeringConnectionResult {
    
    VpcPeeringConnection?: VpcPeeringConnection;
}
export declare namespace CreateVpcPeeringConnectionResult {
    
    const filterSensitiveLog: (obj: CreateVpcPeeringConnectionResult) => any;
}
export declare type TunnelInsideIpVersion = "ipv4" | "ipv6";

export interface IKEVersionsRequestListValue {
    
    Value?: string;
}
export declare namespace IKEVersionsRequestListValue {
    
    const filterSensitiveLog: (obj: IKEVersionsRequestListValue) => any;
}

export interface Phase1DHGroupNumbersRequestListValue {
    
    Value?: number;
}
export declare namespace Phase1DHGroupNumbersRequestListValue {
    
    const filterSensitiveLog: (obj: Phase1DHGroupNumbersRequestListValue) => any;
}

export interface Phase1EncryptionAlgorithmsRequestListValue {
    
    Value?: string;
}
export declare namespace Phase1EncryptionAlgorithmsRequestListValue {
    
    const filterSensitiveLog: (obj: Phase1EncryptionAlgorithmsRequestListValue) => any;
}

export interface Phase1IntegrityAlgorithmsRequestListValue {
    
    Value?: string;
}
export declare namespace Phase1IntegrityAlgorithmsRequestListValue {
    
    const filterSensitiveLog: (obj: Phase1IntegrityAlgorithmsRequestListValue) => any;
}

export interface Phase2DHGroupNumbersRequestListValue {
    
    Value?: number;
}
export declare namespace Phase2DHGroupNumbersRequestListValue {
    
    const filterSensitiveLog: (obj: Phase2DHGroupNumbersRequestListValue) => any;
}

export interface Phase2EncryptionAlgorithmsRequestListValue {
    
    Value?: string;
}
export declare namespace Phase2EncryptionAlgorithmsRequestListValue {
    
    const filterSensitiveLog: (obj: Phase2EncryptionAlgorithmsRequestListValue) => any;
}

export interface Phase2IntegrityAlgorithmsRequestListValue {
    
    Value?: string;
}
export declare namespace Phase2IntegrityAlgorithmsRequestListValue {
    
    const filterSensitiveLog: (obj: Phase2IntegrityAlgorithmsRequestListValue) => any;
}

export interface VpnTunnelOptionsSpecification {
    
    TunnelInsideCidr?: string;
    
    TunnelInsideIpv6Cidr?: string;
    
    PreSharedKey?: string;
    
    Phase1LifetimeSeconds?: number;
    
    Phase2LifetimeSeconds?: number;
    
    RekeyMarginTimeSeconds?: number;
    
    RekeyFuzzPercentage?: number;
    
    ReplayWindowSize?: number;
    
    DPDTimeoutSeconds?: number;
    
    DPDTimeoutAction?: string;
    
    Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
    
    Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
    
    Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
    
    Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
    
    Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
    
    Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
    
    IKEVersions?: IKEVersionsRequestListValue[];
    
    StartupAction?: string;
}
export declare namespace VpnTunnelOptionsSpecification {
    
    const filterSensitiveLog: (obj: VpnTunnelOptionsSpecification) => any;
}

export interface VpnConnectionOptionsSpecification {
    
    EnableAcceleration?: boolean;
    
    StaticRoutesOnly?: boolean;
    
    TunnelInsideIpVersion?: TunnelInsideIpVersion | string;
    
    TunnelOptions?: VpnTunnelOptionsSpecification[];
    
    LocalIpv4NetworkCidr?: string;
    
    RemoteIpv4NetworkCidr?: string;
    
    LocalIpv6NetworkCidr?: string;
    
    RemoteIpv6NetworkCidr?: string;
}
export declare namespace VpnConnectionOptionsSpecification {
    
    const filterSensitiveLog: (obj: VpnConnectionOptionsSpecification) => any;
}

export interface CreateVpnConnectionRequest {
    
    CustomerGatewayId: string | undefined;
    
    Type: string | undefined;
    
    VpnGatewayId?: string;
    
    TransitGatewayId?: string;
    
    DryRun?: boolean;
    
    Options?: VpnConnectionOptionsSpecification;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpnConnectionRequest {
    
    const filterSensitiveLog: (obj: CreateVpnConnectionRequest) => any;
}
export declare enum GatewayAssociationState {
    associated = "associated",
    associating = "associating",
    disassociating = "disassociating",
    not_associated = "not-associated"
}

export interface IKEVersionsListValue {
    
    Value?: string;
}
export declare namespace IKEVersionsListValue {
    
    const filterSensitiveLog: (obj: IKEVersionsListValue) => any;
}

export interface Phase1DHGroupNumbersListValue {
    
    Value?: number;
}
export declare namespace Phase1DHGroupNumbersListValue {
    
    const filterSensitiveLog: (obj: Phase1DHGroupNumbersListValue) => any;
}

export interface Phase1EncryptionAlgorithmsListValue {
    
    Value?: string;
}
export declare namespace Phase1EncryptionAlgorithmsListValue {
    
    const filterSensitiveLog: (obj: Phase1EncryptionAlgorithmsListValue) => any;
}

export interface Phase1IntegrityAlgorithmsListValue {
    
    Value?: string;
}
export declare namespace Phase1IntegrityAlgorithmsListValue {
    
    const filterSensitiveLog: (obj: Phase1IntegrityAlgorithmsListValue) => any;
}

export interface Phase2DHGroupNumbersListValue {
    
    Value?: number;
}
export declare namespace Phase2DHGroupNumbersListValue {
    
    const filterSensitiveLog: (obj: Phase2DHGroupNumbersListValue) => any;
}

export interface Phase2EncryptionAlgorithmsListValue {
    
    Value?: string;
}
export declare namespace Phase2EncryptionAlgorithmsListValue {
    
    const filterSensitiveLog: (obj: Phase2EncryptionAlgorithmsListValue) => any;
}

export interface Phase2IntegrityAlgorithmsListValue {
    
    Value?: string;
}
export declare namespace Phase2IntegrityAlgorithmsListValue {
    
    const filterSensitiveLog: (obj: Phase2IntegrityAlgorithmsListValue) => any;
}

export interface TunnelOption {
    
    OutsideIpAddress?: string;
    
    TunnelInsideCidr?: string;
    
    TunnelInsideIpv6Cidr?: string;
    
    PreSharedKey?: string;
    
    Phase1LifetimeSeconds?: number;
    
    Phase2LifetimeSeconds?: number;
    
    RekeyMarginTimeSeconds?: number;
    
    RekeyFuzzPercentage?: number;
    
    ReplayWindowSize?: number;
    
    DpdTimeoutSeconds?: number;
    
    DpdTimeoutAction?: string;
    
    Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsListValue[];
    
    Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsListValue[];
    
    Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsListValue[];
    
    Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsListValue[];
    
    Phase1DHGroupNumbers?: Phase1DHGroupNumbersListValue[];
    
    Phase2DHGroupNumbers?: Phase2DHGroupNumbersListValue[];
    
    IkeVersions?: IKEVersionsListValue[];
    
    StartupAction?: string;
}
export declare namespace TunnelOption {
    
    const filterSensitiveLog: (obj: TunnelOption) => any;
}

export interface VpnConnectionOptions {
    
    EnableAcceleration?: boolean;
    
    StaticRoutesOnly?: boolean;
    
    LocalIpv4NetworkCidr?: string;
    
    RemoteIpv4NetworkCidr?: string;
    
    LocalIpv6NetworkCidr?: string;
    
    RemoteIpv6NetworkCidr?: string;
    
    TunnelInsideIpVersion?: TunnelInsideIpVersion | string;
    
    TunnelOptions?: TunnelOption[];
}
export declare namespace VpnConnectionOptions {
    
    const filterSensitiveLog: (obj: VpnConnectionOptions) => any;
}
export declare type VpnStaticRouteSource = "Static";
export declare type VpnState = "available" | "deleted" | "deleting" | "pending";

export interface VpnStaticRoute {
    
    DestinationCidrBlock?: string;
    
    Source?: VpnStaticRouteSource | string;
    
    State?: VpnState | string;
}
export declare namespace VpnStaticRoute {
    
    const filterSensitiveLog: (obj: VpnStaticRoute) => any;
}
export declare type TelemetryStatus = "DOWN" | "UP";

export interface VgwTelemetry {
    
    AcceptedRouteCount?: number;
    
    LastStatusChange?: Date;
    
    OutsideIpAddress?: string;
    
    Status?: TelemetryStatus | string;
    
    StatusMessage?: string;
    
    CertificateArn?: string;
}
export declare namespace VgwTelemetry {
    
    const filterSensitiveLog: (obj: VgwTelemetry) => any;
}

export interface VpnConnection {
    
    CustomerGatewayConfiguration?: string;
    
    CustomerGatewayId?: string;
    
    Category?: string;
    
    State?: VpnState | string;
    
    Type?: GatewayType | string;
    
    VpnConnectionId?: string;
    
    VpnGatewayId?: string;
    
    TransitGatewayId?: string;
    
    CoreNetworkArn?: string;
    
    CoreNetworkAttachmentArn?: string;
    
    GatewayAssociationState?: GatewayAssociationState | string;
    
    Options?: VpnConnectionOptions;
    
    Routes?: VpnStaticRoute[];
    
    Tags?: Tag[];
    
    VgwTelemetry?: VgwTelemetry[];
}
export declare namespace VpnConnection {
    
    const filterSensitiveLog: (obj: VpnConnection) => any;
}

export interface CreateVpnConnectionResult {
    
    VpnConnection?: VpnConnection;
}
export declare namespace CreateVpnConnectionResult {
    
    const filterSensitiveLog: (obj: CreateVpnConnectionResult) => any;
}

export interface CreateVpnConnectionRouteRequest {
    
    DestinationCidrBlock: string | undefined;
    
    VpnConnectionId: string | undefined;
}
export declare namespace CreateVpnConnectionRouteRequest {
    
    const filterSensitiveLog: (obj: CreateVpnConnectionRouteRequest) => any;
}

export interface CreateVpnGatewayRequest {
    
    AvailabilityZone?: string;
    
    Type: GatewayType | string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    AmazonSideAsn?: number;
    
    DryRun?: boolean;
}
export declare namespace CreateVpnGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateVpnGatewayRequest) => any;
}

export interface VpnGateway {
    
    AvailabilityZone?: string;
    
    State?: VpnState | string;
    
    Type?: GatewayType | string;
    
    VpcAttachments?: VpcAttachment[];
    
    VpnGatewayId?: string;
    
    AmazonSideAsn?: number;
    
    Tags?: Tag[];
}
export declare namespace VpnGateway {
    
    const filterSensitiveLog: (obj: VpnGateway) => any;
}

export interface CreateVpnGatewayResult {
    
    VpnGateway?: VpnGateway;
}
export declare namespace CreateVpnGatewayResult {
    
    const filterSensitiveLog: (obj: CreateVpnGatewayResult) => any;
}
export interface DeleteCarrierGatewayRequest {
    
    CarrierGatewayId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteCarrierGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteCarrierGatewayRequest) => any;
}
export interface DeleteCarrierGatewayResult {
    
    CarrierGateway?: CarrierGateway;
}
export declare namespace DeleteCarrierGatewayResult {
    
    const filterSensitiveLog: (obj: DeleteCarrierGatewayResult) => any;
}
export interface DeleteClientVpnEndpointRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteClientVpnEndpointRequest {
    
    const filterSensitiveLog: (obj: DeleteClientVpnEndpointRequest) => any;
}
export interface DeleteClientVpnEndpointResult {
    
    Status?: ClientVpnEndpointStatus;
}
export declare namespace DeleteClientVpnEndpointResult {
    
    const filterSensitiveLog: (obj: DeleteClientVpnEndpointResult) => any;
}
export interface DeleteClientVpnRouteRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    TargetVpcSubnetId?: string;
    
    DestinationCidrBlock: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteClientVpnRouteRequest {
    
    const filterSensitiveLog: (obj: DeleteClientVpnRouteRequest) => any;
}
export interface DeleteClientVpnRouteResult {
    
    Status?: ClientVpnRouteStatus;
}
export declare namespace DeleteClientVpnRouteResult {
    
    const filterSensitiveLog: (obj: DeleteClientVpnRouteResult) => any;
}

export interface DeleteCustomerGatewayRequest {
    
    CustomerGatewayId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteCustomerGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteCustomerGatewayRequest) => any;
}
export interface DeleteDhcpOptionsRequest {
    
    DhcpOptionsId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteDhcpOptionsRequest {
    
    const filterSensitiveLog: (obj: DeleteDhcpOptionsRequest) => any;
}
export interface DeleteEgressOnlyInternetGatewayRequest {
    
    DryRun?: boolean;
    
    EgressOnlyInternetGatewayId: string | undefined;
}
export declare namespace DeleteEgressOnlyInternetGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteEgressOnlyInternetGatewayRequest) => any;
}
export interface DeleteEgressOnlyInternetGatewayResult {
    
    ReturnCode?: boolean;
}
export declare namespace DeleteEgressOnlyInternetGatewayResult {
    
    const filterSensitiveLog: (obj: DeleteEgressOnlyInternetGatewayResult) => any;
}
export interface DeleteFleetsRequest {
    
    DryRun?: boolean;
    
    FleetIds: string[] | undefined;
    
    TerminateInstances: boolean | undefined;
}
export declare namespace DeleteFleetsRequest {
    
    const filterSensitiveLog: (obj: DeleteFleetsRequest) => any;
}
export declare enum FleetStateCode {
    ACTIVE = "active",
    DELETED = "deleted",
    DELETED_RUNNING = "deleted_running",
    DELETED_TERMINATING_INSTANCES = "deleted_terminating",
    FAILED = "failed",
    MODIFYING = "modifying",
    SUBMITTED = "submitted"
}

export interface DeleteFleetSuccessItem {
    
    CurrentFleetState?: FleetStateCode | string;
    
    PreviousFleetState?: FleetStateCode | string;
    
    FleetId?: string;
}
export declare namespace DeleteFleetSuccessItem {
    
    const filterSensitiveLog: (obj: DeleteFleetSuccessItem) => any;
}
export declare enum DeleteFleetErrorCode {
    FLEET_ID_DOES_NOT_EXIST = "fleetIdDoesNotExist",
    FLEET_ID_MALFORMED = "fleetIdMalformed",
    FLEET_NOT_IN_DELETABLE_STATE = "fleetNotInDeletableState",
    UNEXPECTED_ERROR = "unexpectedError"
}

export interface DeleteFleetError {
    
    Code?: DeleteFleetErrorCode | string;
    
    Message?: string;
}
export declare namespace DeleteFleetError {
    
    const filterSensitiveLog: (obj: DeleteFleetError) => any;
}

export interface DeleteFleetErrorItem {
    
    Error?: DeleteFleetError;
    
    FleetId?: string;
}
export declare namespace DeleteFleetErrorItem {
    
    const filterSensitiveLog: (obj: DeleteFleetErrorItem) => any;
}
export interface DeleteFleetsResult {
    
    SuccessfulFleetDeletions?: DeleteFleetSuccessItem[];
    
    UnsuccessfulFleetDeletions?: DeleteFleetErrorItem[];
}
export declare namespace DeleteFleetsResult {
    
    const filterSensitiveLog: (obj: DeleteFleetsResult) => any;
}
export interface DeleteFlowLogsRequest {
    
    DryRun?: boolean;
    
    FlowLogIds: string[] | undefined;
}
export declare namespace DeleteFlowLogsRequest {
    
    const filterSensitiveLog: (obj: DeleteFlowLogsRequest) => any;
}
export interface DeleteFlowLogsResult {
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteFlowLogsResult {
    
    const filterSensitiveLog: (obj: DeleteFlowLogsResult) => any;
}
export interface DeleteFpgaImageRequest {
    
    DryRun?: boolean;
    
    FpgaImageId: string | undefined;
}
export declare namespace DeleteFpgaImageRequest {
    
    const filterSensitiveLog: (obj: DeleteFpgaImageRequest) => any;
}
export interface DeleteFpgaImageResult {
    
    Return?: boolean;
}
export declare namespace DeleteFpgaImageResult {
    
    const filterSensitiveLog: (obj: DeleteFpgaImageResult) => any;
}
export interface DeleteInstanceEventWindowRequest {
    
    DryRun?: boolean;
    
    ForceDelete?: boolean;
    
    InstanceEventWindowId: string | undefined;
}
export declare namespace DeleteInstanceEventWindowRequest {
    
    const filterSensitiveLog: (obj: DeleteInstanceEventWindowRequest) => any;
}

export interface InstanceEventWindowStateChange {
    
    InstanceEventWindowId?: string;
    
    State?: InstanceEventWindowState | string;
}
export declare namespace InstanceEventWindowStateChange {
    
    const filterSensitiveLog: (obj: InstanceEventWindowStateChange) => any;
}
export interface DeleteInstanceEventWindowResult {
    
    InstanceEventWindowState?: InstanceEventWindowStateChange;
}
export declare namespace DeleteInstanceEventWindowResult {
    
    const filterSensitiveLog: (obj: DeleteInstanceEventWindowResult) => any;
}
export interface DeleteInternetGatewayRequest {
    
    DryRun?: boolean;
    
    InternetGatewayId: string | undefined;
}
export declare namespace DeleteInternetGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteInternetGatewayRequest) => any;
}
export interface DeleteIpamRequest {
    
    DryRun?: boolean;
    
    IpamId: string | undefined;
}
export declare namespace DeleteIpamRequest {
    
    const filterSensitiveLog: (obj: DeleteIpamRequest) => any;
}
export interface DeleteIpamResult {
    
    Ipam?: Ipam;
}
export declare namespace DeleteIpamResult {
    
    const filterSensitiveLog: (obj: DeleteIpamResult) => any;
}
export interface DeleteIpamPoolRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
}
export declare namespace DeleteIpamPoolRequest {
    
    const filterSensitiveLog: (obj: DeleteIpamPoolRequest) => any;
}
export interface DeleteIpamPoolResult {
    
    IpamPool?: IpamPool;
}
export declare namespace DeleteIpamPoolResult {
    
    const filterSensitiveLog: (obj: DeleteIpamPoolResult) => any;
}
export interface DeleteIpamScopeRequest {
    
    DryRun?: boolean;
    
    IpamScopeId: string | undefined;
}
export declare namespace DeleteIpamScopeRequest {
    
    const filterSensitiveLog: (obj: DeleteIpamScopeRequest) => any;
}
export interface DeleteIpamScopeResult {
    
    IpamScope?: IpamScope;
}
export declare namespace DeleteIpamScopeResult {
    
    const filterSensitiveLog: (obj: DeleteIpamScopeResult) => any;
}
export interface DeleteKeyPairRequest {
    
    KeyName?: string;
    
    KeyPairId?: string;
    
    DryRun?: boolean;
}
export declare namespace DeleteKeyPairRequest {
    
    const filterSensitiveLog: (obj: DeleteKeyPairRequest) => any;
}
export interface DeleteLaunchTemplateRequest {
    
    DryRun?: boolean;
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
}
export declare namespace DeleteLaunchTemplateRequest {
    
    const filterSensitiveLog: (obj: DeleteLaunchTemplateRequest) => any;
}
export interface DeleteLaunchTemplateResult {
    
    LaunchTemplate?: LaunchTemplate;
}
export declare namespace DeleteLaunchTemplateResult {
    
    const filterSensitiveLog: (obj: DeleteLaunchTemplateResult) => any;
}
export interface DeleteLaunchTemplateVersionsRequest {
    
    DryRun?: boolean;
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    Versions: string[] | undefined;
}
export declare namespace DeleteLaunchTemplateVersionsRequest {
    
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsRequest) => any;
}

export interface DeleteLaunchTemplateVersionsResponseSuccessItem {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    VersionNumber?: number;
}
export declare namespace DeleteLaunchTemplateVersionsResponseSuccessItem {
    
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsResponseSuccessItem) => any;
}
export declare enum LaunchTemplateErrorCode {
    LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST = "launchTemplateIdDoesNotExist",
    LAUNCH_TEMPLATE_ID_MALFORMED = "launchTemplateIdMalformed",
    LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST = "launchTemplateNameDoesNotExist",
    LAUNCH_TEMPLATE_NAME_MALFORMED = "launchTemplateNameMalformed",
    LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST = "launchTemplateVersionDoesNotExist",
    UNEXPECTED_ERROR = "unexpectedError"
}

export interface ResponseError {
    
    Code?: LaunchTemplateErrorCode | string;
    
    Message?: string;
}
export declare namespace ResponseError {
    
    const filterSensitiveLog: (obj: ResponseError) => any;
}

export interface DeleteLaunchTemplateVersionsResponseErrorItem {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    VersionNumber?: number;
    
    ResponseError?: ResponseError;
}
export declare namespace DeleteLaunchTemplateVersionsResponseErrorItem {
    
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsResponseErrorItem) => any;
}
export interface DeleteLaunchTemplateVersionsResult {
    
    SuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseSuccessItem[];
    
    UnsuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseErrorItem[];
}
export declare namespace DeleteLaunchTemplateVersionsResult {
    
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsResult) => any;
}
export interface DeleteLocalGatewayRouteRequest {
    
    DestinationCidrBlock: string | undefined;
    
    LocalGatewayRouteTableId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteLocalGatewayRouteRequest {
    
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteRequest) => any;
}
export interface DeleteLocalGatewayRouteResult {
    
    Route?: LocalGatewayRoute;
}
export declare namespace DeleteLocalGatewayRouteResult {
    
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteResult) => any;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationRequest {
    
    LocalGatewayRouteTableVpcAssociationId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteLocalGatewayRouteTableVpcAssociationRequest {
    
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteTableVpcAssociationRequest) => any;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationResult {
    
    LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export declare namespace DeleteLocalGatewayRouteTableVpcAssociationResult {
    
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteTableVpcAssociationResult) => any;
}
export interface DeleteManagedPrefixListRequest {
    
    DryRun?: boolean;
    
    PrefixListId: string | undefined;
}
export declare namespace DeleteManagedPrefixListRequest {
    
    const filterSensitiveLog: (obj: DeleteManagedPrefixListRequest) => any;
}
export interface DeleteManagedPrefixListResult {
    
    PrefixList?: ManagedPrefixList;
}
export declare namespace DeleteManagedPrefixListResult {
    
    const filterSensitiveLog: (obj: DeleteManagedPrefixListResult) => any;
}
export interface DeleteNatGatewayRequest {
    
    DryRun?: boolean;
    
    NatGatewayId: string | undefined;
}
export declare namespace DeleteNatGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteNatGatewayRequest) => any;
}
export interface DeleteNatGatewayResult {
    
    NatGatewayId?: string;
}
export declare namespace DeleteNatGatewayResult {
    
    const filterSensitiveLog: (obj: DeleteNatGatewayResult) => any;
}
export interface DeleteNetworkAclRequest {
    
    DryRun?: boolean;
    
    NetworkAclId: string | undefined;
}
export declare namespace DeleteNetworkAclRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkAclRequest) => any;
}
export interface DeleteNetworkAclEntryRequest {
    
    DryRun?: boolean;
    
    Egress: boolean | undefined;
    
    NetworkAclId: string | undefined;
    
    RuleNumber: number | undefined;
}
export declare namespace DeleteNetworkAclEntryRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkAclEntryRequest) => any;
}
export interface DeleteNetworkInsightsAccessScopeRequest {
    
    DryRun?: boolean;
    
    NetworkInsightsAccessScopeId: string | undefined;
}
export declare namespace DeleteNetworkInsightsAccessScopeRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeRequest) => any;
}
export interface DeleteNetworkInsightsAccessScopeResult {
    
    NetworkInsightsAccessScopeId?: string;
}
export declare namespace DeleteNetworkInsightsAccessScopeResult {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeResult) => any;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
    
    NetworkInsightsAccessScopeAnalysisId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteNetworkInsightsAccessScopeAnalysisRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeAnalysisRequest) => any;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
    
    NetworkInsightsAccessScopeAnalysisId?: string;
}
export declare namespace DeleteNetworkInsightsAccessScopeAnalysisResult {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeAnalysisResult) => any;
}
export interface DeleteNetworkInsightsAnalysisRequest {
    
    DryRun?: boolean;
    
    NetworkInsightsAnalysisId: string | undefined;
}
export declare namespace DeleteNetworkInsightsAnalysisRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAnalysisRequest) => any;
}
export interface DeleteNetworkInsightsAnalysisResult {
    
    NetworkInsightsAnalysisId?: string;
}
export declare namespace DeleteNetworkInsightsAnalysisResult {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAnalysisResult) => any;
}
export interface DeleteNetworkInsightsPathRequest {
    
    DryRun?: boolean;
    
    NetworkInsightsPathId: string | undefined;
}
export declare namespace DeleteNetworkInsightsPathRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsPathRequest) => any;
}
export interface DeleteNetworkInsightsPathResult {
    
    NetworkInsightsPathId?: string;
}
export declare namespace DeleteNetworkInsightsPathResult {
    
    const filterSensitiveLog: (obj: DeleteNetworkInsightsPathResult) => any;
}

export interface DeleteNetworkInterfaceRequest {
    
    DryRun?: boolean;
    
    NetworkInterfaceId: string | undefined;
}
export declare namespace DeleteNetworkInterfaceRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkInterfaceRequest) => any;
}

export interface DeleteNetworkInterfacePermissionRequest {
    
    NetworkInterfacePermissionId: string | undefined;
    
    Force?: boolean;
    
    DryRun?: boolean;
}
export declare namespace DeleteNetworkInterfacePermissionRequest {
    
    const filterSensitiveLog: (obj: DeleteNetworkInterfacePermissionRequest) => any;
}

export interface DeleteNetworkInterfacePermissionResult {
    
    Return?: boolean;
}
export declare namespace DeleteNetworkInterfacePermissionResult {
    
    const filterSensitiveLog: (obj: DeleteNetworkInterfacePermissionResult) => any;
}
export interface DeletePlacementGroupRequest {
    
    DryRun?: boolean;
    
    GroupName: string | undefined;
}
export declare namespace DeletePlacementGroupRequest {
    
    const filterSensitiveLog: (obj: DeletePlacementGroupRequest) => any;
}
export interface DeletePublicIpv4PoolRequest {
    
    DryRun?: boolean;
    
    PoolId: string | undefined;
}
export declare namespace DeletePublicIpv4PoolRequest {
    
    const filterSensitiveLog: (obj: DeletePublicIpv4PoolRequest) => any;
}
export interface DeletePublicIpv4PoolResult {
    
    ReturnValue?: boolean;
}
export declare namespace DeletePublicIpv4PoolResult {
    
    const filterSensitiveLog: (obj: DeletePublicIpv4PoolResult) => any;
}
export interface DeleteQueuedReservedInstancesRequest {
    
    DryRun?: boolean;
    
    ReservedInstancesIds: string[] | undefined;
}
export declare namespace DeleteQueuedReservedInstancesRequest {
    
    const filterSensitiveLog: (obj: DeleteQueuedReservedInstancesRequest) => any;
}
export declare enum DeleteQueuedReservedInstancesErrorCode {
    RESERVED_INSTANCES_ID_INVALID = "reserved-instances-id-invalid",
    RESERVED_INSTANCES_NOT_IN_QUEUED_STATE = "reserved-instances-not-in-queued-state",
    UNEXPECTED_ERROR = "unexpected-error"
}

export interface DeleteQueuedReservedInstancesError {
    
    Code?: DeleteQueuedReservedInstancesErrorCode | string;
    
    Message?: string;
}
export declare namespace DeleteQueuedReservedInstancesError {
    
    const filterSensitiveLog: (obj: DeleteQueuedReservedInstancesError) => any;
}

export interface FailedQueuedPurchaseDeletion {
    
    Error?: DeleteQueuedReservedInstancesError;
    
    ReservedInstancesId?: string;
}
export declare namespace FailedQueuedPurchaseDeletion {
    
    const filterSensitiveLog: (obj: FailedQueuedPurchaseDeletion) => any;
}

export interface SuccessfulQueuedPurchaseDeletion {
    
    ReservedInstancesId?: string;
}
export declare namespace SuccessfulQueuedPurchaseDeletion {
    
    const filterSensitiveLog: (obj: SuccessfulQueuedPurchaseDeletion) => any;
}
export interface DeleteQueuedReservedInstancesResult {
    
    SuccessfulQueuedPurchaseDeletions?: SuccessfulQueuedPurchaseDeletion[];
    
    FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletion[];
}
export declare namespace DeleteQueuedReservedInstancesResult {
    
    const filterSensitiveLog: (obj: DeleteQueuedReservedInstancesResult) => any;
}
export interface DeleteRouteRequest {
    
    DestinationCidrBlock?: string;
    
    DestinationIpv6CidrBlock?: string;
    
    DestinationPrefixListId?: string;
    
    DryRun?: boolean;
    
    RouteTableId: string | undefined;
}
export declare namespace DeleteRouteRequest {
    
    const filterSensitiveLog: (obj: DeleteRouteRequest) => any;
}
export interface DeleteRouteTableRequest {
    
    DryRun?: boolean;
    
    RouteTableId: string | undefined;
}
export declare namespace DeleteRouteTableRequest {
    
    const filterSensitiveLog: (obj: DeleteRouteTableRequest) => any;
}
export interface DeleteSecurityGroupRequest {
    
    GroupId?: string;
    
    GroupName?: string;
    
    DryRun?: boolean;
}
export declare namespace DeleteSecurityGroupRequest {
    
    const filterSensitiveLog: (obj: DeleteSecurityGroupRequest) => any;
}
export interface DeleteSnapshotRequest {
    
    SnapshotId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteSnapshotRequest {
    
    const filterSensitiveLog: (obj: DeleteSnapshotRequest) => any;
}

export interface DeleteSpotDatafeedSubscriptionRequest {
    
    DryRun?: boolean;
}
export declare namespace DeleteSpotDatafeedSubscriptionRequest {
    
    const filterSensitiveLog: (obj: DeleteSpotDatafeedSubscriptionRequest) => any;
}
export interface DeleteSubnetRequest {
    
    SubnetId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteSubnetRequest {
    
    const filterSensitiveLog: (obj: DeleteSubnetRequest) => any;
}
export interface DeleteSubnetCidrReservationRequest {
    
    SubnetCidrReservationId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteSubnetCidrReservationRequest {
    
    const filterSensitiveLog: (obj: DeleteSubnetCidrReservationRequest) => any;
}
export interface DeleteSubnetCidrReservationResult {
    
    DeletedSubnetCidrReservation?: SubnetCidrReservation;
}
export declare namespace DeleteSubnetCidrReservationResult {
    
    const filterSensitiveLog: (obj: DeleteSubnetCidrReservationResult) => any;
}
export interface DeleteTagsRequest {
    
    DryRun?: boolean;
    
    Resources: string[] | undefined;
    
    Tags?: Tag[];
}
export declare namespace DeleteTagsRequest {
    
    const filterSensitiveLog: (obj: DeleteTagsRequest) => any;
}
export interface DeleteTrafficMirrorFilterRequest {
    
    TrafficMirrorFilterId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorFilterRequest {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterRequest) => any;
}
export interface DeleteTrafficMirrorFilterResult {
    
    TrafficMirrorFilterId?: string;
}
export declare namespace DeleteTrafficMirrorFilterResult {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterResult) => any;
}
export interface DeleteTrafficMirrorFilterRuleRequest {
    
    TrafficMirrorFilterRuleId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorFilterRuleRequest {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterRuleRequest) => any;
}
export interface DeleteTrafficMirrorFilterRuleResult {
    
    TrafficMirrorFilterRuleId?: string;
}
export declare namespace DeleteTrafficMirrorFilterRuleResult {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterRuleResult) => any;
}
export interface DeleteTrafficMirrorSessionRequest {
    
    TrafficMirrorSessionId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorSessionRequest {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorSessionRequest) => any;
}
export interface DeleteTrafficMirrorSessionResult {
    
    TrafficMirrorSessionId?: string;
}
export declare namespace DeleteTrafficMirrorSessionResult {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorSessionResult) => any;
}
export interface DeleteTrafficMirrorTargetRequest {
    
    TrafficMirrorTargetId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorTargetRequest {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorTargetRequest) => any;
}
export interface DeleteTrafficMirrorTargetResult {
    
    TrafficMirrorTargetId?: string;
}
export declare namespace DeleteTrafficMirrorTargetResult {
    
    const filterSensitiveLog: (obj: DeleteTrafficMirrorTargetResult) => any;
}
export interface DeleteTransitGatewayRequest {
    
    TransitGatewayId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayRequest) => any;
}
export interface DeleteTransitGatewayResult {
    
    TransitGateway?: TransitGateway;
}
export declare namespace DeleteTransitGatewayResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayResult) => any;
}
export interface DeleteTransitGatewayConnectRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayConnectRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectRequest) => any;
}
export interface DeleteTransitGatewayConnectResult {
    
    TransitGatewayConnect?: TransitGatewayConnect;
}
export declare namespace DeleteTransitGatewayConnectResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectResult) => any;
}
export interface DeleteTransitGatewayConnectPeerRequest {
    
    TransitGatewayConnectPeerId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayConnectPeerRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectPeerRequest) => any;
}
export interface DeleteTransitGatewayConnectPeerResult {
    
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export declare namespace DeleteTransitGatewayConnectPeerResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectPeerResult) => any;
}
export interface DeleteTransitGatewayMulticastDomainRequest {
    
    TransitGatewayMulticastDomainId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayMulticastDomainRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayMulticastDomainRequest) => any;
}
export interface DeleteTransitGatewayMulticastDomainResult {
    
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export declare namespace DeleteTransitGatewayMulticastDomainResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayMulticastDomainResult) => any;
}
export interface DeleteTransitGatewayPeeringAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayPeeringAttachmentRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayPeeringAttachmentRequest) => any;
}
export interface DeleteTransitGatewayPeeringAttachmentResult {
    
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace DeleteTransitGatewayPeeringAttachmentResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayPeeringAttachmentResult) => any;
}
export interface DeleteTransitGatewayPrefixListReferenceRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    PrefixListId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayPrefixListReferenceRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayPrefixListReferenceRequest) => any;
}
export interface DeleteTransitGatewayPrefixListReferenceResult {
    
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export declare namespace DeleteTransitGatewayPrefixListReferenceResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayPrefixListReferenceResult) => any;
}
export interface DeleteTransitGatewayRouteRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    DestinationCidrBlock: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayRouteRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteRequest) => any;
}
export interface DeleteTransitGatewayRouteResult {
    
    Route?: TransitGatewayRoute;
}
export declare namespace DeleteTransitGatewayRouteResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteResult) => any;
}
export interface DeleteTransitGatewayRouteTableRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayRouteTableRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteTableRequest) => any;
}
export interface DeleteTransitGatewayRouteTableResult {
    
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export declare namespace DeleteTransitGatewayRouteTableResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteTableResult) => any;
}
export interface DeleteTransitGatewayVpcAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayVpcAttachmentRequest {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayVpcAttachmentRequest) => any;
}
export interface DeleteTransitGatewayVpcAttachmentResult {
    
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace DeleteTransitGatewayVpcAttachmentResult {
    
    const filterSensitiveLog: (obj: DeleteTransitGatewayVpcAttachmentResult) => any;
}
export interface DeleteVolumeRequest {
    
    VolumeId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteVolumeRequest {
    
    const filterSensitiveLog: (obj: DeleteVolumeRequest) => any;
}
export interface DeleteVpcRequest {
    
    VpcId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteVpcRequest {
    
    const filterSensitiveLog: (obj: DeleteVpcRequest) => any;
}
export interface DeleteVpcEndpointConnectionNotificationsRequest {
    
    DryRun?: boolean;
    
    ConnectionNotificationIds: string[] | undefined;
}
export declare namespace DeleteVpcEndpointConnectionNotificationsRequest {
    
    const filterSensitiveLog: (obj: DeleteVpcEndpointConnectionNotificationsRequest) => any;
}
export interface DeleteVpcEndpointConnectionNotificationsResult {
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteVpcEndpointConnectionNotificationsResult {
    
    const filterSensitiveLog: (obj: DeleteVpcEndpointConnectionNotificationsResult) => any;
}

export interface DeleteVpcEndpointsRequest {
    
    DryRun?: boolean;
    
    VpcEndpointIds: string[] | undefined;
}
export declare namespace DeleteVpcEndpointsRequest {
    
    const filterSensitiveLog: (obj: DeleteVpcEndpointsRequest) => any;
}

export interface DeleteVpcEndpointsResult {
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteVpcEndpointsResult {
    
    const filterSensitiveLog: (obj: DeleteVpcEndpointsResult) => any;
}
export interface DeleteVpcEndpointServiceConfigurationsRequest {
    
    DryRun?: boolean;
    
    ServiceIds: string[] | undefined;
}
export declare namespace DeleteVpcEndpointServiceConfigurationsRequest {
    
    const filterSensitiveLog: (obj: DeleteVpcEndpointServiceConfigurationsRequest) => any;
}
export interface DeleteVpcEndpointServiceConfigurationsResult {
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteVpcEndpointServiceConfigurationsResult {
    
    const filterSensitiveLog: (obj: DeleteVpcEndpointServiceConfigurationsResult) => any;
}
export interface DeleteVpcPeeringConnectionRequest {
    
    DryRun?: boolean;
    
    VpcPeeringConnectionId: string | undefined;
}
export declare namespace DeleteVpcPeeringConnectionRequest {
    
    const filterSensitiveLog: (obj: DeleteVpcPeeringConnectionRequest) => any;
}
export interface DeleteVpcPeeringConnectionResult {
    
    Return?: boolean;
}
export declare namespace DeleteVpcPeeringConnectionResult {
    
    const filterSensitiveLog: (obj: DeleteVpcPeeringConnectionResult) => any;
}

export interface DeleteVpnConnectionRequest {
    
    VpnConnectionId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteVpnConnectionRequest {
    
    const filterSensitiveLog: (obj: DeleteVpnConnectionRequest) => any;
}

export interface DeleteVpnConnectionRouteRequest {
    
    DestinationCidrBlock: string | undefined;
    
    VpnConnectionId: string | undefined;
}
export declare namespace DeleteVpnConnectionRouteRequest {
    
    const filterSensitiveLog: (obj: DeleteVpnConnectionRouteRequest) => any;
}

export interface DeleteVpnGatewayRequest {
    
    VpnGatewayId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeleteVpnGatewayRequest {
    
    const filterSensitiveLog: (obj: DeleteVpnGatewayRequest) => any;
}
export interface DeprovisionByoipCidrRequest {
    
    Cidr: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeprovisionByoipCidrRequest {
    
    const filterSensitiveLog: (obj: DeprovisionByoipCidrRequest) => any;
}
export interface DeprovisionByoipCidrResult {
    
    ByoipCidr?: ByoipCidr;
}
export declare namespace DeprovisionByoipCidrResult {
    
    const filterSensitiveLog: (obj: DeprovisionByoipCidrResult) => any;
}
export interface DeprovisionIpamPoolCidrRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    Cidr?: string;
}
export declare namespace DeprovisionIpamPoolCidrRequest {
    
    const filterSensitiveLog: (obj: DeprovisionIpamPoolCidrRequest) => any;
}
export declare enum IpamPoolCidrFailureCode {
    cidr_not_available = "cidr-not-available"
}

export interface IpamPoolCidrFailureReason {
    
    Code?: IpamPoolCidrFailureCode | string;
    
    Message?: string;
}
export declare namespace IpamPoolCidrFailureReason {
    
    const filterSensitiveLog: (obj: IpamPoolCidrFailureReason) => any;
}
export declare enum IpamPoolCidrState {
    deprovisioned = "deprovisioned",
    failed_deprovision = "failed-deprovision",
    failed_import = "failed-import",
    failed_provision = "failed-provision",
    pending_deprovision = "pending-deprovision",
    pending_import = "pending-import",
    pending_provision = "pending-provision",
    provisioned = "provisioned"
}

export interface IpamPoolCidr {
    
    Cidr?: string;
    
    State?: IpamPoolCidrState | string;
    
    FailureReason?: IpamPoolCidrFailureReason;
}
export declare namespace IpamPoolCidr {
    
    const filterSensitiveLog: (obj: IpamPoolCidr) => any;
}
export interface DeprovisionIpamPoolCidrResult {
    
    IpamPoolCidr?: IpamPoolCidr;
}
export declare namespace DeprovisionIpamPoolCidrResult {
    
    const filterSensitiveLog: (obj: DeprovisionIpamPoolCidrResult) => any;
}
export interface DeprovisionPublicIpv4PoolCidrRequest {
    
    DryRun?: boolean;
    
    PoolId: string | undefined;
    
    Cidr: string | undefined;
}
export declare namespace DeprovisionPublicIpv4PoolCidrRequest {
    
    const filterSensitiveLog: (obj: DeprovisionPublicIpv4PoolCidrRequest) => any;
}
export interface DeprovisionPublicIpv4PoolCidrResult {
    
    PoolId?: string;
    
    DeprovisionedAddresses?: string[];
}
export declare namespace DeprovisionPublicIpv4PoolCidrResult {
    
    const filterSensitiveLog: (obj: DeprovisionPublicIpv4PoolCidrResult) => any;
}

export interface DeregisterImageRequest {
    
    ImageId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace DeregisterImageRequest {
    
    const filterSensitiveLog: (obj: DeregisterImageRequest) => any;
}

export interface DeregisterInstanceTagAttributeRequest {
    
    IncludeAllTagsOfInstance?: boolean;
    
    InstanceTagKeys?: string[];
}
export declare namespace DeregisterInstanceTagAttributeRequest {
    
    const filterSensitiveLog: (obj: DeregisterInstanceTagAttributeRequest) => any;
}
export interface DeregisterInstanceEventNotificationAttributesRequest {
    
    DryRun?: boolean;
    
    InstanceTagAttribute?: DeregisterInstanceTagAttributeRequest;
}
export declare namespace DeregisterInstanceEventNotificationAttributesRequest {
    
    const filterSensitiveLog: (obj: DeregisterInstanceEventNotificationAttributesRequest) => any;
}

export interface InstanceTagNotificationAttribute {
    
    InstanceTagKeys?: string[];
    
    IncludeAllTagsOfInstance?: boolean;
}
export declare namespace InstanceTagNotificationAttribute {
    
    const filterSensitiveLog: (obj: InstanceTagNotificationAttribute) => any;
}
export interface DeregisterInstanceEventNotificationAttributesResult {
    
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export declare namespace DeregisterInstanceEventNotificationAttributesResult {
    
    const filterSensitiveLog: (obj: DeregisterInstanceEventNotificationAttributesResult) => any;
}
export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    GroupIpAddress?: string;
    
    NetworkInterfaceIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DeregisterTransitGatewayMulticastGroupMembersRequest {
    
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupMembersRequest) => any;
}

export interface TransitGatewayMulticastDeregisteredGroupMembers {
    
    TransitGatewayMulticastDomainId?: string;
    
    DeregisteredNetworkInterfaceIds?: string[];
    
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastDeregisteredGroupMembers {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastDeregisteredGroupMembers) => any;
}
export interface DeregisterTransitGatewayMulticastGroupMembersResult {
    
    DeregisteredMulticastGroupMembers?: TransitGatewayMulticastDeregisteredGroupMembers;
}
export declare namespace DeregisterTransitGatewayMulticastGroupMembersResult {
    
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupMembersResult) => any;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    GroupIpAddress?: string;
    
    NetworkInterfaceIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DeregisterTransitGatewayMulticastGroupSourcesRequest {
    
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupSourcesRequest) => any;
}

export interface TransitGatewayMulticastDeregisteredGroupSources {
    
    TransitGatewayMulticastDomainId?: string;
    
    DeregisteredNetworkInterfaceIds?: string[];
    
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastDeregisteredGroupSources {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastDeregisteredGroupSources) => any;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
    
    DeregisteredMulticastGroupSources?: TransitGatewayMulticastDeregisteredGroupSources;
}
export declare namespace DeregisterTransitGatewayMulticastGroupSourcesResult {
    
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupSourcesResult) => any;
}
export interface DescribeAccountAttributesRequest {
    
    AttributeNames?: (AccountAttributeName | string)[];
    
    DryRun?: boolean;
}
export declare namespace DescribeAccountAttributesRequest {
    
    const filterSensitiveLog: (obj: DescribeAccountAttributesRequest) => any;
}
export interface DescribeAccountAttributesResult {
    
    AccountAttributes?: AccountAttribute[];
}
export declare namespace DescribeAccountAttributesResult {
    
    const filterSensitiveLog: (obj: DescribeAccountAttributesResult) => any;
}

export interface Filter {
    
    Name?: string;
    
    Values?: string[];
}
export declare namespace Filter {
    
    const filterSensitiveLog: (obj: Filter) => any;
}
export interface DescribeAddressesRequest {
    
    Filters?: Filter[];
    
    PublicIps?: string[];
    
    AllocationIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeAddressesRequest {
    
    const filterSensitiveLog: (obj: DescribeAddressesRequest) => any;
}
export interface DescribeAddressesResult {
    
    Addresses?: Address[];
}
export declare namespace DescribeAddressesResult {
    
    const filterSensitiveLog: (obj: DescribeAddressesResult) => any;
}
export interface DescribeAddressesAttributeRequest {
    
    AllocationIds?: string[];
    
    Attribute?: AddressAttributeName | string;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    DryRun?: boolean;
}
export declare namespace DescribeAddressesAttributeRequest {
    
    const filterSensitiveLog: (obj: DescribeAddressesAttributeRequest) => any;
}
export interface DescribeAddressesAttributeResult {
    
    Addresses?: AddressAttribute[];
    
    NextToken?: string;
}
export declare namespace DescribeAddressesAttributeResult {
    
    const filterSensitiveLog: (obj: DescribeAddressesAttributeResult) => any;
}
export interface DescribeAggregateIdFormatRequest {
    
    DryRun?: boolean;
}
export declare namespace DescribeAggregateIdFormatRequest {
    
    const filterSensitiveLog: (obj: DescribeAggregateIdFormatRequest) => any;
}

export interface IdFormat {
    
    Deadline?: Date;
    
    Resource?: string;
    
    UseLongIds?: boolean;
}
export declare namespace IdFormat {
    
    const filterSensitiveLog: (obj: IdFormat) => any;
}
export interface DescribeAggregateIdFormatResult {
    
    UseLongIdsAggregated?: boolean;
    
    Statuses?: IdFormat[];
}
export declare namespace DescribeAggregateIdFormatResult {
    
    const filterSensitiveLog: (obj: DescribeAggregateIdFormatResult) => any;
}
export interface DescribeAvailabilityZonesRequest {
    
    Filters?: Filter[];
    
    ZoneNames?: string[];
    
    ZoneIds?: string[];
    
    AllAvailabilityZones?: boolean;
    
    DryRun?: boolean;
}
export declare namespace DescribeAvailabilityZonesRequest {
    
    const filterSensitiveLog: (obj: DescribeAvailabilityZonesRequest) => any;
}

export interface AvailabilityZoneMessage {
    
    Message?: string;
}
export declare namespace AvailabilityZoneMessage {
    
    const filterSensitiveLog: (obj: AvailabilityZoneMessage) => any;
}
export declare type AvailabilityZoneOptInStatus = "not-opted-in" | "opt-in-not-required" | "opted-in";
export declare type AvailabilityZoneState = "available" | "impaired" | "information" | "unavailable";

export interface AvailabilityZone {
    
    State?: AvailabilityZoneState | string;
    
    OptInStatus?: AvailabilityZoneOptInStatus | string;
    
    Messages?: AvailabilityZoneMessage[];
    
    RegionName?: string;
    
    ZoneName?: string;
    
    ZoneId?: string;
    
    GroupName?: string;
    
    NetworkBorderGroup?: string;
    
    ZoneType?: string;
    
    ParentZoneName?: string;
    
    ParentZoneId?: string;
}
export declare namespace AvailabilityZone {
    
    const filterSensitiveLog: (obj: AvailabilityZone) => any;
}
export interface DescribeAvailabilityZonesResult {
    
    AvailabilityZones?: AvailabilityZone[];
}
export declare namespace DescribeAvailabilityZonesResult {
    
    const filterSensitiveLog: (obj: DescribeAvailabilityZonesResult) => any;
}
export interface DescribeBundleTasksRequest {
    
    BundleIds?: string[];
    
    Filters?: Filter[];
    
    DryRun?: boolean;
}
export declare namespace DescribeBundleTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeBundleTasksRequest) => any;
}
export interface DescribeBundleTasksResult {
    
    BundleTasks?: BundleTask[];
}
export declare namespace DescribeBundleTasksResult {
    
    const filterSensitiveLog: (obj: DescribeBundleTasksResult) => any;
}
export interface DescribeByoipCidrsRequest {
    
    DryRun?: boolean;
    
    MaxResults: number | undefined;
    
    NextToken?: string;
}
export declare namespace DescribeByoipCidrsRequest {
    
    const filterSensitiveLog: (obj: DescribeByoipCidrsRequest) => any;
}
export interface DescribeByoipCidrsResult {
    
    ByoipCidrs?: ByoipCidr[];
    
    NextToken?: string;
}
export declare namespace DescribeByoipCidrsResult {
    
    const filterSensitiveLog: (obj: DescribeByoipCidrsResult) => any;
}
export interface DescribeCapacityReservationFleetsRequest {
    
    CapacityReservationFleetIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    Filters?: Filter[];
    
    DryRun?: boolean;
}
export declare namespace DescribeCapacityReservationFleetsRequest {
    
    const filterSensitiveLog: (obj: DescribeCapacityReservationFleetsRequest) => any;
}

export interface CapacityReservationFleet {
    
    CapacityReservationFleetId?: string;
    
    CapacityReservationFleetArn?: string;
    
    State?: CapacityReservationFleetState | string;
    
    TotalTargetCapacity?: number;
    
    TotalFulfilledCapacity?: number;
    
    Tenancy?: FleetCapacityReservationTenancy | string;
    
    EndDate?: Date;
    
    CreateTime?: Date;
    
    InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
    
    AllocationStrategy?: string;
    
    InstanceTypeSpecifications?: FleetCapacityReservation[];
    
    Tags?: Tag[];
}
export declare namespace CapacityReservationFleet {
    
    const filterSensitiveLog: (obj: CapacityReservationFleet) => any;
}
export interface DescribeCapacityReservationFleetsResult {
    
    CapacityReservationFleets?: CapacityReservationFleet[];
    
    NextToken?: string;
}
export declare namespace DescribeCapacityReservationFleetsResult {
    
    const filterSensitiveLog: (obj: DescribeCapacityReservationFleetsResult) => any;
}
export interface DescribeCapacityReservationsRequest {
    
    CapacityReservationIds?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    Filters?: Filter[];
    
    DryRun?: boolean;
}
export declare namespace DescribeCapacityReservationsRequest {
    
    const filterSensitiveLog: (obj: DescribeCapacityReservationsRequest) => any;
}
export interface DescribeCapacityReservationsResult {
    
    NextToken?: string;
    
    CapacityReservations?: CapacityReservation[];
}
export declare namespace DescribeCapacityReservationsResult {
    
    const filterSensitiveLog: (obj: DescribeCapacityReservationsResult) => any;
}
export interface DescribeCarrierGatewaysRequest {
    
    CarrierGatewayIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeCarrierGatewaysRequest {
    
    const filterSensitiveLog: (obj: DescribeCarrierGatewaysRequest) => any;
}
export interface DescribeCarrierGatewaysResult {
    
    CarrierGateways?: CarrierGateway[];
    
    NextToken?: string;
}
export declare namespace DescribeCarrierGatewaysResult {
    
    const filterSensitiveLog: (obj: DescribeCarrierGatewaysResult) => any;
}
export interface DescribeClassicLinkInstancesRequest {
    
    Filters?: Filter[];
    
    DryRun?: boolean;
    
    InstanceIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeClassicLinkInstancesRequest {
    
    const filterSensitiveLog: (obj: DescribeClassicLinkInstancesRequest) => any;
}

export interface ClassicLinkInstance {
    
    Groups?: GroupIdentifier[];
    
    InstanceId?: string;
    
    Tags?: Tag[];
    
    VpcId?: string;
}
export declare namespace ClassicLinkInstance {
    
    const filterSensitiveLog: (obj: ClassicLinkInstance) => any;
}
export interface DescribeClassicLinkInstancesResult {
    
    Instances?: ClassicLinkInstance[];
    
    NextToken?: string;
}
export declare namespace DescribeClassicLinkInstancesResult {
    
    const filterSensitiveLog: (obj: DescribeClassicLinkInstancesResult) => any;
}
export interface DescribeClientVpnAuthorizationRulesRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    DryRun?: boolean;
    
    NextToken?: string;
    
    Filters?: Filter[];
    
    MaxResults?: number;
}
export declare namespace DescribeClientVpnAuthorizationRulesRequest {
    
    const filterSensitiveLog: (obj: DescribeClientVpnAuthorizationRulesRequest) => any;
}

export interface AuthorizationRule {
    
    ClientVpnEndpointId?: string;
    
    Description?: string;
    
    GroupId?: string;
    
    AccessAll?: boolean;
    
    DestinationCidr?: string;
    
    Status?: ClientVpnAuthorizationRuleStatus;
}
export declare namespace AuthorizationRule {
    
    const filterSensitiveLog: (obj: AuthorizationRule) => any;
}
export interface DescribeClientVpnAuthorizationRulesResult {
    
    AuthorizationRules?: AuthorizationRule[];
    
    NextToken?: string;
}
export declare namespace DescribeClientVpnAuthorizationRulesResult {
    
    const filterSensitiveLog: (obj: DescribeClientVpnAuthorizationRulesResult) => any;
}
export interface DescribeClientVpnConnectionsRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    Filters?: Filter[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnConnectionsRequest {
    
    const filterSensitiveLog: (obj: DescribeClientVpnConnectionsRequest) => any;
}
export declare type ClientVpnConnectionStatusCode = "active" | "failed-to-terminate" | "terminated" | "terminating";

export interface ClientVpnConnectionStatus {
    
    Code?: ClientVpnConnectionStatusCode | string;
    
    Message?: string;
}
export declare namespace ClientVpnConnectionStatus {
    
    const filterSensitiveLog: (obj: ClientVpnConnectionStatus) => any;
}

export interface ClientVpnConnection {
    
    ClientVpnEndpointId?: string;
    
    Timestamp?: string;
    
    ConnectionId?: string;
    
    Username?: string;
    
    ConnectionEstablishedTime?: string;
    
    IngressBytes?: string;
    
    EgressBytes?: string;
    
    IngressPackets?: string;
    
    EgressPackets?: string;
    
    ClientIp?: string;
    
    CommonName?: string;
    
    Status?: ClientVpnConnectionStatus;
    
    ConnectionEndTime?: string;
    
    PostureComplianceStatuses?: string[];
}
export declare namespace ClientVpnConnection {
    
    const filterSensitiveLog: (obj: ClientVpnConnection) => any;
}
export interface DescribeClientVpnConnectionsResult {
    
    Connections?: ClientVpnConnection[];
    
    NextToken?: string;
}
export declare namespace DescribeClientVpnConnectionsResult {
    
    const filterSensitiveLog: (obj: DescribeClientVpnConnectionsResult) => any;
}
export interface DescribeClientVpnEndpointsRequest {
    
    ClientVpnEndpointIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: Filter[];
    
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnEndpointsRequest {
    
    const filterSensitiveLog: (obj: DescribeClientVpnEndpointsRequest) => any;
}
export declare type AssociatedNetworkType = "vpc";

export interface AssociatedTargetNetwork {
    
    NetworkId?: string;
    
    NetworkType?: AssociatedNetworkType | string;
}
export declare namespace AssociatedTargetNetwork {
    
    const filterSensitiveLog: (obj: AssociatedTargetNetwork) => any;
}

export interface DirectoryServiceAuthentication {
    
    DirectoryId?: string;
}
export declare namespace DirectoryServiceAuthentication {
    
    const filterSensitiveLog: (obj: DirectoryServiceAuthentication) => any;
}

export interface FederatedAuthentication {
    
    SamlProviderArn?: string;
    
    SelfServiceSamlProviderArn?: string;
}
export declare namespace FederatedAuthentication {
    
    const filterSensitiveLog: (obj: FederatedAuthentication) => any;
}

export interface CertificateAuthentication {
    
    ClientRootCertificateChain?: string;
}
export declare namespace CertificateAuthentication {
    
    const filterSensitiveLog: (obj: CertificateAuthentication) => any;
}

export interface ClientVpnAuthentication {
    
    Type?: ClientVpnAuthenticationType | string;
    
    ActiveDirectory?: DirectoryServiceAuthentication;
    
    MutualAuthentication?: CertificateAuthentication;
    
    FederatedAuthentication?: FederatedAuthentication;
}
export declare namespace ClientVpnAuthentication {
    
    const filterSensitiveLog: (obj: ClientVpnAuthentication) => any;
}
export declare type ClientVpnEndpointAttributeStatusCode = "applied" | "applying";

export interface ClientVpnEndpointAttributeStatus {
    
    Code?: ClientVpnEndpointAttributeStatusCode | string;
    
    Message?: string;
}
export declare namespace ClientVpnEndpointAttributeStatus {
    
    const filterSensitiveLog: (obj: ClientVpnEndpointAttributeStatus) => any;
}

export interface ClientConnectResponseOptions {
    
    Enabled?: boolean;
    
    LambdaFunctionArn?: string;
    
    Status?: ClientVpnEndpointAttributeStatus;
}
export declare namespace ClientConnectResponseOptions {
    
    const filterSensitiveLog: (obj: ClientConnectResponseOptions) => any;
}

export interface ConnectionLogResponseOptions {
    
    Enabled?: boolean;
    
    CloudwatchLogGroup?: string;
    
    CloudwatchLogStream?: string;
}
export declare namespace ConnectionLogResponseOptions {
    
    const filterSensitiveLog: (obj: ConnectionLogResponseOptions) => any;
}
export declare type VpnProtocol = "openvpn";

export interface ClientVpnEndpoint {
    
    ClientVpnEndpointId?: string;
    
    Description?: string;
    
    Status?: ClientVpnEndpointStatus;
    
    CreationTime?: string;
    
    DeletionTime?: string;
    
    DnsName?: string;
    
    ClientCidrBlock?: string;
    
    DnsServers?: string[];
    
    SplitTunnel?: boolean;
    
    VpnProtocol?: VpnProtocol | string;
    
    TransportProtocol?: TransportProtocol | string;
    
    VpnPort?: number;
    
    AssociatedTargetNetworks?: AssociatedTargetNetwork[];
    
    ServerCertificateArn?: string;
    
    AuthenticationOptions?: ClientVpnAuthentication[];
    
    ConnectionLogOptions?: ConnectionLogResponseOptions;
    
    Tags?: Tag[];
    
    SecurityGroupIds?: string[];
    
    VpcId?: string;
    
    SelfServicePortalUrl?: string;
    
    ClientConnectOptions?: ClientConnectResponseOptions;
}
export declare namespace ClientVpnEndpoint {
    
    const filterSensitiveLog: (obj: ClientVpnEndpoint) => any;
}
export interface DescribeClientVpnEndpointsResult {
    
    ClientVpnEndpoints?: ClientVpnEndpoint[];
    
    NextToken?: string;
}
export declare namespace DescribeClientVpnEndpointsResult {
    
    const filterSensitiveLog: (obj: DescribeClientVpnEndpointsResult) => any;
}
export interface DescribeClientVpnRoutesRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnRoutesRequest {
    
    const filterSensitiveLog: (obj: DescribeClientVpnRoutesRequest) => any;
}

export interface ClientVpnRoute {
    
    ClientVpnEndpointId?: string;
    
    DestinationCidr?: string;
    
    TargetSubnet?: string;
    
    Type?: string;
    
    Origin?: string;
    
    Status?: ClientVpnRouteStatus;
    
    Description?: string;
}
export declare namespace ClientVpnRoute {
    
    const filterSensitiveLog: (obj: ClientVpnRoute) => any;
}
export interface DescribeClientVpnRoutesResult {
    
    Routes?: ClientVpnRoute[];
    
    NextToken?: string;
}
export declare namespace DescribeClientVpnRoutesResult {
    
    const filterSensitiveLog: (obj: DescribeClientVpnRoutesResult) => any;
}
export interface DescribeClientVpnTargetNetworksRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    AssociationIds?: string[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: Filter[];
    
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnTargetNetworksRequest {
    
    const filterSensitiveLog: (obj: DescribeClientVpnTargetNetworksRequest) => any;
}

export interface TargetNetwork {
    
    AssociationId?: string;
    
    VpcId?: string;
    
    TargetNetworkId?: string;
    
    ClientVpnEndpointId?: string;
    
    Status?: AssociationStatus;
    
    SecurityGroups?: string[];
}
export declare namespace TargetNetwork {
    
    const filterSensitiveLog: (obj: TargetNetwork) => any;
}
export interface DescribeClientVpnTargetNetworksResult {
    
    ClientVpnTargetNetworks?: TargetNetwork[];
    
    NextToken?: string;
}
export declare namespace DescribeClientVpnTargetNetworksResult {
    
    const filterSensitiveLog: (obj: DescribeClientVpnTargetNetworksResult) => any;
}
export interface DescribeCoipPoolsRequest {
    
    PoolIds?: string[];
    
    Filters?: Filter[];
    
    MaxResults?: number;
    
    NextToken?: string;
    
    DryRun?: boolean;
}
export declare namespace DescribeCoipPoolsRequest {
    
    const filterSensitiveLog: (obj: DescribeCoipPoolsRequest) => any;
}

export interface CoipPool {
    
    PoolId?: string;
    
    PoolCidrs?: string[];
    
    LocalGatewayRouteTableId?: string;
    
    Tags?: Tag[];
    
    PoolArn?: string;
}
export declare namespace CoipPool {
    
    const filterSensitiveLog: (obj: CoipPool) => any;
}
export interface DescribeCoipPoolsResult {
    
    CoipPools?: CoipPool[];
    
    NextToken?: string;
}
export declare namespace DescribeCoipPoolsResult {
    
    const filterSensitiveLog: (obj: DescribeCoipPoolsResult) => any;
}
export interface DescribeConversionTasksRequest {
    
    ConversionTaskIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace DescribeConversionTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeConversionTasksRequest) => any;
}

export interface DiskImageDescription {
    
    Checksum?: string;
    
    Format?: DiskImageFormat | string;
    
    ImportManifestUrl?: string;
    
    Size?: number;
}
export declare namespace DiskImageDescription {
    
    const filterSensitiveLog: (obj: DiskImageDescription) => any;
}

export interface DiskImageVolumeDescription {
    
    Id?: string;
    
    Size?: number;
}
export declare namespace DiskImageVolumeDescription {
    
    const filterSensitiveLog: (obj: DiskImageVolumeDescription) => any;
}

export interface ImportInstanceVolumeDetailItem {
    
    AvailabilityZone?: string;
    
    BytesConverted?: number;
    
    Description?: string;
    
    Image?: DiskImageDescription;
    
    Status?: string;
    
    StatusMessage?: string;
    
    Volume?: DiskImageVolumeDescription;
}
export declare namespace ImportInstanceVolumeDetailItem {
    
    const filterSensitiveLog: (obj: ImportInstanceVolumeDetailItem) => any;
}

export interface ImportInstanceTaskDetails {
    
    Description?: string;
    
    InstanceId?: string;
    
    Platform?: PlatformValues | string;
    
    Volumes?: ImportInstanceVolumeDetailItem[];
}
export declare namespace ImportInstanceTaskDetails {
    
    const filterSensitiveLog: (obj: ImportInstanceTaskDetails) => any;
}

export interface ImportVolumeTaskDetails {
    
    AvailabilityZone?: string;
    
    BytesConverted?: number;
    
    Description?: string;
    
    Image?: DiskImageDescription;
    
    Volume?: DiskImageVolumeDescription;
}
export declare namespace ImportVolumeTaskDetails {
    
    const filterSensitiveLog: (obj: ImportVolumeTaskDetails) => any;
}
export declare type ConversionTaskState = "active" | "cancelled" | "cancelling" | "completed";
