
export interface AcceleratorCount {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace AcceleratorCount {
    
    const filterSensitiveLog: (obj: AcceleratorCount) => any;
}

export interface AcceleratorCountRequest {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace AcceleratorCountRequest {
    
    const filterSensitiveLog: (obj: AcceleratorCountRequest) => any;
}
export declare enum AcceleratorManufacturer {
    AMAZON_WEB_SERVICES = "amazon-web-services",
    AMD = "amd",
    NVIDIA = "nvidia",
    XILINX = "xilinx"
}
export declare enum AcceleratorName {
    A100 = "a100",
    K80 = "k80",
    M60 = "m60",
    RADEON_PRO_V520 = "radeon-pro-v520",
    T4 = "t4",
    V100 = "v100",
    VU9P = "vu9p"
}

export interface AcceleratorTotalMemoryMiB {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace AcceleratorTotalMemoryMiB {
    
    const filterSensitiveLog: (obj: AcceleratorTotalMemoryMiB) => any;
}

export interface AcceleratorTotalMemoryMiBRequest {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace AcceleratorTotalMemoryMiBRequest {
    
    const filterSensitiveLog: (obj: AcceleratorTotalMemoryMiBRequest) => any;
}
export declare enum AcceleratorType {
    FPGA = "fpga",
    GPU = "gpu",
    INFERENCE = "inference"
}

export interface TargetConfigurationRequest {
    
    InstanceCount?: number;
    
    OfferingId: string | undefined;
}
export declare namespace TargetConfigurationRequest {
    
    const filterSensitiveLog: (obj: TargetConfigurationRequest) => any;
}

export interface AcceptReservedInstancesExchangeQuoteRequest {
    
    DryRun?: boolean;
    
    ReservedInstanceIds: string[] | undefined;
    
    TargetConfigurations?: TargetConfigurationRequest[];
}
export declare namespace AcceptReservedInstancesExchangeQuoteRequest {
    
    const filterSensitiveLog: (obj: AcceptReservedInstancesExchangeQuoteRequest) => any;
}

export interface AcceptReservedInstancesExchangeQuoteResult {
    
    ExchangeId?: string;
}
export declare namespace AcceptReservedInstancesExchangeQuoteResult {
    
    const filterSensitiveLog: (obj: AcceptReservedInstancesExchangeQuoteResult) => any;
}
export interface AcceptTransitGatewayMulticastDomainAssociationsRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    SubnetIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace AcceptTransitGatewayMulticastDomainAssociationsRequest {
    
    const filterSensitiveLog: (obj: AcceptTransitGatewayMulticastDomainAssociationsRequest) => any;
}
export declare type TransitGatewayAttachmentResourceType = "connect" | "direct-connect-gateway" | "peering" | "tgw-peering" | "vpc" | "vpn";
export declare type TransitGatewayMulitcastDomainAssociationState = "associated" | "associating" | "disassociated" | "disassociating" | "failed" | "pendingAcceptance" | "rejected";

export interface SubnetAssociation {
    
    SubnetId?: string;
    
    State?: TransitGatewayMulitcastDomainAssociationState | string;
}
export declare namespace SubnetAssociation {
    
    const filterSensitiveLog: (obj: SubnetAssociation) => any;
}

export interface TransitGatewayMulticastDomainAssociations {
    
    TransitGatewayMulticastDomainId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    ResourceOwnerId?: string;
    
    Subnets?: SubnetAssociation[];
}
export declare namespace TransitGatewayMulticastDomainAssociations {
    
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomainAssociations) => any;
}
export interface AcceptTransitGatewayMulticastDomainAssociationsResult {
    
    Associations?: TransitGatewayMulticastDomainAssociations;
}
export declare namespace AcceptTransitGatewayMulticastDomainAssociationsResult {
    
    const filterSensitiveLog: (obj: AcceptTransitGatewayMulticastDomainAssociationsResult) => any;
}
export interface AcceptTransitGatewayPeeringAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AcceptTransitGatewayPeeringAttachmentRequest {
    
    const filterSensitiveLog: (obj: AcceptTransitGatewayPeeringAttachmentRequest) => any;
}

export interface PeeringTgwInfo {
    
    TransitGatewayId?: string;
    
    OwnerId?: string;
    
    Region?: string;
}
export declare namespace PeeringTgwInfo {
    
    const filterSensitiveLog: (obj: PeeringTgwInfo) => any;
}
export declare type TransitGatewayAttachmentState = "available" | "deleted" | "deleting" | "failed" | "failing" | "initiating" | "initiatingRequest" | "modifying" | "pending" | "pendingAcceptance" | "rejected" | "rejecting" | "rollingBack";

export interface PeeringAttachmentStatus {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace PeeringAttachmentStatus {
    
    const filterSensitiveLog: (obj: PeeringAttachmentStatus) => any;
}

export interface Tag {
    
    Key?: string;
    
    Value?: string;
}
export declare namespace Tag {
    
    const filterSensitiveLog: (obj: Tag) => any;
}

export interface TransitGatewayPeeringAttachment {
    
    TransitGatewayAttachmentId?: string;
    
    RequesterTgwInfo?: PeeringTgwInfo;
    
    AccepterTgwInfo?: PeeringTgwInfo;
    
    Status?: PeeringAttachmentStatus;
    
    State?: TransitGatewayAttachmentState | string;
    
    CreationTime?: Date;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayPeeringAttachment {
    
    const filterSensitiveLog: (obj: TransitGatewayPeeringAttachment) => any;
}
export interface AcceptTransitGatewayPeeringAttachmentResult {
    
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace AcceptTransitGatewayPeeringAttachmentResult {
    
    const filterSensitiveLog: (obj: AcceptTransitGatewayPeeringAttachmentResult) => any;
}
export interface AcceptTransitGatewayVpcAttachmentRequest {
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AcceptTransitGatewayVpcAttachmentRequest {
    
    const filterSensitiveLog: (obj: AcceptTransitGatewayVpcAttachmentRequest) => any;
}
export declare type ApplianceModeSupportValue = "disable" | "enable";
export declare type DnsSupportValue = "disable" | "enable";
export declare type Ipv6SupportValue = "disable" | "enable";

export interface TransitGatewayVpcAttachmentOptions {
    
    DnsSupport?: DnsSupportValue | string;
    
    Ipv6Support?: Ipv6SupportValue | string;
    
    ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export declare namespace TransitGatewayVpcAttachmentOptions {
    
    const filterSensitiveLog: (obj: TransitGatewayVpcAttachmentOptions) => any;
}

export interface TransitGatewayVpcAttachment {
    
    TransitGatewayAttachmentId?: string;
    
    TransitGatewayId?: string;
    
    VpcId?: string;
    
    VpcOwnerId?: string;
    
    State?: TransitGatewayAttachmentState | string;
    
    SubnetIds?: string[];
    
    CreationTime?: Date;
    
    Options?: TransitGatewayVpcAttachmentOptions;
    
    Tags?: Tag[];
}
export declare namespace TransitGatewayVpcAttachment {
    
    const filterSensitiveLog: (obj: TransitGatewayVpcAttachment) => any;
}
export interface AcceptTransitGatewayVpcAttachmentResult {
    
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace AcceptTransitGatewayVpcAttachmentResult {
    
    const filterSensitiveLog: (obj: AcceptTransitGatewayVpcAttachmentResult) => any;
}
export interface AcceptVpcEndpointConnectionsRequest {
    
    DryRun?: boolean;
    
    ServiceId: string | undefined;
    
    VpcEndpointIds: string[] | undefined;
}
export declare namespace AcceptVpcEndpointConnectionsRequest {
    
    const filterSensitiveLog: (obj: AcceptVpcEndpointConnectionsRequest) => any;
}

export interface UnsuccessfulItemError {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace UnsuccessfulItemError {
    
    const filterSensitiveLog: (obj: UnsuccessfulItemError) => any;
}

export interface UnsuccessfulItem {
    
    Error?: UnsuccessfulItemError;
    
    ResourceId?: string;
}
export declare namespace UnsuccessfulItem {
    
    const filterSensitiveLog: (obj: UnsuccessfulItem) => any;
}
export interface AcceptVpcEndpointConnectionsResult {
    
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace AcceptVpcEndpointConnectionsResult {
    
    const filterSensitiveLog: (obj: AcceptVpcEndpointConnectionsResult) => any;
}
export interface AcceptVpcPeeringConnectionRequest {
    
    DryRun?: boolean;
    
    VpcPeeringConnectionId?: string;
}
export declare namespace AcceptVpcPeeringConnectionRequest {
    
    const filterSensitiveLog: (obj: AcceptVpcPeeringConnectionRequest) => any;
}

export interface CidrBlock {
    
    CidrBlock?: string;
}
export declare namespace CidrBlock {
    
    const filterSensitiveLog: (obj: CidrBlock) => any;
}

export interface Ipv6CidrBlock {
    
    Ipv6CidrBlock?: string;
}
export declare namespace Ipv6CidrBlock {
    
    const filterSensitiveLog: (obj: Ipv6CidrBlock) => any;
}

export interface VpcPeeringConnectionOptionsDescription {
    
    AllowDnsResolutionFromRemoteVpc?: boolean;
    
    AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean;
    
    AllowEgressFromLocalVpcToRemoteClassicLink?: boolean;
}
export declare namespace VpcPeeringConnectionOptionsDescription {
    
    const filterSensitiveLog: (obj: VpcPeeringConnectionOptionsDescription) => any;
}

export interface VpcPeeringConnectionVpcInfo {
    
    CidrBlock?: string;
    
    Ipv6CidrBlockSet?: Ipv6CidrBlock[];
    
    CidrBlockSet?: CidrBlock[];
    
    OwnerId?: string;
    
    PeeringOptions?: VpcPeeringConnectionOptionsDescription;
    
    VpcId?: string;
    
    Region?: string;
}
export declare namespace VpcPeeringConnectionVpcInfo {
    
    const filterSensitiveLog: (obj: VpcPeeringConnectionVpcInfo) => any;
}
export declare type VpcPeeringConnectionStateReasonCode = "active" | "deleted" | "deleting" | "expired" | "failed" | "initiating-request" | "pending-acceptance" | "provisioning" | "rejected";

export interface VpcPeeringConnectionStateReason {
    
    Code?: VpcPeeringConnectionStateReasonCode | string;
    
    Message?: string;
}
export declare namespace VpcPeeringConnectionStateReason {
    
    const filterSensitiveLog: (obj: VpcPeeringConnectionStateReason) => any;
}

export interface VpcPeeringConnection {
    
    AccepterVpcInfo?: VpcPeeringConnectionVpcInfo;
    
    ExpirationTime?: Date;
    
    RequesterVpcInfo?: VpcPeeringConnectionVpcInfo;
    
    Status?: VpcPeeringConnectionStateReason;
    
    Tags?: Tag[];
    
    VpcPeeringConnectionId?: string;
}
export declare namespace VpcPeeringConnection {
    
    const filterSensitiveLog: (obj: VpcPeeringConnection) => any;
}
export interface AcceptVpcPeeringConnectionResult {
    
    VpcPeeringConnection?: VpcPeeringConnection;
}
export declare namespace AcceptVpcPeeringConnectionResult {
    
    const filterSensitiveLog: (obj: AcceptVpcPeeringConnectionResult) => any;
}

export interface PortRange {
    
    From?: number;
    
    To?: number;
}
export declare namespace PortRange {
    
    const filterSensitiveLog: (obj: PortRange) => any;
}

export interface AnalysisAclRule {
    
    Cidr?: string;
    
    Egress?: boolean;
    
    PortRange?: PortRange;
    
    Protocol?: string;
    
    RuleAction?: string;
    
    RuleNumber?: number;
}
export declare namespace AnalysisAclRule {
    
    const filterSensitiveLog: (obj: AnalysisAclRule) => any;
}

export interface AnalysisComponent {
    
    Id?: string;
    
    Arn?: string;
    
    Name?: string;
}
export declare namespace AnalysisComponent {
    
    const filterSensitiveLog: (obj: AnalysisComponent) => any;
}

export interface AnalysisPacketHeader {
    
    DestinationAddresses?: string[];
    
    DestinationPortRanges?: PortRange[];
    
    Protocol?: string;
    
    SourceAddresses?: string[];
    
    SourcePortRanges?: PortRange[];
}
export declare namespace AnalysisPacketHeader {
    
    const filterSensitiveLog: (obj: AnalysisPacketHeader) => any;
}

export interface AnalysisRouteTableRoute {
    
    DestinationCidr?: string;
    
    DestinationPrefixListId?: string;
    
    EgressOnlyInternetGatewayId?: string;
    
    GatewayId?: string;
    
    InstanceId?: string;
    
    NatGatewayId?: string;
    
    NetworkInterfaceId?: string;
    
    Origin?: string;
    
    TransitGatewayId?: string;
    
    VpcPeeringConnectionId?: string;
}
export declare namespace AnalysisRouteTableRoute {
    
    const filterSensitiveLog: (obj: AnalysisRouteTableRoute) => any;
}

export interface AnalysisSecurityGroupRule {
    
    Cidr?: string;
    
    Direction?: string;
    
    SecurityGroupId?: string;
    
    PortRange?: PortRange;
    
    PrefixListId?: string;
    
    Protocol?: string;
}
export declare namespace AnalysisSecurityGroupRule {
    
    const filterSensitiveLog: (obj: AnalysisSecurityGroupRule) => any;
}

export interface PathComponent {
    
    SequenceNumber?: number;
    
    AclRule?: AnalysisAclRule;
    
    AttachedTo?: AnalysisComponent;
    
    Component?: AnalysisComponent;
    
    DestinationVpc?: AnalysisComponent;
    
    OutboundHeader?: AnalysisPacketHeader;
    
    InboundHeader?: AnalysisPacketHeader;
    
    RouteTableRoute?: AnalysisRouteTableRoute;
    
    SecurityGroupRule?: AnalysisSecurityGroupRule;
    
    SourceVpc?: AnalysisComponent;
    
    Subnet?: AnalysisComponent;
    
    Vpc?: AnalysisComponent;
}
export declare namespace PathComponent {
    
    const filterSensitiveLog: (obj: PathComponent) => any;
}

export interface AccessScopeAnalysisFinding {
    
    NetworkInsightsAccessScopeAnalysisId?: string;
    
    NetworkInsightsAccessScopeId?: string;
    
    FindingId?: string;
    
    FindingComponents?: PathComponent[];
}
export declare namespace AccessScopeAnalysisFinding {
    
    const filterSensitiveLog: (obj: AccessScopeAnalysisFinding) => any;
}
export declare type Protocol = "tcp" | "udp";

export interface PacketHeaderStatement {
    
    SourceAddresses?: string[];
    
    DestinationAddresses?: string[];
    
    SourcePorts?: string[];
    
    DestinationPorts?: string[];
    
    SourcePrefixLists?: string[];
    
    DestinationPrefixLists?: string[];
    
    Protocols?: (Protocol | string)[];
}
export declare namespace PacketHeaderStatement {
    
    const filterSensitiveLog: (obj: PacketHeaderStatement) => any;
}

export interface ResourceStatement {
    
    Resources?: string[];
    
    ResourceTypes?: string[];
}
export declare namespace ResourceStatement {
    
    const filterSensitiveLog: (obj: ResourceStatement) => any;
}

export interface PathStatement {
    
    PacketHeaderStatement?: PacketHeaderStatement;
    
    ResourceStatement?: ResourceStatement;
}
export declare namespace PathStatement {
    
    const filterSensitiveLog: (obj: PathStatement) => any;
}

export interface ThroughResourcesStatement {
    
    ResourceStatement?: ResourceStatement;
}
export declare namespace ThroughResourcesStatement {
    
    const filterSensitiveLog: (obj: ThroughResourcesStatement) => any;
}

export interface AccessScopePath {
    
    Source?: PathStatement;
    
    Destination?: PathStatement;
    
    ThroughResources?: ThroughResourcesStatement[];
}
export declare namespace AccessScopePath {
    
    const filterSensitiveLog: (obj: AccessScopePath) => any;
}

export interface PacketHeaderStatementRequest {
    
    SourceAddresses?: string[];
    
    DestinationAddresses?: string[];
    
    SourcePorts?: string[];
    
    DestinationPorts?: string[];
    
    SourcePrefixLists?: string[];
    
    DestinationPrefixLists?: string[];
    
    Protocols?: (Protocol | string)[];
}
export declare namespace PacketHeaderStatementRequest {
    
    const filterSensitiveLog: (obj: PacketHeaderStatementRequest) => any;
}

export interface ResourceStatementRequest {
    
    Resources?: string[];
    
    ResourceTypes?: string[];
}
export declare namespace ResourceStatementRequest {
    
    const filterSensitiveLog: (obj: ResourceStatementRequest) => any;
}

export interface PathStatementRequest {
    
    PacketHeaderStatement?: PacketHeaderStatementRequest;
    
    ResourceStatement?: ResourceStatementRequest;
}
export declare namespace PathStatementRequest {
    
    const filterSensitiveLog: (obj: PathStatementRequest) => any;
}

export interface ThroughResourcesStatementRequest {
    
    ResourceStatement?: ResourceStatementRequest;
}
export declare namespace ThroughResourcesStatementRequest {
    
    const filterSensitiveLog: (obj: ThroughResourcesStatementRequest) => any;
}

export interface AccessScopePathRequest {
    
    Source?: PathStatementRequest;
    
    Destination?: PathStatementRequest;
    
    ThroughResources?: ThroughResourcesStatementRequest[];
}
export declare namespace AccessScopePathRequest {
    
    const filterSensitiveLog: (obj: AccessScopePathRequest) => any;
}

export interface AccountAttributeValue {
    
    AttributeValue?: string;
}
export declare namespace AccountAttributeValue {
    
    const filterSensitiveLog: (obj: AccountAttributeValue) => any;
}

export interface AccountAttribute {
    
    AttributeName?: string;
    
    AttributeValues?: AccountAttributeValue[];
}
export declare namespace AccountAttribute {
    
    const filterSensitiveLog: (obj: AccountAttribute) => any;
}
export declare type AccountAttributeName = "default-vpc" | "supported-platforms";
export declare enum InstanceHealthStatus {
    HEALTHY_STATUS = "healthy",
    UNHEALTHY_STATUS = "unhealthy"
}

export interface ActiveInstance {
    
    InstanceId?: string;
    
    InstanceType?: string;
    
    SpotInstanceRequestId?: string;
    
    InstanceHealth?: InstanceHealthStatus | string;
}
export declare namespace ActiveInstance {
    
    const filterSensitiveLog: (obj: ActiveInstance) => any;
}
export declare enum ActivityStatus {
    ERROR = "error",
    FULFILLED = "fulfilled",
    PENDING_FULFILLMENT = "pending_fulfillment",
    PENDING_TERMINATION = "pending_termination"
}

export interface AddIpamOperatingRegion {
    
    RegionName?: string;
}
export declare namespace AddIpamOperatingRegion {
    
    const filterSensitiveLog: (obj: AddIpamOperatingRegion) => any;
}

export interface AddPrefixListEntry {
    
    Cidr: string | undefined;
    
    Description?: string;
}
export declare namespace AddPrefixListEntry {
    
    const filterSensitiveLog: (obj: AddPrefixListEntry) => any;
}
export declare type DomainType = "standard" | "vpc";

export interface Address {
    
    InstanceId?: string;
    
    PublicIp?: string;
    
    AllocationId?: string;
    
    AssociationId?: string;
    
    Domain?: DomainType | string;
    
    NetworkInterfaceId?: string;
    
    NetworkInterfaceOwnerId?: string;
    
    PrivateIpAddress?: string;
    
    Tags?: Tag[];
    
    PublicIpv4Pool?: string;
    
    NetworkBorderGroup?: string;
    
    CustomerOwnedIp?: string;
    
    CustomerOwnedIpv4Pool?: string;
    
    CarrierIp?: string;
}
export declare namespace Address {
    
    const filterSensitiveLog: (obj: Address) => any;
}

export interface PtrUpdateStatus {
    
    Value?: string;
    
    Status?: string;
    
    Reason?: string;
}
export declare namespace PtrUpdateStatus {
    
    const filterSensitiveLog: (obj: PtrUpdateStatus) => any;
}

export interface AddressAttribute {
    
    PublicIp?: string;
    
    AllocationId?: string;
    
    PtrRecord?: string;
    
    PtrRecordUpdate?: PtrUpdateStatus;
}
export declare namespace AddressAttribute {
    
    const filterSensitiveLog: (obj: AddressAttribute) => any;
}
export declare type AddressAttributeName = "domain-name";
export declare enum AddressFamily {
    ipv4 = "ipv4",
    ipv6 = "ipv6"
}
export interface AdvertiseByoipCidrRequest {
    
    Cidr: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AdvertiseByoipCidrRequest {
    
    const filterSensitiveLog: (obj: AdvertiseByoipCidrRequest) => any;
}
export declare type ByoipCidrState = "advertised" | "deprovisioned" | "failed-deprovision" | "failed-provision" | "pending-deprovision" | "pending-provision" | "provisioned" | "provisioned-not-publicly-advertisable";

export interface ByoipCidr {
    
    Cidr?: string;
    
    Description?: string;
    
    StatusMessage?: string;
    
    State?: ByoipCidrState | string;
}
export declare namespace ByoipCidr {
    
    const filterSensitiveLog: (obj: ByoipCidr) => any;
}
export interface AdvertiseByoipCidrResult {
    
    ByoipCidr?: ByoipCidr;
}
export declare namespace AdvertiseByoipCidrResult {
    
    const filterSensitiveLog: (obj: AdvertiseByoipCidrResult) => any;
}
export declare type Affinity = "default" | "host";
export declare type ResourceType = "capacity-reservation" | "carrier-gateway" | "client-vpn-endpoint" | "customer-gateway" | "dedicated-host" | "dhcp-options" | "egress-only-internet-gateway" | "elastic-gpu" | "elastic-ip" | "export-image-task" | "export-instance-task" | "fleet" | "fpga-image" | "host-reservation" | "image" | "import-image-task" | "import-snapshot-task" | "instance" | "instance-event-window" | "internet-gateway" | "ipam" | "ipam-pool" | "ipam-scope" | "ipv4pool-ec2" | "ipv6pool-ec2" | "key-pair" | "launch-template" | "local-gateway" | "local-gateway-route-table" | "local-gateway-route-table-virtual-interface-group-association" | "local-gateway-route-table-vpc-association" | "local-gateway-virtual-interface" | "local-gateway-virtual-interface-group" | "natgateway" | "network-acl" | "network-insights-access-scope" | "network-insights-access-scope-analysis" | "network-insights-analysis" | "network-insights-path" | "network-interface" | "placement-group" | "prefix-list" | "replace-root-volume-task" | "reserved-instances" | "route-table" | "security-group" | "security-group-rule" | "snapshot" | "spot-fleet-request" | "spot-instances-request" | "subnet" | "traffic-mirror-filter" | "traffic-mirror-session" | "traffic-mirror-target" | "transit-gateway" | "transit-gateway-attachment" | "transit-gateway-connect-peer" | "transit-gateway-multicast-domain" | "transit-gateway-route-table" | "volume" | "vpc" | "vpc-endpoint" | "vpc-endpoint-service" | "vpc-flow-log" | "vpc-peering-connection" | "vpn-connection" | "vpn-gateway";

export interface TagSpecification {
    
    ResourceType?: ResourceType | string;
    
    Tags?: Tag[];
}
export declare namespace TagSpecification {
    
    const filterSensitiveLog: (obj: TagSpecification) => any;
}
export interface AllocateAddressRequest {
    
    Domain?: DomainType | string;
    
    Address?: string;
    
    PublicIpv4Pool?: string;
    
    NetworkBorderGroup?: string;
    
    CustomerOwnedIpv4Pool?: string;
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace AllocateAddressRequest {
    
    const filterSensitiveLog: (obj: AllocateAddressRequest) => any;
}
export interface AllocateAddressResult {
    
    PublicIp?: string;
    
    AllocationId?: string;
    
    PublicIpv4Pool?: string;
    
    NetworkBorderGroup?: string;
    
    Domain?: DomainType | string;
    
    CustomerOwnedIp?: string;
    
    CustomerOwnedIpv4Pool?: string;
    
    CarrierIp?: string;
}
export declare namespace AllocateAddressResult {
    
    const filterSensitiveLog: (obj: AllocateAddressResult) => any;
}
export declare type AutoPlacement = "off" | "on";
export declare type HostRecovery = "off" | "on";
export interface AllocateHostsRequest {
    
    AutoPlacement?: AutoPlacement | string;
    
    AvailabilityZone: string | undefined;
    
    ClientToken?: string;
    
    InstanceType?: string;
    
    InstanceFamily?: string;
    
    Quantity: number | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    HostRecovery?: HostRecovery | string;
}
export declare namespace AllocateHostsRequest {
    
    const filterSensitiveLog: (obj: AllocateHostsRequest) => any;
}

export interface AllocateHostsResult {
    
    HostIds?: string[];
}
export declare namespace AllocateHostsResult {
    
    const filterSensitiveLog: (obj: AllocateHostsResult) => any;
}
export interface AllocateIpamPoolCidrRequest {
    
    DryRun?: boolean;
    
    IpamPoolId: string | undefined;
    
    Cidr?: string;
    
    NetmaskLength?: number;
    
    ClientToken?: string;
    
    Description?: string;
    
    PreviewNextCidr?: boolean;
    
    DisallowedCidrs?: string[];
}
export declare namespace AllocateIpamPoolCidrRequest {
    
    const filterSensitiveLog: (obj: AllocateIpamPoolCidrRequest) => any;
}
export declare enum IpamPoolAllocationResourceType {
    custom = "custom",
    ec2_public_ipv4_pool = "ec2-public-ipv4-pool",
    ipam_pool = "ipam-pool",
    vpc = "vpc"
}

export interface IpamPoolAllocation {
    
    Cidr?: string;
    
    IpamPoolAllocationId?: string;
    
    Description?: string;
    
    ResourceId?: string;
    
    ResourceType?: IpamPoolAllocationResourceType | string;
    
    ResourceRegion?: string;
    
    ResourceOwner?: string;
}
export declare namespace IpamPoolAllocation {
    
    const filterSensitiveLog: (obj: IpamPoolAllocation) => any;
}
export interface AllocateIpamPoolCidrResult {
    
    IpamPoolAllocation?: IpamPoolAllocation;
}
export declare namespace AllocateIpamPoolCidrResult {
    
    const filterSensitiveLog: (obj: AllocateIpamPoolCidrResult) => any;
}
export declare type AllocationState = "available" | "pending" | "permanent-failure" | "released" | "released-permanent-failure" | "under-assessment";
export declare enum AllocationStrategy {
    CAPACITY_OPTIMIZED = "capacityOptimized",
    CAPACITY_OPTIMIZED_PRIORITIZED = "capacityOptimizedPrioritized",
    DIVERSIFIED = "diversified",
    LOWEST_PRICE = "lowestPrice"
}
export declare enum PrincipalType {
    Account = "Account",
    All = "All",
    OrganizationUnit = "OrganizationUnit",
    Role = "Role",
    Service = "Service",
    User = "User"
}

export interface AllowedPrincipal {
    
    PrincipalType?: PrincipalType | string;
    
    Principal?: string;
}
export declare namespace AllowedPrincipal {
    
    const filterSensitiveLog: (obj: AllowedPrincipal) => any;
}
export declare type AllowsMultipleInstanceTypes = "off" | "on";

export interface AlternatePathHint {
    
    ComponentId?: string;
    
    ComponentArn?: string;
}
export declare namespace AlternatePathHint {
    
    const filterSensitiveLog: (obj: AlternatePathHint) => any;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    VpcId: string | undefined;
    
    SecurityGroupIds: string[] | undefined;
    
    DryRun?: boolean;
}
export declare namespace ApplySecurityGroupsToClientVpnTargetNetworkRequest {
    
    const filterSensitiveLog: (obj: ApplySecurityGroupsToClientVpnTargetNetworkRequest) => any;
}
export interface ApplySecurityGroupsToClientVpnTargetNetworkResult {
    
    SecurityGroupIds?: string[];
}
export declare namespace ApplySecurityGroupsToClientVpnTargetNetworkResult {
    
    const filterSensitiveLog: (obj: ApplySecurityGroupsToClientVpnTargetNetworkResult) => any;
}
export interface AssignIpv6AddressesRequest {
    
    Ipv6AddressCount?: number;
    
    Ipv6Addresses?: string[];
    
    Ipv6PrefixCount?: number;
    
    Ipv6Prefixes?: string[];
    
    NetworkInterfaceId: string | undefined;
}
export declare namespace AssignIpv6AddressesRequest {
    
    const filterSensitiveLog: (obj: AssignIpv6AddressesRequest) => any;
}
export interface AssignIpv6AddressesResult {
    
    AssignedIpv6Addresses?: string[];
    
    AssignedIpv6Prefixes?: string[];
    
    NetworkInterfaceId?: string;
}
export declare namespace AssignIpv6AddressesResult {
    
    const filterSensitiveLog: (obj: AssignIpv6AddressesResult) => any;
}

export interface AssignPrivateIpAddressesRequest {
    
    AllowReassignment?: boolean;
    
    NetworkInterfaceId: string | undefined;
    
    PrivateIpAddresses?: string[];
    
    SecondaryPrivateIpAddressCount?: number;
    
    Ipv4Prefixes?: string[];
    
    Ipv4PrefixCount?: number;
}
export declare namespace AssignPrivateIpAddressesRequest {
    
    const filterSensitiveLog: (obj: AssignPrivateIpAddressesRequest) => any;
}

export interface Ipv4PrefixSpecification {
    
    Ipv4Prefix?: string;
}
export declare namespace Ipv4PrefixSpecification {
    
    const filterSensitiveLog: (obj: Ipv4PrefixSpecification) => any;
}

export interface AssignedPrivateIpAddress {
    
    PrivateIpAddress?: string;
}
export declare namespace AssignedPrivateIpAddress {
    
    const filterSensitiveLog: (obj: AssignedPrivateIpAddress) => any;
}
export interface AssignPrivateIpAddressesResult {
    
    NetworkInterfaceId?: string;
    
    AssignedPrivateIpAddresses?: AssignedPrivateIpAddress[];
    
    AssignedIpv4Prefixes?: Ipv4PrefixSpecification[];
}
export declare namespace AssignPrivateIpAddressesResult {
    
    const filterSensitiveLog: (obj: AssignPrivateIpAddressesResult) => any;
}
export interface AssociateAddressRequest {
    
    AllocationId?: string;
    
    InstanceId?: string;
    
    PublicIp?: string;
    
    AllowReassociation?: boolean;
    
    DryRun?: boolean;
    
    NetworkInterfaceId?: string;
    
    PrivateIpAddress?: string;
}
export declare namespace AssociateAddressRequest {
    
    const filterSensitiveLog: (obj: AssociateAddressRequest) => any;
}
export interface AssociateAddressResult {
    
    AssociationId?: string;
}
export declare namespace AssociateAddressResult {
    
    const filterSensitiveLog: (obj: AssociateAddressResult) => any;
}
export interface AssociateClientVpnTargetNetworkRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    SubnetId: string | undefined;
    
    ClientToken?: string;
    
    DryRun?: boolean;
}
export declare namespace AssociateClientVpnTargetNetworkRequest {
    
    const filterSensitiveLog: (obj: AssociateClientVpnTargetNetworkRequest) => any;
}
export declare type AssociationStatusCode = "associated" | "associating" | "association-failed" | "disassociated" | "disassociating";

export interface AssociationStatus {
    
    Code?: AssociationStatusCode | string;
    
    Message?: string;
}
export declare namespace AssociationStatus {
    
    const filterSensitiveLog: (obj: AssociationStatus) => any;
}
export interface AssociateClientVpnTargetNetworkResult {
    
    AssociationId?: string;
    
    Status?: AssociationStatus;
}
export declare namespace AssociateClientVpnTargetNetworkResult {
    
    const filterSensitiveLog: (obj: AssociateClientVpnTargetNetworkResult) => any;
}
export interface AssociateDhcpOptionsRequest {
    
    DhcpOptionsId: string | undefined;
    
    VpcId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AssociateDhcpOptionsRequest {
    
    const filterSensitiveLog: (obj: AssociateDhcpOptionsRequest) => any;
}
export interface AssociateEnclaveCertificateIamRoleRequest {
    
    CertificateArn?: string;
    
    RoleArn?: string;
    
    DryRun?: boolean;
}
export declare namespace AssociateEnclaveCertificateIamRoleRequest {
    
    const filterSensitiveLog: (obj: AssociateEnclaveCertificateIamRoleRequest) => any;
}
export interface AssociateEnclaveCertificateIamRoleResult {
    
    CertificateS3BucketName?: string;
    
    CertificateS3ObjectKey?: string;
    
    EncryptionKmsKeyId?: string;
}
export declare namespace AssociateEnclaveCertificateIamRoleResult {
    
    const filterSensitiveLog: (obj: AssociateEnclaveCertificateIamRoleResult) => any;
}

export interface IamInstanceProfileSpecification {
    
    Arn?: string;
    
    Name?: string;
}
export declare namespace IamInstanceProfileSpecification {
    
    const filterSensitiveLog: (obj: IamInstanceProfileSpecification) => any;
}
export interface AssociateIamInstanceProfileRequest {
    
    IamInstanceProfile: IamInstanceProfileSpecification | undefined;
    
    InstanceId: string | undefined;
}
export declare namespace AssociateIamInstanceProfileRequest {
    
    const filterSensitiveLog: (obj: AssociateIamInstanceProfileRequest) => any;
}

export interface IamInstanceProfile {
    
    Arn?: string;
    
    Id?: string;
}
export declare namespace IamInstanceProfile {
    
    const filterSensitiveLog: (obj: IamInstanceProfile) => any;
}
export declare enum IamInstanceProfileAssociationState {
    ASSOCIATED = "associated",
    ASSOCIATING = "associating",
    DISASSOCIATED = "disassociated",
    DISASSOCIATING = "disassociating"
}

export interface IamInstanceProfileAssociation {
    
    AssociationId?: string;
    
    InstanceId?: string;
    
    IamInstanceProfile?: IamInstanceProfile;
    
    State?: IamInstanceProfileAssociationState | string;
    
    Timestamp?: Date;
}
export declare namespace IamInstanceProfileAssociation {
    
    const filterSensitiveLog: (obj: IamInstanceProfileAssociation) => any;
}
export interface AssociateIamInstanceProfileResult {
    
    IamInstanceProfileAssociation?: IamInstanceProfileAssociation;
}
export declare namespace AssociateIamInstanceProfileResult {
    
    const filterSensitiveLog: (obj: AssociateIamInstanceProfileResult) => any;
}

export interface InstanceEventWindowAssociationRequest {
    
    InstanceIds?: string[];
    
    InstanceTags?: Tag[];
    
    DedicatedHostIds?: string[];
}
export declare namespace InstanceEventWindowAssociationRequest {
    
    const filterSensitiveLog: (obj: InstanceEventWindowAssociationRequest) => any;
}
export interface AssociateInstanceEventWindowRequest {
    
    DryRun?: boolean;
    
    InstanceEventWindowId: string | undefined;
    
    AssociationTarget: InstanceEventWindowAssociationRequest | undefined;
}
export declare namespace AssociateInstanceEventWindowRequest {
    
    const filterSensitiveLog: (obj: AssociateInstanceEventWindowRequest) => any;
}

export interface InstanceEventWindowAssociationTarget {
    
    InstanceIds?: string[];
    
    Tags?: Tag[];
    
    DedicatedHostIds?: string[];
}
export declare namespace InstanceEventWindowAssociationTarget {
    
    const filterSensitiveLog: (obj: InstanceEventWindowAssociationTarget) => any;
}
export declare enum InstanceEventWindowState {
    active = "active",
    creating = "creating",
    deleted = "deleted",
    deleting = "deleting"
}
export declare enum WeekDay {
    friday = "friday",
    monday = "monday",
    saturday = "saturday",
    sunday = "sunday",
    thursday = "thursday",
    tuesday = "tuesday",
    wednesday = "wednesday"
}

export interface InstanceEventWindowTimeRange {
    
    StartWeekDay?: WeekDay | string;
    
    StartHour?: number;
    
    EndWeekDay?: WeekDay | string;
    
    EndHour?: number;
}
export declare namespace InstanceEventWindowTimeRange {
    
    const filterSensitiveLog: (obj: InstanceEventWindowTimeRange) => any;
}

export interface InstanceEventWindow {
    
    InstanceEventWindowId?: string;
    
    TimeRanges?: InstanceEventWindowTimeRange[];
    
    Name?: string;
    
    CronExpression?: string;
    
    AssociationTarget?: InstanceEventWindowAssociationTarget;
    
    State?: InstanceEventWindowState | string;
    
    Tags?: Tag[];
}
export declare namespace InstanceEventWindow {
    
    const filterSensitiveLog: (obj: InstanceEventWindow) => any;
}
export interface AssociateInstanceEventWindowResult {
    
    InstanceEventWindow?: InstanceEventWindow;
}
export declare namespace AssociateInstanceEventWindowResult {
    
    const filterSensitiveLog: (obj: AssociateInstanceEventWindowResult) => any;
}
export interface AssociateRouteTableRequest {
    
    DryRun?: boolean;
    
    RouteTableId: string | undefined;
    
    SubnetId?: string;
    
    GatewayId?: string;
}
export declare namespace AssociateRouteTableRequest {
    
    const filterSensitiveLog: (obj: AssociateRouteTableRequest) => any;
}
export declare type RouteTableAssociationStateCode = "associated" | "associating" | "disassociated" | "disassociating" | "failed";

export interface RouteTableAssociationState {
    
    State?: RouteTableAssociationStateCode | string;
    
    StatusMessage?: string;
}
export declare namespace RouteTableAssociationState {
    
    const filterSensitiveLog: (obj: RouteTableAssociationState) => any;
}
export interface AssociateRouteTableResult {
    
    AssociationId?: string;
    
    AssociationState?: RouteTableAssociationState;
}
export declare namespace AssociateRouteTableResult {
    
    const filterSensitiveLog: (obj: AssociateRouteTableResult) => any;
}
export interface AssociateSubnetCidrBlockRequest {
    
    Ipv6CidrBlock: string | undefined;
    
    SubnetId: string | undefined;
}
export declare namespace AssociateSubnetCidrBlockRequest {
    
    const filterSensitiveLog: (obj: AssociateSubnetCidrBlockRequest) => any;
}
export declare type SubnetCidrBlockStateCode = "associated" | "associating" | "disassociated" | "disassociating" | "failed" | "failing";

export interface SubnetCidrBlockState {
    
    State?: SubnetCidrBlockStateCode | string;
    
    StatusMessage?: string;
}
export declare namespace SubnetCidrBlockState {
    
    const filterSensitiveLog: (obj: SubnetCidrBlockState) => any;
}

export interface SubnetIpv6CidrBlockAssociation {
    
    AssociationId?: string;
    
    Ipv6CidrBlock?: string;
    
    Ipv6CidrBlockState?: SubnetCidrBlockState;
}
export declare namespace SubnetIpv6CidrBlockAssociation {
    
    const filterSensitiveLog: (obj: SubnetIpv6CidrBlockAssociation) => any;
}
export interface AssociateSubnetCidrBlockResult {
    
    Ipv6CidrBlockAssociation?: SubnetIpv6CidrBlockAssociation;
    
    SubnetId?: string;
}
export declare namespace AssociateSubnetCidrBlockResult {
    
    const filterSensitiveLog: (obj: AssociateSubnetCidrBlockResult) => any;
}
export interface AssociateTransitGatewayMulticastDomainRequest {
    
    TransitGatewayMulticastDomainId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    SubnetIds?: string[];
    
    DryRun?: boolean;
}
export declare namespace AssociateTransitGatewayMulticastDomainRequest {
    
    const filterSensitiveLog: (obj: AssociateTransitGatewayMulticastDomainRequest) => any;
}
export interface AssociateTransitGatewayMulticastDomainResult {
    
    Associations?: TransitGatewayMulticastDomainAssociations;
}
export declare namespace AssociateTransitGatewayMulticastDomainResult {
    
    const filterSensitiveLog: (obj: AssociateTransitGatewayMulticastDomainResult) => any;
}
export interface AssociateTransitGatewayRouteTableRequest {
    
    TransitGatewayRouteTableId: string | undefined;
    
    TransitGatewayAttachmentId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AssociateTransitGatewayRouteTableRequest {
    
    const filterSensitiveLog: (obj: AssociateTransitGatewayRouteTableRequest) => any;
}
export declare type TransitGatewayAssociationState = "associated" | "associating" | "disassociated" | "disassociating";

export interface TransitGatewayAssociation {
    
    TransitGatewayRouteTableId?: string;
    
    TransitGatewayAttachmentId?: string;
    
    ResourceId?: string;
    
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    
    State?: TransitGatewayAssociationState | string;
}
export declare namespace TransitGatewayAssociation {
    
    const filterSensitiveLog: (obj: TransitGatewayAssociation) => any;
}
export interface AssociateTransitGatewayRouteTableResult {
    
    Association?: TransitGatewayAssociation;
}
export declare namespace AssociateTransitGatewayRouteTableResult {
    
    const filterSensitiveLog: (obj: AssociateTransitGatewayRouteTableResult) => any;
}
export interface AssociateTrunkInterfaceRequest {
    
    BranchInterfaceId: string | undefined;
    
    TrunkInterfaceId: string | undefined;
    
    VlanId?: number;
    
    GreKey?: number;
    
    ClientToken?: string;
    
    DryRun?: boolean;
}
export declare namespace AssociateTrunkInterfaceRequest {
    
    const filterSensitiveLog: (obj: AssociateTrunkInterfaceRequest) => any;
}
export declare enum InterfaceProtocolType {
    GRE = "GRE",
    VLAN = "VLAN"
}

export interface TrunkInterfaceAssociation {
    
    AssociationId?: string;
    
    BranchInterfaceId?: string;
    
    TrunkInterfaceId?: string;
    
    InterfaceProtocol?: InterfaceProtocolType | string;
    
    VlanId?: number;
    
    GreKey?: number;
    
    Tags?: Tag[];
}
export declare namespace TrunkInterfaceAssociation {
    
    const filterSensitiveLog: (obj: TrunkInterfaceAssociation) => any;
}
export interface AssociateTrunkInterfaceResult {
    
    InterfaceAssociation?: TrunkInterfaceAssociation;
    
    ClientToken?: string;
}
export declare namespace AssociateTrunkInterfaceResult {
    
    const filterSensitiveLog: (obj: AssociateTrunkInterfaceResult) => any;
}
export interface AssociateVpcCidrBlockRequest {
    
    AmazonProvidedIpv6CidrBlock?: boolean;
    
    CidrBlock?: string;
    
    VpcId: string | undefined;
    
    Ipv6CidrBlockNetworkBorderGroup?: string;
    
    Ipv6Pool?: string;
    
    Ipv6CidrBlock?: string;
    
    Ipv4IpamPoolId?: string;
    
    Ipv4NetmaskLength?: number;
    
    Ipv6IpamPoolId?: string;
    
    Ipv6NetmaskLength?: number;
}
export declare namespace AssociateVpcCidrBlockRequest {
    
    const filterSensitiveLog: (obj: AssociateVpcCidrBlockRequest) => any;
}
export declare type VpcCidrBlockStateCode = "associated" | "associating" | "disassociated" | "disassociating" | "failed" | "failing";

export interface VpcCidrBlockState {
    
    State?: VpcCidrBlockStateCode | string;
    
    StatusMessage?: string;
}
export declare namespace VpcCidrBlockState {
    
    const filterSensitiveLog: (obj: VpcCidrBlockState) => any;
}

export interface VpcCidrBlockAssociation {
    
    AssociationId?: string;
    
    CidrBlock?: string;
    
    CidrBlockState?: VpcCidrBlockState;
}
export declare namespace VpcCidrBlockAssociation {
    
    const filterSensitiveLog: (obj: VpcCidrBlockAssociation) => any;
}

export interface VpcIpv6CidrBlockAssociation {
    
    AssociationId?: string;
    
    Ipv6CidrBlock?: string;
    
    Ipv6CidrBlockState?: VpcCidrBlockState;
    
    NetworkBorderGroup?: string;
    
    Ipv6Pool?: string;
}
export declare namespace VpcIpv6CidrBlockAssociation {
    
    const filterSensitiveLog: (obj: VpcIpv6CidrBlockAssociation) => any;
}
export interface AssociateVpcCidrBlockResult {
    
    Ipv6CidrBlockAssociation?: VpcIpv6CidrBlockAssociation;
    
    CidrBlockAssociation?: VpcCidrBlockAssociation;
    
    VpcId?: string;
}
export declare namespace AssociateVpcCidrBlockResult {
    
    const filterSensitiveLog: (obj: AssociateVpcCidrBlockResult) => any;
}
export interface AttachClassicLinkVpcRequest {
    
    DryRun?: boolean;
    
    Groups: string[] | undefined;
    
    InstanceId: string | undefined;
    
    VpcId: string | undefined;
}
export declare namespace AttachClassicLinkVpcRequest {
    
    const filterSensitiveLog: (obj: AttachClassicLinkVpcRequest) => any;
}
export interface AttachClassicLinkVpcResult {
    
    Return?: boolean;
}
export declare namespace AttachClassicLinkVpcResult {
    
    const filterSensitiveLog: (obj: AttachClassicLinkVpcResult) => any;
}
export interface AttachInternetGatewayRequest {
    
    DryRun?: boolean;
    
    InternetGatewayId: string | undefined;
    
    VpcId: string | undefined;
}
export declare namespace AttachInternetGatewayRequest {
    
    const filterSensitiveLog: (obj: AttachInternetGatewayRequest) => any;
}

export interface AttachNetworkInterfaceRequest {
    
    DeviceIndex: number | undefined;
    
    DryRun?: boolean;
    
    InstanceId: string | undefined;
    
    NetworkInterfaceId: string | undefined;
    
    NetworkCardIndex?: number;
}
export declare namespace AttachNetworkInterfaceRequest {
    
    const filterSensitiveLog: (obj: AttachNetworkInterfaceRequest) => any;
}

export interface AttachNetworkInterfaceResult {
    
    AttachmentId?: string;
    
    NetworkCardIndex?: number;
}
export declare namespace AttachNetworkInterfaceResult {
    
    const filterSensitiveLog: (obj: AttachNetworkInterfaceResult) => any;
}
export interface AttachVolumeRequest {
    
    Device: string | undefined;
    
    InstanceId: string | undefined;
    
    VolumeId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AttachVolumeRequest {
    
    const filterSensitiveLog: (obj: AttachVolumeRequest) => any;
}
export declare type VolumeAttachmentState = "attached" | "attaching" | "busy" | "detached" | "detaching";

export interface VolumeAttachment {
    
    AttachTime?: Date;
    
    Device?: string;
    
    InstanceId?: string;
    
    State?: VolumeAttachmentState | string;
    
    VolumeId?: string;
    
    DeleteOnTermination?: boolean;
}
export declare namespace VolumeAttachment {
    
    const filterSensitiveLog: (obj: VolumeAttachment) => any;
}

export interface AttachVpnGatewayRequest {
    
    VpcId: string | undefined;
    
    VpnGatewayId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace AttachVpnGatewayRequest {
    
    const filterSensitiveLog: (obj: AttachVpnGatewayRequest) => any;
}
export declare type AttachmentStatus = "attached" | "attaching" | "detached" | "detaching";

export interface VpcAttachment {
    
    State?: AttachmentStatus | string;
    
    VpcId?: string;
}
export declare namespace VpcAttachment {
    
    const filterSensitiveLog: (obj: VpcAttachment) => any;
}

export interface AttachVpnGatewayResult {
    
    VpcAttachment?: VpcAttachment;
}
export declare namespace AttachVpnGatewayResult {
    
    const filterSensitiveLog: (obj: AttachVpnGatewayResult) => any;
}
export interface AuthorizeClientVpnIngressRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    TargetNetworkCidr: string | undefined;
    
    AccessGroupId?: string;
    
    AuthorizeAllGroups?: boolean;
    
    Description?: string;
    
    ClientToken?: string;
    
    DryRun?: boolean;
}
export declare namespace AuthorizeClientVpnIngressRequest {
    
    const filterSensitiveLog: (obj: AuthorizeClientVpnIngressRequest) => any;
}
export declare type ClientVpnAuthorizationRuleStatusCode = "active" | "authorizing" | "failed" | "revoking";

export interface ClientVpnAuthorizationRuleStatus {
    
    Code?: ClientVpnAuthorizationRuleStatusCode | string;
    
    Message?: string;
}
export declare namespace ClientVpnAuthorizationRuleStatus {
    
    const filterSensitiveLog: (obj: ClientVpnAuthorizationRuleStatus) => any;
}
export interface AuthorizeClientVpnIngressResult {
    
    Status?: ClientVpnAuthorizationRuleStatus;
}
export declare namespace AuthorizeClientVpnIngressResult {
    
    const filterSensitiveLog: (obj: AuthorizeClientVpnIngressResult) => any;
}

export interface IpRange {
    
    CidrIp?: string;
    
    Description?: string;
}
export declare namespace IpRange {
    
    const filterSensitiveLog: (obj: IpRange) => any;
}

export interface Ipv6Range {
    
    CidrIpv6?: string;
    
    Description?: string;
}
export declare namespace Ipv6Range {
    
    const filterSensitiveLog: (obj: Ipv6Range) => any;
}

export interface PrefixListId {
    
    Description?: string;
    
    PrefixListId?: string;
}
export declare namespace PrefixListId {
    
    const filterSensitiveLog: (obj: PrefixListId) => any;
}

export interface UserIdGroupPair {
    
    Description?: string;
    
    GroupId?: string;
    
    GroupName?: string;
    
    PeeringStatus?: string;
    
    UserId?: string;
    
    VpcId?: string;
    
    VpcPeeringConnectionId?: string;
}
export declare namespace UserIdGroupPair {
    
    const filterSensitiveLog: (obj: UserIdGroupPair) => any;
}

export interface IpPermission {
    
    FromPort?: number;
    
    IpProtocol?: string;
    
    IpRanges?: IpRange[];
    
    Ipv6Ranges?: Ipv6Range[];
    
    PrefixListIds?: PrefixListId[];
    
    ToPort?: number;
    
    UserIdGroupPairs?: UserIdGroupPair[];
}
export declare namespace IpPermission {
    
    const filterSensitiveLog: (obj: IpPermission) => any;
}
export interface AuthorizeSecurityGroupEgressRequest {
    
    DryRun?: boolean;
    
    GroupId: string | undefined;
    
    IpPermissions?: IpPermission[];
    
    TagSpecifications?: TagSpecification[];
    
    CidrIp?: string;
    
    FromPort?: number;
    
    IpProtocol?: string;
    
    ToPort?: number;
    
    SourceSecurityGroupName?: string;
    
    SourceSecurityGroupOwnerId?: string;
}
export declare namespace AuthorizeSecurityGroupEgressRequest {
    
    const filterSensitiveLog: (obj: AuthorizeSecurityGroupEgressRequest) => any;
}

export interface ReferencedSecurityGroup {
    
    GroupId?: string;
    
    PeeringStatus?: string;
    
    UserId?: string;
    
    VpcId?: string;
    
    VpcPeeringConnectionId?: string;
}
export declare namespace ReferencedSecurityGroup {
    
    const filterSensitiveLog: (obj: ReferencedSecurityGroup) => any;
}

export interface SecurityGroupRule {
    
    SecurityGroupRuleId?: string;
    
    GroupId?: string;
    
    GroupOwnerId?: string;
    
    IsEgress?: boolean;
    
    IpProtocol?: string;
    
    FromPort?: number;
    
    ToPort?: number;
    
    CidrIpv4?: string;
    
    CidrIpv6?: string;
    
    PrefixListId?: string;
    
    ReferencedGroupInfo?: ReferencedSecurityGroup;
    
    Description?: string;
    
    Tags?: Tag[];
}
export declare namespace SecurityGroupRule {
    
    const filterSensitiveLog: (obj: SecurityGroupRule) => any;
}
export interface AuthorizeSecurityGroupEgressResult {
    
    Return?: boolean;
    
    SecurityGroupRules?: SecurityGroupRule[];
}
export declare namespace AuthorizeSecurityGroupEgressResult {
    
    const filterSensitiveLog: (obj: AuthorizeSecurityGroupEgressResult) => any;
}
export interface AuthorizeSecurityGroupIngressRequest {
    
    CidrIp?: string;
    
    FromPort?: number;
    
    GroupId?: string;
    
    GroupName?: string;
    
    IpPermissions?: IpPermission[];
    
    IpProtocol?: string;
    
    SourceSecurityGroupName?: string;
    
    SourceSecurityGroupOwnerId?: string;
    
    ToPort?: number;
    
    DryRun?: boolean;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace AuthorizeSecurityGroupIngressRequest {
    
    const filterSensitiveLog: (obj: AuthorizeSecurityGroupIngressRequest) => any;
}
export interface AuthorizeSecurityGroupIngressResult {
    
    Return?: boolean;
    
    SecurityGroupRules?: SecurityGroupRule[];
}
export declare namespace AuthorizeSecurityGroupIngressResult {
    
    const filterSensitiveLog: (obj: AuthorizeSecurityGroupIngressResult) => any;
}

export interface S3Storage {
    
    AWSAccessKeyId?: string;
    
    Bucket?: string;
    
    Prefix?: string;
    
    UploadPolicy?: Uint8Array;
    
    UploadPolicySignature?: string;
}
export declare namespace S3Storage {
    
    const filterSensitiveLog: (obj: S3Storage) => any;
}

export interface Storage {
    
    S3?: S3Storage;
}
export declare namespace Storage {
    
    const filterSensitiveLog: (obj: Storage) => any;
}

export interface BundleInstanceRequest {
    
    InstanceId: string | undefined;
    
    Storage: Storage | undefined;
    
    DryRun?: boolean;
}
export declare namespace BundleInstanceRequest {
    
    const filterSensitiveLog: (obj: BundleInstanceRequest) => any;
}

export interface BundleTaskError {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace BundleTaskError {
    
    const filterSensitiveLog: (obj: BundleTaskError) => any;
}
export declare type BundleTaskState = "bundling" | "cancelling" | "complete" | "failed" | "pending" | "storing" | "waiting-for-shutdown";

export interface BundleTask {
    
    BundleId?: string;
    
    BundleTaskError?: BundleTaskError;
    
    InstanceId?: string;
    
    Progress?: string;
    
    StartTime?: Date;
    
    State?: BundleTaskState | string;
    
    Storage?: Storage;
    
    UpdateTime?: Date;
}
export declare namespace BundleTask {
    
    const filterSensitiveLog: (obj: BundleTask) => any;
}

export interface BundleInstanceResult {
    
    BundleTask?: BundleTask;
}
export declare namespace BundleInstanceResult {
    
    const filterSensitiveLog: (obj: BundleInstanceResult) => any;
}

export interface CancelBundleTaskRequest {
    
    BundleId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace CancelBundleTaskRequest {
    
    const filterSensitiveLog: (obj: CancelBundleTaskRequest) => any;
}

export interface CancelBundleTaskResult {
    
    BundleTask?: BundleTask;
}
export declare namespace CancelBundleTaskResult {
    
    const filterSensitiveLog: (obj: CancelBundleTaskResult) => any;
}
export interface CancelCapacityReservationRequest {
    
    CapacityReservationId: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace CancelCapacityReservationRequest {
    
    const filterSensitiveLog: (obj: CancelCapacityReservationRequest) => any;
}
export interface CancelCapacityReservationResult {
    
    Return?: boolean;
}
export declare namespace CancelCapacityReservationResult {
    
    const filterSensitiveLog: (obj: CancelCapacityReservationResult) => any;
}
export interface CancelCapacityReservationFleetsRequest {
    
    DryRun?: boolean;
    
    CapacityReservationFleetIds: string[] | undefined;
}
export declare namespace CancelCapacityReservationFleetsRequest {
    
    const filterSensitiveLog: (obj: CancelCapacityReservationFleetsRequest) => any;
}

export interface CancelCapacityReservationFleetError {
    
    Code?: string;
    
    Message?: string;
}
export declare namespace CancelCapacityReservationFleetError {
    
    const filterSensitiveLog: (obj: CancelCapacityReservationFleetError) => any;
}

export interface FailedCapacityReservationFleetCancellationResult {
    
    CapacityReservationFleetId?: string;
    
    CancelCapacityReservationFleetError?: CancelCapacityReservationFleetError;
}
export declare namespace FailedCapacityReservationFleetCancellationResult {
    
    const filterSensitiveLog: (obj: FailedCapacityReservationFleetCancellationResult) => any;
}
export declare enum CapacityReservationFleetState {
    ACTIVE = "active",
    CANCELLED = "cancelled",
    CANCELLING = "cancelling",
    EXPIRED = "expired",
    EXPIRING = "expiring",
    FAILED = "failed",
    MODIFYING = "modifying",
    PARTIALLY_FULFILLED = "partially_fulfilled",
    SUBMITTED = "submitted"
}

export interface CapacityReservationFleetCancellationState {
    
    CurrentFleetState?: CapacityReservationFleetState | string;
    
    PreviousFleetState?: CapacityReservationFleetState | string;
    
    CapacityReservationFleetId?: string;
}
export declare namespace CapacityReservationFleetCancellationState {
    
    const filterSensitiveLog: (obj: CapacityReservationFleetCancellationState) => any;
}
export interface CancelCapacityReservationFleetsResult {
    
    SuccessfulFleetCancellations?: CapacityReservationFleetCancellationState[];
    
    FailedFleetCancellations?: FailedCapacityReservationFleetCancellationResult[];
}
export declare namespace CancelCapacityReservationFleetsResult {
    
    const filterSensitiveLog: (obj: CancelCapacityReservationFleetsResult) => any;
}
export interface CancelConversionRequest {
    
    ConversionTaskId: string | undefined;
    
    DryRun?: boolean;
    
    ReasonMessage?: string;
}
export declare namespace CancelConversionRequest {
    
    const filterSensitiveLog: (obj: CancelConversionRequest) => any;
}
export interface CancelExportTaskRequest {
    
    ExportTaskId: string | undefined;
}
export declare namespace CancelExportTaskRequest {
    
    const filterSensitiveLog: (obj: CancelExportTaskRequest) => any;
}
export interface CancelImportTaskRequest {
    
    CancelReason?: string;
    
    DryRun?: boolean;
    
    ImportTaskId?: string;
}
export declare namespace CancelImportTaskRequest {
    
    const filterSensitiveLog: (obj: CancelImportTaskRequest) => any;
}
export interface CancelImportTaskResult {
    
    ImportTaskId?: string;
    
    PreviousState?: string;
    
    State?: string;
}
export declare namespace CancelImportTaskResult {
    
    const filterSensitiveLog: (obj: CancelImportTaskResult) => any;
}

export interface CancelReservedInstancesListingRequest {
    
    ReservedInstancesListingId: string | undefined;
}
export declare namespace CancelReservedInstancesListingRequest {
    
    const filterSensitiveLog: (obj: CancelReservedInstancesListingRequest) => any;
}
export declare type ListingState = "available" | "cancelled" | "pending" | "sold";

export interface InstanceCount {
    
    InstanceCount?: number;
    
    State?: ListingState | string;
}
export declare namespace InstanceCount {
    
    const filterSensitiveLog: (obj: InstanceCount) => any;
}
export declare type CurrencyCodeValues = "USD";

export interface PriceSchedule {
    
    Active?: boolean;
    
    CurrencyCode?: CurrencyCodeValues | string;
    
    Price?: number;
    
    Term?: number;
}
export declare namespace PriceSchedule {
    
    const filterSensitiveLog: (obj: PriceSchedule) => any;
}
export declare type ListingStatus = "active" | "cancelled" | "closed" | "pending";

export interface ReservedInstancesListing {
    
    ClientToken?: string;
    
    CreateDate?: Date;
    
    InstanceCounts?: InstanceCount[];
    
    PriceSchedules?: PriceSchedule[];
    
    ReservedInstancesId?: string;
    
    ReservedInstancesListingId?: string;
    
    Status?: ListingStatus | string;
    
    StatusMessage?: string;
    
    Tags?: Tag[];
    
    UpdateDate?: Date;
}
export declare namespace ReservedInstancesListing {
    
    const filterSensitiveLog: (obj: ReservedInstancesListing) => any;
}

export interface CancelReservedInstancesListingResult {
    
    ReservedInstancesListings?: ReservedInstancesListing[];
}
export declare namespace CancelReservedInstancesListingResult {
    
    const filterSensitiveLog: (obj: CancelReservedInstancesListingResult) => any;
}

export interface CancelSpotFleetRequestsRequest {
    
    DryRun?: boolean;
    
    SpotFleetRequestIds: string[] | undefined;
    
    TerminateInstances: boolean | undefined;
}
export declare namespace CancelSpotFleetRequestsRequest {
    
    const filterSensitiveLog: (obj: CancelSpotFleetRequestsRequest) => any;
}
export declare enum BatchState {
    ACTIVE = "active",
    CANCELLED = "cancelled",
    CANCELLED_RUNNING = "cancelled_running",
    CANCELLED_TERMINATING_INSTANCES = "cancelled_terminating",
    FAILED = "failed",
    MODIFYING = "modifying",
    SUBMITTED = "submitted"
}

export interface CancelSpotFleetRequestsSuccessItem {
    
    CurrentSpotFleetRequestState?: BatchState | string;
    
    PreviousSpotFleetRequestState?: BatchState | string;
    
    SpotFleetRequestId?: string;
}
export declare namespace CancelSpotFleetRequestsSuccessItem {
    
    const filterSensitiveLog: (obj: CancelSpotFleetRequestsSuccessItem) => any;
}
export declare enum CancelBatchErrorCode {
    FLEET_REQUEST_ID_DOES_NOT_EXIST = "fleetRequestIdDoesNotExist",
    FLEET_REQUEST_ID_MALFORMED = "fleetRequestIdMalformed",
    FLEET_REQUEST_NOT_IN_CANCELLABLE_STATE = "fleetRequestNotInCancellableState",
    UNEXPECTED_ERROR = "unexpectedError"
}

export interface CancelSpotFleetRequestsError {
    
    Code?: CancelBatchErrorCode | string;
    
    Message?: string;
}
export declare namespace CancelSpotFleetRequestsError {
    
    const filterSensitiveLog: (obj: CancelSpotFleetRequestsError) => any;
}

export interface CancelSpotFleetRequestsErrorItem {
    
    Error?: CancelSpotFleetRequestsError;
    
    SpotFleetRequestId?: string;
}
export declare namespace CancelSpotFleetRequestsErrorItem {
    
    const filterSensitiveLog: (obj: CancelSpotFleetRequestsErrorItem) => any;
}

export interface CancelSpotFleetRequestsResponse {
    
    SuccessfulFleetRequests?: CancelSpotFleetRequestsSuccessItem[];
    
    UnsuccessfulFleetRequests?: CancelSpotFleetRequestsErrorItem[];
}
export declare namespace CancelSpotFleetRequestsResponse {
    
    const filterSensitiveLog: (obj: CancelSpotFleetRequestsResponse) => any;
}

export interface CancelSpotInstanceRequestsRequest {
    
    DryRun?: boolean;
    
    SpotInstanceRequestIds: string[] | undefined;
}
export declare namespace CancelSpotInstanceRequestsRequest {
    
    const filterSensitiveLog: (obj: CancelSpotInstanceRequestsRequest) => any;
}
export declare type CancelSpotInstanceRequestState = "active" | "cancelled" | "closed" | "completed" | "open";

export interface CancelledSpotInstanceRequest {
    
    SpotInstanceRequestId?: string;
    
    State?: CancelSpotInstanceRequestState | string;
}
export declare namespace CancelledSpotInstanceRequest {
    
    const filterSensitiveLog: (obj: CancelledSpotInstanceRequest) => any;
}

export interface CancelSpotInstanceRequestsResult {
    
    CancelledSpotInstanceRequests?: CancelledSpotInstanceRequest[];
}
export declare namespace CancelSpotInstanceRequestsResult {
    
    const filterSensitiveLog: (obj: CancelSpotInstanceRequestsResult) => any;
}
export interface ConfirmProductInstanceRequest {
    
    InstanceId: string | undefined;
    
    ProductCode: string | undefined;
    
    DryRun?: boolean;
}
export declare namespace ConfirmProductInstanceRequest {
    
    const filterSensitiveLog: (obj: ConfirmProductInstanceRequest) => any;
}
export interface ConfirmProductInstanceResult {
    
    OwnerId?: string;
    
    Return?: boolean;
}
export declare namespace ConfirmProductInstanceResult {
    
    const filterSensitiveLog: (obj: ConfirmProductInstanceResult) => any;
}
export interface CopyFpgaImageRequest {
    
    DryRun?: boolean;
    
    SourceFpgaImageId: string | undefined;
    
    Description?: string;
    
    Name?: string;
    
    SourceRegion: string | undefined;
    
    ClientToken?: string;
}
export declare namespace CopyFpgaImageRequest {
    
    const filterSensitiveLog: (obj: CopyFpgaImageRequest) => any;
}
export interface CopyFpgaImageResult {
    
    FpgaImageId?: string;
}
export declare namespace CopyFpgaImageResult {
    
    const filterSensitiveLog: (obj: CopyFpgaImageResult) => any;
}

export interface CopyImageRequest {
    
    ClientToken?: string;
    
    Description?: string;
    
    Encrypted?: boolean;
    
    KmsKeyId?: string;
    
    Name: string | undefined;
    
    SourceImageId: string | undefined;
    
    SourceRegion: string | undefined;
    
    DestinationOutpostArn?: string;
    
    DryRun?: boolean;
}
export declare namespace CopyImageRequest {
    
    const filterSensitiveLog: (obj: CopyImageRequest) => any;
}

export interface CopyImageResult {
    
    ImageId?: string;
}
export declare namespace CopyImageResult {
    
    const filterSensitiveLog: (obj: CopyImageResult) => any;
}
export interface CopySnapshotRequest {
    
    Description?: string;
    
    DestinationOutpostArn?: string;
    
    DestinationRegion?: string;
    
    Encrypted?: boolean;
    
    KmsKeyId?: string;
    
    PresignedUrl?: string;
    
    SourceRegion: string | undefined;
    
    SourceSnapshotId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CopySnapshotRequest {
    
    const filterSensitiveLog: (obj: CopySnapshotRequest) => any;
}
export interface CopySnapshotResult {
    
    SnapshotId?: string;
    
    Tags?: Tag[];
}
export declare namespace CopySnapshotResult {
    
    const filterSensitiveLog: (obj: CopySnapshotResult) => any;
}
export declare type EndDateType = "limited" | "unlimited";
export declare type InstanceMatchCriteria = "open" | "targeted";
export declare enum CapacityReservationInstancePlatform {
    LINUX_UNIX = "Linux/UNIX",
    LINUX_WITH_SQL_SERVER_ENTERPRISE = "Linux with SQL Server Enterprise",
    LINUX_WITH_SQL_SERVER_STANDARD = "Linux with SQL Server Standard",
    LINUX_WITH_SQL_SERVER_WEB = "Linux with SQL Server Web",
    RED_HAT_ENTERPRISE_LINUX = "Red Hat Enterprise Linux",
    SUSE_LINUX = "SUSE Linux",
    WINDOWS = "Windows",
    WINDOWS_WITH_SQL_SERVER = "Windows with SQL Server",
    WINDOWS_WITH_SQL_SERVER_ENTERPRISE = "Windows with SQL Server Enterprise",
    WINDOWS_WITH_SQL_SERVER_STANDARD = "Windows with SQL Server Standard",
    WINDOWS_WITH_SQL_SERVER_WEB = "Windows with SQL Server Web"
}
export declare type CapacityReservationTenancy = "dedicated" | "default";
export interface CreateCapacityReservationRequest {
    
    ClientToken?: string;
    
    InstanceType: string | undefined;
    
    InstancePlatform: CapacityReservationInstancePlatform | string | undefined;
    
    AvailabilityZone?: string;
    
    AvailabilityZoneId?: string;
    
    Tenancy?: CapacityReservationTenancy | string;
    
    InstanceCount: number | undefined;
    
    EbsOptimized?: boolean;
    
    EphemeralStorage?: boolean;
    
    EndDate?: Date;
    
    EndDateType?: EndDateType | string;
    
    InstanceMatchCriteria?: InstanceMatchCriteria | string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    OutpostArn?: string;
}
export declare namespace CreateCapacityReservationRequest {
    
    const filterSensitiveLog: (obj: CreateCapacityReservationRequest) => any;
}
export declare type CapacityReservationState = "active" | "cancelled" | "expired" | "failed" | "pending";

export interface CapacityReservation {
    
    CapacityReservationId?: string;
    
    OwnerId?: string;
    
    CapacityReservationArn?: string;
    
    AvailabilityZoneId?: string;
    
    InstanceType?: string;
    
    InstancePlatform?: CapacityReservationInstancePlatform | string;
    
    AvailabilityZone?: string;
    
    Tenancy?: CapacityReservationTenancy | string;
    
    TotalInstanceCount?: number;
    
    AvailableInstanceCount?: number;
    
    EbsOptimized?: boolean;
    
    EphemeralStorage?: boolean;
    
    State?: CapacityReservationState | string;
    
    StartDate?: Date;
    
    EndDate?: Date;
    
    EndDateType?: EndDateType | string;
    
    InstanceMatchCriteria?: InstanceMatchCriteria | string;
    
    CreateDate?: Date;
    
    Tags?: Tag[];
    
    OutpostArn?: string;
    
    CapacityReservationFleetId?: string;
}
export declare namespace CapacityReservation {
    
    const filterSensitiveLog: (obj: CapacityReservation) => any;
}
export interface CreateCapacityReservationResult {
    
    CapacityReservation?: CapacityReservation;
}
export declare namespace CreateCapacityReservationResult {
    
    const filterSensitiveLog: (obj: CreateCapacityReservationResult) => any;
}
export declare enum FleetInstanceMatchCriteria {
    open = "open"
}
export declare type _InstanceType = "a1.2xlarge" | "a1.4xlarge" | "a1.large" | "a1.medium" | "a1.metal" | "a1.xlarge" | "c1.medium" | "c1.xlarge" | "c3.2xlarge" | "c3.4xlarge" | "c3.8xlarge" | "c3.large" | "c3.xlarge" | "c4.2xlarge" | "c4.4xlarge" | "c4.8xlarge" | "c4.large" | "c4.xlarge" | "c5.12xlarge" | "c5.18xlarge" | "c5.24xlarge" | "c5.2xlarge" | "c5.4xlarge" | "c5.9xlarge" | "c5.large" | "c5.metal" | "c5.xlarge" | "c5a.12xlarge" | "c5a.16xlarge" | "c5a.24xlarge" | "c5a.2xlarge" | "c5a.4xlarge" | "c5a.8xlarge" | "c5a.large" | "c5a.xlarge" | "c5ad.12xlarge" | "c5ad.16xlarge" | "c5ad.24xlarge" | "c5ad.2xlarge" | "c5ad.4xlarge" | "c5ad.8xlarge" | "c5ad.large" | "c5ad.xlarge" | "c5d.12xlarge" | "c5d.18xlarge" | "c5d.24xlarge" | "c5d.2xlarge" | "c5d.4xlarge" | "c5d.9xlarge" | "c5d.large" | "c5d.metal" | "c5d.xlarge" | "c5n.18xlarge" | "c5n.2xlarge" | "c5n.4xlarge" | "c5n.9xlarge" | "c5n.large" | "c5n.metal" | "c5n.xlarge" | "c6g.12xlarge" | "c6g.16xlarge" | "c6g.2xlarge" | "c6g.4xlarge" | "c6g.8xlarge" | "c6g.large" | "c6g.medium" | "c6g.metal" | "c6g.xlarge" | "c6gd.12xlarge" | "c6gd.16xlarge" | "c6gd.2xlarge" | "c6gd.4xlarge" | "c6gd.8xlarge" | "c6gd.large" | "c6gd.medium" | "c6gd.metal" | "c6gd.xlarge" | "c6gn.12xlarge" | "c6gn.16xlarge" | "c6gn.2xlarge" | "c6gn.4xlarge" | "c6gn.8xlarge" | "c6gn.large" | "c6gn.medium" | "c6gn.xlarge" | "c6i.12xlarge" | "c6i.16xlarge" | "c6i.24xlarge" | "c6i.2xlarge" | "c6i.32xlarge" | "c6i.4xlarge" | "c6i.8xlarge" | "c6i.large" | "c6i.xlarge" | "cc1.4xlarge" | "cc2.8xlarge" | "cg1.4xlarge" | "cr1.8xlarge" | "d2.2xlarge" | "d2.4xlarge" | "d2.8xlarge" | "d2.xlarge" | "d3.2xlarge" | "d3.4xlarge" | "d3.8xlarge" | "d3.xlarge" | "d3en.12xlarge" | "d3en.2xlarge" | "d3en.4xlarge" | "d3en.6xlarge" | "d3en.8xlarge" | "d3en.xlarge" | "dl1.24xlarge" | "f1.16xlarge" | "f1.2xlarge" | "f1.4xlarge" | "g2.2xlarge" | "g2.8xlarge" | "g3.16xlarge" | "g3.4xlarge" | "g3.8xlarge" | "g3s.xlarge" | "g4ad.16xlarge" | "g4ad.2xlarge" | "g4ad.4xlarge" | "g4ad.8xlarge" | "g4ad.xlarge" | "g4dn.12xlarge" | "g4dn.16xlarge" | "g4dn.2xlarge" | "g4dn.4xlarge" | "g4dn.8xlarge" | "g4dn.metal" | "g4dn.xlarge" | "g5.12xlarge" | "g5.16xlarge" | "g5.24xlarge" | "g5.2xlarge" | "g5.48xlarge" | "g5.4xlarge" | "g5.8xlarge" | "g5.xlarge" | "g5g.16xlarge" | "g5g.2xlarge" | "g5g.4xlarge" | "g5g.8xlarge" | "g5g.metal" | "g5g.xlarge" | "h1.16xlarge" | "h1.2xlarge" | "h1.4xlarge" | "h1.8xlarge" | "hi1.4xlarge" | "hs1.8xlarge" | "i2.2xlarge" | "i2.4xlarge" | "i2.8xlarge" | "i2.xlarge" | "i3.16xlarge" | "i3.2xlarge" | "i3.4xlarge" | "i3.8xlarge" | "i3.large" | "i3.metal" | "i3.xlarge" | "i3en.12xlarge" | "i3en.24xlarge" | "i3en.2xlarge" | "i3en.3xlarge" | "i3en.6xlarge" | "i3en.large" | "i3en.metal" | "i3en.xlarge" | "im4gn.16xlarge" | "im4gn.2xlarge" | "im4gn.4xlarge" | "im4gn.8xlarge" | "im4gn.large" | "im4gn.xlarge" | "inf1.24xlarge" | "inf1.2xlarge" | "inf1.6xlarge" | "inf1.xlarge" | "is4gen.2xlarge" | "is4gen.4xlarge" | "is4gen.8xlarge" | "is4gen.large" | "is4gen.medium" | "is4gen.xlarge" | "m1.large" | "m1.medium" | "m1.small" | "m1.xlarge" | "m2.2xlarge" | "m2.4xlarge" | "m2.xlarge" | "m3.2xlarge" | "m3.large" | "m3.medium" | "m3.xlarge" | "m4.10xlarge" | "m4.16xlarge" | "m4.2xlarge" | "m4.4xlarge" | "m4.large" | "m4.xlarge" | "m5.12xlarge" | "m5.16xlarge" | "m5.24xlarge" | "m5.2xlarge" | "m5.4xlarge" | "m5.8xlarge" | "m5.large" | "m5.metal" | "m5.xlarge" | "m5a.12xlarge" | "m5a.16xlarge" | "m5a.24xlarge" | "m5a.2xlarge" | "m5a.4xlarge" | "m5a.8xlarge" | "m5a.large" | "m5a.xlarge" | "m5ad.12xlarge" | "m5ad.16xlarge" | "m5ad.24xlarge" | "m5ad.2xlarge" | "m5ad.4xlarge" | "m5ad.8xlarge" | "m5ad.large" | "m5ad.xlarge" | "m5d.12xlarge" | "m5d.16xlarge" | "m5d.24xlarge" | "m5d.2xlarge" | "m5d.4xlarge" | "m5d.8xlarge" | "m5d.large" | "m5d.metal" | "m5d.xlarge" | "m5dn.12xlarge" | "m5dn.16xlarge" | "m5dn.24xlarge" | "m5dn.2xlarge" | "m5dn.4xlarge" | "m5dn.8xlarge" | "m5dn.large" | "m5dn.metal" | "m5dn.xlarge" | "m5n.12xlarge" | "m5n.16xlarge" | "m5n.24xlarge" | "m5n.2xlarge" | "m5n.4xlarge" | "m5n.8xlarge" | "m5n.large" | "m5n.metal" | "m5n.xlarge" | "m5zn.12xlarge" | "m5zn.2xlarge" | "m5zn.3xlarge" | "m5zn.6xlarge" | "m5zn.large" | "m5zn.metal" | "m5zn.xlarge" | "m6a.12xlarge" | "m6a.16xlarge" | "m6a.24xlarge" | "m6a.2xlarge" | "m6a.32xlarge" | "m6a.48xlarge" | "m6a.4xlarge" | "m6a.8xlarge" | "m6a.large" | "m6a.xlarge" | "m6g.12xlarge" | "m6g.16xlarge" | "m6g.2xlarge" | "m6g.4xlarge" | "m6g.8xlarge" | "m6g.large" | "m6g.medium" | "m6g.metal" | "m6g.xlarge" | "m6gd.12xlarge" | "m6gd.16xlarge" | "m6gd.2xlarge" | "m6gd.4xlarge" | "m6gd.8xlarge" | "m6gd.large" | "m6gd.medium" | "m6gd.metal" | "m6gd.xlarge" | "m6i.12xlarge" | "m6i.16xlarge" | "m6i.24xlarge" | "m6i.2xlarge" | "m6i.32xlarge" | "m6i.4xlarge" | "m6i.8xlarge" | "m6i.large" | "m6i.xlarge" | "mac1.metal" | "p2.16xlarge" | "p2.8xlarge" | "p2.xlarge" | "p3.16xlarge" | "p3.2xlarge" | "p3.8xlarge" | "p3dn.24xlarge" | "p4d.24xlarge" | "r3.2xlarge" | "r3.4xlarge" | "r3.8xlarge" | "r3.large" | "r3.xlarge" | "r4.16xlarge" | "r4.2xlarge" | "r4.4xlarge" | "r4.8xlarge" | "r4.large" | "r4.xlarge" | "r5.12xlarge" | "r5.16xlarge" | "r5.24xlarge" | "r5.2xlarge" | "r5.4xlarge" | "r5.8xlarge" | "r5.large" | "r5.metal" | "r5.xlarge" | "r5a.12xlarge" | "r5a.16xlarge" | "r5a.24xlarge" | "r5a.2xlarge" | "r5a.4xlarge" | "r5a.8xlarge" | "r5a.large" | "r5a.xlarge" | "r5ad.12xlarge" | "r5ad.16xlarge" | "r5ad.24xlarge" | "r5ad.2xlarge" | "r5ad.4xlarge" | "r5ad.8xlarge" | "r5ad.large" | "r5ad.xlarge" | "r5b.12xlarge" | "r5b.16xlarge" | "r5b.24xlarge" | "r5b.2xlarge" | "r5b.4xlarge" | "r5b.8xlarge" | "r5b.large" | "r5b.metal" | "r5b.xlarge" | "r5d.12xlarge" | "r5d.16xlarge" | "r5d.24xlarge" | "r5d.2xlarge" | "r5d.4xlarge" | "r5d.8xlarge" | "r5d.large" | "r5d.metal" | "r5d.xlarge" | "r5dn.12xlarge" | "r5dn.16xlarge" | "r5dn.24xlarge" | "r5dn.2xlarge" | "r5dn.4xlarge" | "r5dn.8xlarge" | "r5dn.large" | "r5dn.metal" | "r5dn.xlarge" | "r5n.12xlarge" | "r5n.16xlarge" | "r5n.24xlarge" | "r5n.2xlarge" | "r5n.4xlarge" | "r5n.8xlarge" | "r5n.large" | "r5n.metal" | "r5n.xlarge" | "r6g.12xlarge" | "r6g.16xlarge" | "r6g.2xlarge" | "r6g.4xlarge" | "r6g.8xlarge" | "r6g.large" | "r6g.medium" | "r6g.metal" | "r6g.xlarge" | "r6gd.12xlarge" | "r6gd.16xlarge" | "r6gd.2xlarge" | "r6gd.4xlarge" | "r6gd.8xlarge" | "r6gd.large" | "r6gd.medium" | "r6gd.metal" | "r6gd.xlarge" | "t1.micro" | "t2.2xlarge" | "t2.large" | "t2.medium" | "t2.micro" | "t2.nano" | "t2.small" | "t2.xlarge" | "t3.2xlarge" | "t3.large" | "t3.medium" | "t3.micro" | "t3.nano" | "t3.small" | "t3.xlarge" | "t3a.2xlarge" | "t3a.large" | "t3a.medium" | "t3a.micro" | "t3a.nano" | "t3a.small" | "t3a.xlarge" | "t4g.2xlarge" | "t4g.large" | "t4g.medium" | "t4g.micro" | "t4g.nano" | "t4g.small" | "t4g.xlarge" | "u-12tb1.112xlarge" | "u-12tb1.metal" | "u-18tb1.metal" | "u-24tb1.metal" | "u-6tb1.112xlarge" | "u-6tb1.56xlarge" | "u-6tb1.metal" | "u-9tb1.112xlarge" | "u-9tb1.metal" | "vt1.24xlarge" | "vt1.3xlarge" | "vt1.6xlarge" | "x1.16xlarge" | "x1.32xlarge" | "x1e.16xlarge" | "x1e.2xlarge" | "x1e.32xlarge" | "x1e.4xlarge" | "x1e.8xlarge" | "x1e.xlarge" | "x2gd.12xlarge" | "x2gd.16xlarge" | "x2gd.2xlarge" | "x2gd.4xlarge" | "x2gd.8xlarge" | "x2gd.large" | "x2gd.medium" | "x2gd.metal" | "x2gd.xlarge" | "z1d.12xlarge" | "z1d.2xlarge" | "z1d.3xlarge" | "z1d.6xlarge" | "z1d.large" | "z1d.metal" | "z1d.xlarge";

export interface ReservationFleetInstanceSpecification {
    
    InstanceType?: _InstanceType | string;
    
    InstancePlatform?: CapacityReservationInstancePlatform | string;
    
    Weight?: number;
    
    AvailabilityZone?: string;
    
    AvailabilityZoneId?: string;
    
    EbsOptimized?: boolean;
    
    Priority?: number;
}
export declare namespace ReservationFleetInstanceSpecification {
    
    const filterSensitiveLog: (obj: ReservationFleetInstanceSpecification) => any;
}
export declare enum FleetCapacityReservationTenancy {
    default = "default"
}
export interface CreateCapacityReservationFleetRequest {
    
    AllocationStrategy?: string;
    
    ClientToken?: string;
    
    InstanceTypeSpecifications: ReservationFleetInstanceSpecification[] | undefined;
    
    Tenancy?: FleetCapacityReservationTenancy | string;
    
    TotalTargetCapacity: number | undefined;
    
    EndDate?: Date;
    
    InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateCapacityReservationFleetRequest {
    
    const filterSensitiveLog: (obj: CreateCapacityReservationFleetRequest) => any;
}

export interface FleetCapacityReservation {
    
    CapacityReservationId?: string;
    
    AvailabilityZoneId?: string;
    
    InstanceType?: _InstanceType | string;
    
    InstancePlatform?: CapacityReservationInstancePlatform | string;
    
    AvailabilityZone?: string;
    
    TotalInstanceCount?: number;
    
    FulfilledCapacity?: number;
    
    EbsOptimized?: boolean;
    
    CreateDate?: Date;
    
    Weight?: number;
    
    Priority?: number;
}
export declare namespace FleetCapacityReservation {
    
    const filterSensitiveLog: (obj: FleetCapacityReservation) => any;
}
export interface CreateCapacityReservationFleetResult {
    
    CapacityReservationFleetId?: string;
    
    State?: CapacityReservationFleetState | string;
    
    TotalTargetCapacity?: number;
    
    TotalFulfilledCapacity?: number;
    
    InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
    
    AllocationStrategy?: string;
    
    CreateTime?: Date;
    
    EndDate?: Date;
    
    Tenancy?: FleetCapacityReservationTenancy | string;
    
    FleetCapacityReservations?: FleetCapacityReservation[];
    
    Tags?: Tag[];
}
export declare namespace CreateCapacityReservationFleetResult {
    
    const filterSensitiveLog: (obj: CreateCapacityReservationFleetResult) => any;
}
export interface CreateCarrierGatewayRequest {
    
    VpcId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace CreateCarrierGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateCarrierGatewayRequest) => any;
}
export declare type CarrierGatewayState = "available" | "deleted" | "deleting" | "pending";

export interface CarrierGateway {
    
    CarrierGatewayId?: string;
    
    VpcId?: string;
    
    State?: CarrierGatewayState | string;
    
    OwnerId?: string;
    
    Tags?: Tag[];
}
export declare namespace CarrierGateway {
    
    const filterSensitiveLog: (obj: CarrierGateway) => any;
}
export interface CreateCarrierGatewayResult {
    
    CarrierGateway?: CarrierGateway;
}
export declare namespace CreateCarrierGatewayResult {
    
    const filterSensitiveLog: (obj: CreateCarrierGatewayResult) => any;
}

export interface DirectoryServiceAuthenticationRequest {
    
    DirectoryId?: string;
}
export declare namespace DirectoryServiceAuthenticationRequest {
    
    const filterSensitiveLog: (obj: DirectoryServiceAuthenticationRequest) => any;
}

export interface FederatedAuthenticationRequest {
    
    SAMLProviderArn?: string;
    
    SelfServiceSAMLProviderArn?: string;
}
export declare namespace FederatedAuthenticationRequest {
    
    const filterSensitiveLog: (obj: FederatedAuthenticationRequest) => any;
}

export interface CertificateAuthenticationRequest {
    
    ClientRootCertificateChainArn?: string;
}
export declare namespace CertificateAuthenticationRequest {
    
    const filterSensitiveLog: (obj: CertificateAuthenticationRequest) => any;
}
export declare type ClientVpnAuthenticationType = "certificate-authentication" | "directory-service-authentication" | "federated-authentication";

export interface ClientVpnAuthenticationRequest {
    
    Type?: ClientVpnAuthenticationType | string;
    
    ActiveDirectory?: DirectoryServiceAuthenticationRequest;
    
    MutualAuthentication?: CertificateAuthenticationRequest;
    
    FederatedAuthentication?: FederatedAuthenticationRequest;
}
export declare namespace ClientVpnAuthenticationRequest {
    
    const filterSensitiveLog: (obj: ClientVpnAuthenticationRequest) => any;
}

export interface ClientConnectOptions {
    
    Enabled?: boolean;
    
    LambdaFunctionArn?: string;
}
export declare namespace ClientConnectOptions {
    
    const filterSensitiveLog: (obj: ClientConnectOptions) => any;
}

export interface ConnectionLogOptions {
    
    Enabled?: boolean;
    
    CloudwatchLogGroup?: string;
    
    CloudwatchLogStream?: string;
}
export declare namespace ConnectionLogOptions {
    
    const filterSensitiveLog: (obj: ConnectionLogOptions) => any;
}
export declare type SelfServicePortal = "disabled" | "enabled";
export declare type TransportProtocol = "tcp" | "udp";
export interface CreateClientVpnEndpointRequest {
    
    ClientCidrBlock: string | undefined;
    
    ServerCertificateArn: string | undefined;
    
    AuthenticationOptions: ClientVpnAuthenticationRequest[] | undefined;
    
    ConnectionLogOptions: ConnectionLogOptions | undefined;
    
    DnsServers?: string[];
    
    TransportProtocol?: TransportProtocol | string;
    
    VpnPort?: number;
    
    Description?: string;
    
    SplitTunnel?: boolean;
    
    DryRun?: boolean;
    
    ClientToken?: string;
    
    TagSpecifications?: TagSpecification[];
    
    SecurityGroupIds?: string[];
    
    VpcId?: string;
    
    SelfServicePortal?: SelfServicePortal | string;
    
    ClientConnectOptions?: ClientConnectOptions;
}
export declare namespace CreateClientVpnEndpointRequest {
    
    const filterSensitiveLog: (obj: CreateClientVpnEndpointRequest) => any;
}
export declare type ClientVpnEndpointStatusCode = "available" | "deleted" | "deleting" | "pending-associate";

export interface ClientVpnEndpointStatus {
    
    Code?: ClientVpnEndpointStatusCode | string;
    
    Message?: string;
}
export declare namespace ClientVpnEndpointStatus {
    
    const filterSensitiveLog: (obj: ClientVpnEndpointStatus) => any;
}
export interface CreateClientVpnEndpointResult {
    
    ClientVpnEndpointId?: string;
    
    Status?: ClientVpnEndpointStatus;
    
    DnsName?: string;
}
export declare namespace CreateClientVpnEndpointResult {
    
    const filterSensitiveLog: (obj: CreateClientVpnEndpointResult) => any;
}
export interface CreateClientVpnRouteRequest {
    
    ClientVpnEndpointId: string | undefined;
    
    DestinationCidrBlock: string | undefined;
    
    TargetVpcSubnetId: string | undefined;
    
    Description?: string;
    
    ClientToken?: string;
    
    DryRun?: boolean;
}
export declare namespace CreateClientVpnRouteRequest {
    
    const filterSensitiveLog: (obj: CreateClientVpnRouteRequest) => any;
}
export declare type ClientVpnRouteStatusCode = "active" | "creating" | "deleting" | "failed";

export interface ClientVpnRouteStatus {
    
    Code?: ClientVpnRouteStatusCode | string;
    
    Message?: string;
}
export declare namespace ClientVpnRouteStatus {
    
    const filterSensitiveLog: (obj: ClientVpnRouteStatus) => any;
}
export interface CreateClientVpnRouteResult {
    
    Status?: ClientVpnRouteStatus;
}
export declare namespace CreateClientVpnRouteResult {
    
    const filterSensitiveLog: (obj: CreateClientVpnRouteResult) => any;
}
export declare type GatewayType = "ipsec.1";

export interface CreateCustomerGatewayRequest {
    
    BgpAsn: number | undefined;
    
    PublicIp?: string;
    
    CertificateArn?: string;
    
    Type: GatewayType | string | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DeviceName?: string;
    
    DryRun?: boolean;
}
export declare namespace CreateCustomerGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateCustomerGatewayRequest) => any;
}

export interface CustomerGateway {
    
    BgpAsn?: string;
    
    CustomerGatewayId?: string;
    
    IpAddress?: string;
    
    CertificateArn?: string;
    
    State?: string;
    
    Type?: string;
    
    DeviceName?: string;
    
    Tags?: Tag[];
}
export declare namespace CustomerGateway {
    
    const filterSensitiveLog: (obj: CustomerGateway) => any;
}

export interface CreateCustomerGatewayResult {
    
    CustomerGateway?: CustomerGateway;
}
export declare namespace CreateCustomerGatewayResult {
    
    const filterSensitiveLog: (obj: CreateCustomerGatewayResult) => any;
}
export interface CreateDefaultSubnetRequest {
    
    AvailabilityZone: string | undefined;
    
    DryRun?: boolean;
    
    Ipv6Native?: boolean;
}
export declare namespace CreateDefaultSubnetRequest {
    
    const filterSensitiveLog: (obj: CreateDefaultSubnetRequest) => any;
}
export declare enum HostnameType {
    ip_name = "ip-name",
    resource_name = "resource-name"
}

export interface PrivateDnsNameOptionsOnLaunch {
    
    HostnameType?: HostnameType | string;
    
    EnableResourceNameDnsARecord?: boolean;
    
    EnableResourceNameDnsAAAARecord?: boolean;
}
export declare namespace PrivateDnsNameOptionsOnLaunch {
    
    const filterSensitiveLog: (obj: PrivateDnsNameOptionsOnLaunch) => any;
}
export declare type SubnetState = "available" | "pending";

export interface Subnet {
    
    AvailabilityZone?: string;
    
    AvailabilityZoneId?: string;
    
    AvailableIpAddressCount?: number;
    
    CidrBlock?: string;
    
    DefaultForAz?: boolean;
    
    EnableLniAtDeviceIndex?: number;
    
    MapPublicIpOnLaunch?: boolean;
    
    MapCustomerOwnedIpOnLaunch?: boolean;
    
    CustomerOwnedIpv4Pool?: string;
    
    State?: SubnetState | string;
    
    SubnetId?: string;
    
    VpcId?: string;
    
    OwnerId?: string;
    
    AssignIpv6AddressOnCreation?: boolean;
    
    Ipv6CidrBlockAssociationSet?: SubnetIpv6CidrBlockAssociation[];
    
    Tags?: Tag[];
    
    SubnetArn?: string;
    
    OutpostArn?: string;
    
    EnableDns64?: boolean;
    
    Ipv6Native?: boolean;
    
    PrivateDnsNameOptionsOnLaunch?: PrivateDnsNameOptionsOnLaunch;
}
export declare namespace Subnet {
    
    const filterSensitiveLog: (obj: Subnet) => any;
}
export interface CreateDefaultSubnetResult {
    
    Subnet?: Subnet;
}
export declare namespace CreateDefaultSubnetResult {
    
    const filterSensitiveLog: (obj: CreateDefaultSubnetResult) => any;
}
export interface CreateDefaultVpcRequest {
    
    DryRun?: boolean;
}
export declare namespace CreateDefaultVpcRequest {
    
    const filterSensitiveLog: (obj: CreateDefaultVpcRequest) => any;
}
export declare type Tenancy = "dedicated" | "default" | "host";
export declare type VpcState = "available" | "pending";

export interface Vpc {
    
    CidrBlock?: string;
    
    DhcpOptionsId?: string;
    
    State?: VpcState | string;
    
    VpcId?: string;
    
    OwnerId?: string;
    
    InstanceTenancy?: Tenancy | string;
    
    Ipv6CidrBlockAssociationSet?: VpcIpv6CidrBlockAssociation[];
    
    CidrBlockAssociationSet?: VpcCidrBlockAssociation[];
    
    IsDefault?: boolean;
    
    Tags?: Tag[];
}
export declare namespace Vpc {
    
    const filterSensitiveLog: (obj: Vpc) => any;
}
export interface CreateDefaultVpcResult {
    
    Vpc?: Vpc;
}
export declare namespace CreateDefaultVpcResult {
    
    const filterSensitiveLog: (obj: CreateDefaultVpcResult) => any;
}

export interface NewDhcpConfiguration {
    
    Key?: string;
    
    Values?: string[];
}
export declare namespace NewDhcpConfiguration {
    
    const filterSensitiveLog: (obj: NewDhcpConfiguration) => any;
}
export interface CreateDhcpOptionsRequest {
    
    DhcpConfigurations: NewDhcpConfiguration[] | undefined;
    
    TagSpecifications?: TagSpecification[];
    
    DryRun?: boolean;
}
export declare namespace CreateDhcpOptionsRequest {
    
    const filterSensitiveLog: (obj: CreateDhcpOptionsRequest) => any;
}

export interface AttributeValue {
    
    Value?: string;
}
export declare namespace AttributeValue {
    
    const filterSensitiveLog: (obj: AttributeValue) => any;
}

export interface DhcpConfiguration {
    
    Key?: string;
    
    Values?: AttributeValue[];
}
export declare namespace DhcpConfiguration {
    
    const filterSensitiveLog: (obj: DhcpConfiguration) => any;
}

export interface DhcpOptions {
    
    DhcpConfigurations?: DhcpConfiguration[];
    
    DhcpOptionsId?: string;
    
    OwnerId?: string;
    
    Tags?: Tag[];
}
export declare namespace DhcpOptions {
    
    const filterSensitiveLog: (obj: DhcpOptions) => any;
}
export interface CreateDhcpOptionsResult {
    
    DhcpOptions?: DhcpOptions;
}
export declare namespace CreateDhcpOptionsResult {
    
    const filterSensitiveLog: (obj: CreateDhcpOptionsResult) => any;
}
export interface CreateEgressOnlyInternetGatewayRequest {
    
    ClientToken?: string;
    
    DryRun?: boolean;
    
    VpcId: string | undefined;
    
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateEgressOnlyInternetGatewayRequest {
    
    const filterSensitiveLog: (obj: CreateEgressOnlyInternetGatewayRequest) => any;
}

export interface InternetGatewayAttachment {
    
    State?: AttachmentStatus | string;
    
    VpcId?: string;
}
export declare namespace InternetGatewayAttachment {
    
    const filterSensitiveLog: (obj: InternetGatewayAttachment) => any;
}

export interface EgressOnlyInternetGateway {
    
    Attachments?: InternetGatewayAttachment[];
    
    EgressOnlyInternetGatewayId?: string;
    
    Tags?: Tag[];
}
export declare namespace EgressOnlyInternetGateway {
    
    const filterSensitiveLog: (obj: EgressOnlyInternetGateway) => any;
}
export interface CreateEgressOnlyInternetGatewayResult {
    
    ClientToken?: string;
    
    EgressOnlyInternetGateway?: EgressOnlyInternetGateway;
}
export declare namespace CreateEgressOnlyInternetGatewayResult {
    
    const filterSensitiveLog: (obj: CreateEgressOnlyInternetGatewayResult) => any;
}
export declare enum FleetExcessCapacityTerminationPolicy {
    NO_TERMINATION = "no-termination",
    TERMINATION = "termination"
}

export interface FleetLaunchTemplateSpecificationRequest {
    
    LaunchTemplateId?: string;
    
    LaunchTemplateName?: string;
    
    Version?: string;
}
export declare namespace FleetLaunchTemplateSpecificationRequest {
    
    const filterSensitiveLog: (obj: FleetLaunchTemplateSpecificationRequest) => any;
}
export declare enum BareMetal {
    EXCLUDED = "excluded",
    INCLUDED = "included",
    REQUIRED = "required"
}

export interface BaselineEbsBandwidthMbpsRequest {
    
    Min?: number;
    
    Max?: number;
}
export declare namespace BaselineEbsBandwidthMbpsRequest {
    
    const filterSensitiveLog: (obj: BaselineEbsBandwidthMbpsRequest) => any;
}
export declare enum BurstablePerformance {
    EXCLUDED = "excluded",
    INCLUDED = "included",
    REQUIRED = "required"
}
export declare enum CpuManufacturer {
    AMAZON_WEB_SERVICES = "amazon-web-services",
    AMD = "amd",
    INTEL = "intel"
}
export declare enum InstanceGeneration {
    CURRENT = "current",
    PREVIOUS = "previous"
}
export declare enum LocalStorage {
    EXCLUDED = "excluded",
    INCLUDED = "included",
    REQUIRED = "required"
}
export declare enum LocalStorageType {
    HDD = "hdd",
    SSD = "ssd"
}
