import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { SearchLocalGatewayRoutesRequest, SearchLocalGatewayRoutesResult } from "../models/models_6";
export interface SearchLocalGatewayRoutesCommandInput extends SearchLocalGatewayRoutesRequest {
}
export interface SearchLocalGatewayRoutesCommandOutput extends SearchLocalGatewayRoutesResult, __MetadataBearer {
}

export declare class SearchLocalGatewayRoutesCommand extends $Command<SearchLocalGatewayRoutesCommandInput, SearchLocalGatewayRoutesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: SearchLocalGatewayRoutesCommandInput;
    constructor(input: SearchLocalGatewayRoutesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<SearchLocalGatewayRoutesCommandInput, SearchLocalGatewayRoutesCommandOutput>;
    private serialize;
    private deserialize;
}
