import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { Reservation } from "../models/models_3";
import { RunInstancesRequest } from "../models/models_6";
export interface RunInstancesCommandInput extends RunInstancesRequest {
}
export interface RunInstancesCommandOutput extends Reservation, __MetadataBearer {
}

export declare class RunInstancesCommand extends $Command<RunInstancesCommandInput, RunInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: RunInstancesCommandInput;
    constructor(input: RunInstancesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RunInstancesCommandInput, RunInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
