import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RevokeSecurityGroupEgressRequest, RevokeSecurityGroupEgressResult } from "../models/models_5";
export interface RevokeSecurityGroupEgressCommandInput extends RevokeSecurityGroupEgressRequest {
}
export interface RevokeSecurityGroupEgressCommandOutput extends RevokeSecurityGroupEgressResult, __MetadataBearer {
}

export declare class RevokeSecurityGroupEgressCommand extends $Command<RevokeSecurityGroupEgressCommandInput, RevokeSecurityGroupEgressCommandOutput, EC2ClientResolvedConfig> {
    readonly input: RevokeSecurityGroupEgressCommandInput;
    constructor(input: RevokeSecurityGroupEgressCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RevokeSecurityGroupEgressCommandInput, RevokeSecurityGroupEgressCommandOutput>;
    private serialize;
    private deserialize;
}
