import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { MonitorInstancesRequest, MonitorInstancesResult } from "../models/models_5";
export interface MonitorInstancesCommandInput extends MonitorInstancesRequest {
}
export interface MonitorInstancesCommandOutput extends MonitorInstancesResult, __MetadataBearer {
}

export declare class MonitorInstancesCommand extends $Command<MonitorInstancesCommandInput, MonitorInstancesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: MonitorInstancesCommandInput;
    constructor(input: MonitorInstancesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<MonitorInstancesCommandInput, MonitorInstancesCommandOutput>;
    private serialize;
    private deserialize;
}
