import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamResourceCidrsRequest, GetIpamResourceCidrsResult } from "../models/models_4";
export interface GetIpamResourceCidrsCommandInput extends GetIpamResourceCidrsRequest {
}
export interface GetIpamResourceCidrsCommandOutput extends GetIpamResourceCidrsResult, __MetadataBearer {
}

export declare class GetIpamResourceCidrsCommand extends $Command<GetIpamResourceCidrsCommandInput, GetIpamResourceCidrsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetIpamResourceCidrsCommandInput;
    constructor(input: GetIpamResourceCidrsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetIpamResourceCidrsCommandInput, GetIpamResourceCidrsCommandOutput>;
    private serialize;
    private deserialize;
}
