import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeVpcEndpointsRequest, DescribeVpcEndpointsResult } from "../models/models_4";
export interface DescribeVpcEndpointsCommandInput extends DescribeVpcEndpointsRequest {
}
export interface DescribeVpcEndpointsCommandOutput extends DescribeVpcEndpointsResult, __MetadataBearer {
}

export declare class DescribeVpcEndpointsCommand extends $Command<DescribeVpcEndpointsCommandInput, DescribeVpcEndpointsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeVpcEndpointsCommandInput;
    constructor(input: DescribeVpcEndpointsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeVpcEndpointsCommandInput, DescribeVpcEndpointsCommandOutput>;
    private serialize;
    private deserialize;
}
