import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeSubnetsRequest, DescribeSubnetsResult } from "../models/models_4";
export interface DescribeSubnetsCommandInput extends DescribeSubnetsRequest {
}
export interface DescribeSubnetsCommandOutput extends DescribeSubnetsResult, __MetadataBearer {
}

export declare class DescribeSubnetsCommand extends $Command<DescribeSubnetsCommandInput, DescribeSubnetsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeSubnetsCommandInput;
    constructor(input: DescribeSubnetsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeSubnetsCommandInput, DescribeSubnetsCommandOutput>;
    private serialize;
    private deserialize;
}
