import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeRouteTablesRequest, DescribeRouteTablesResult } from "../models/models_4";
export interface DescribeRouteTablesCommandInput extends DescribeRouteTablesRequest {
}
export interface DescribeRouteTablesCommandOutput extends DescribeRouteTablesResult, __MetadataBearer {
}

export declare class DescribeRouteTablesCommand extends $Command<DescribeRouteTablesCommandInput, DescribeRouteTablesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeRouteTablesCommandInput;
    constructor(input: DescribeRouteTablesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeRouteTablesCommandInput, DescribeRouteTablesCommandOutput>;
    private serialize;
    private deserialize;
}
