import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeKeyPairsRequest, DescribeKeyPairsResult } from "../models/models_3";
export interface DescribeKeyPairsCommandInput extends DescribeKeyPairsRequest {
}
export interface DescribeKeyPairsCommandOutput extends DescribeKeyPairsResult, __MetadataBearer {
}

export declare class DescribeKeyPairsCommand extends $Command<DescribeKeyPairsCommandInput, DescribeKeyPairsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeKeyPairsCommandInput;
    constructor(input: DescribeKeyPairsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeKeyPairsCommandInput, DescribeKeyPairsCommandOutput>;
    private serialize;
    private deserialize;
}
