import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeIpamScopesRequest, DescribeIpamScopesResult } from "../models/models_3";
export interface DescribeIpamScopesCommandInput extends DescribeIpamScopesRequest {
}
export interface DescribeIpamScopesCommandOutput extends DescribeIpamScopesResult, __MetadataBearer {
}

export declare class DescribeIpamScopesCommand extends $Command<DescribeIpamScopesCommandInput, DescribeIpamScopesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeIpamScopesCommandInput;
    constructor(input: DescribeIpamScopesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeIpamScopesCommandInput, DescribeIpamScopesCommandOutput>;
    private serialize;
    private deserialize;
}
