import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeInstanceTypesRequest, DescribeInstanceTypesResult } from "../models/models_3";
export interface DescribeInstanceTypesCommandInput extends DescribeInstanceTypesRequest {
}
export interface DescribeInstanceTypesCommandOutput extends DescribeInstanceTypesResult, __MetadataBearer {
}

export declare class DescribeInstanceTypesCommand extends $Command<DescribeInstanceTypesCommandInput, DescribeInstanceTypesCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeInstanceTypesCommandInput;
    constructor(input: DescribeInstanceTypesCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeInstanceTypesCommandInput, DescribeInstanceTypesCommandOutput>;
    private serialize;
    private deserialize;
}
