import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeFleetHistoryRequest, DescribeFleetHistoryResult } from "../models/models_3";
export interface DescribeFleetHistoryCommandInput extends DescribeFleetHistoryRequest {
}
export interface DescribeFleetHistoryCommandOutput extends DescribeFleetHistoryResult, __MetadataBearer {
}

export declare class DescribeFleetHistoryCommand extends $Command<DescribeFleetHistoryCommandInput, DescribeFleetHistoryCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeFleetHistoryCommandInput;
    constructor(input: DescribeFleetHistoryCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeFleetHistoryCommandInput, DescribeFleetHistoryCommandOutput>;
    private serialize;
    private deserialize;
}
