import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeDhcpOptionsRequest, DescribeDhcpOptionsResult } from "../models/models_3";
export interface DescribeDhcpOptionsCommandInput extends DescribeDhcpOptionsRequest {
}
export interface DescribeDhcpOptionsCommandOutput extends DescribeDhcpOptionsResult, __MetadataBearer {
}

export declare class DescribeDhcpOptionsCommand extends $Command<DescribeDhcpOptionsCommandInput, DescribeDhcpOptionsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeDhcpOptionsCommandInput;
    constructor(input: DescribeDhcpOptionsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeDhcpOptionsCommandInput, DescribeDhcpOptionsCommandOutput>;
    private serialize;
    private deserialize;
}
