import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeCapacityReservationsRequest, DescribeCapacityReservationsResult } from "../models/models_2";
export interface DescribeCapacityReservationsCommandInput extends DescribeCapacityReservationsRequest {
}
export interface DescribeCapacityReservationsCommandOutput extends DescribeCapacityReservationsResult, __MetadataBearer {
}

export declare class DescribeCapacityReservationsCommand extends $Command<DescribeCapacityReservationsCommandInput, DescribeCapacityReservationsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeCapacityReservationsCommandInput;
    constructor(input: DescribeCapacityReservationsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeCapacityReservationsCommandInput, DescribeCapacityReservationsCommandOutput>;
    private serialize;
    private deserialize;
}
