import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResult } from "../models/models_2";
export interface DeletePublicIpv4PoolCommandInput extends DeletePublicIpv4PoolRequest {
}
export interface DeletePublicIpv4PoolCommandOutput extends DeletePublicIpv4PoolResult, __MetadataBearer {
}

export declare class DeletePublicIpv4PoolCommand extends $Command<DeletePublicIpv4PoolCommandInput, DeletePublicIpv4PoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeletePublicIpv4PoolCommandInput;
    constructor(input: DeletePublicIpv4PoolCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeletePublicIpv4PoolCommandInput, DeletePublicIpv4PoolCommandOutput>;
    private serialize;
    private deserialize;
}
