import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateTransitGatewayRequest, CreateTransitGatewayResult } from "../models/models_1";
export interface CreateTransitGatewayCommandInput extends CreateTransitGatewayRequest {
}
export interface CreateTransitGatewayCommandOutput extends CreateTransitGatewayResult, __MetadataBearer {
}

export declare class CreateTransitGatewayCommand extends $Command<CreateTransitGatewayCommandInput, CreateTransitGatewayCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateTransitGatewayCommandInput;
    constructor(input: CreateTransitGatewayCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateTransitGatewayCommandInput, CreateTransitGatewayCommandOutput>;
    private serialize;
    private deserialize;
}
