import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateSecurityGroupRequest, CreateSecurityGroupResult } from "../models/models_1";
export interface CreateSecurityGroupCommandInput extends CreateSecurityGroupRequest {
}
export interface CreateSecurityGroupCommandOutput extends CreateSecurityGroupResult, __MetadataBearer {
}

export declare class CreateSecurityGroupCommand extends $Command<CreateSecurityGroupCommandInput, CreateSecurityGroupCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateSecurityGroupCommandInput;
    constructor(input: CreateSecurityGroupCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateSecurityGroupCommandInput, CreateSecurityGroupCommandOutput>;
    private serialize;
    private deserialize;
}
